/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/tools/SCCS/s.funny.c
 * Vers: 5.2    Time: 92/08/05, 14:47:12
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)funny.c	5.2 92/08/05";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#include <stdio.h>
#include <ctype.h>

/*********************************************************
*  NAME
*	funny - look for funny (cntrl) chars.
*
*  PURPOSE
*	Show what the Character contents of a file look like.
*
*	Example:
*	$ funny funny.c
*	Total chars = 2109
*	 Printable chars = 1857
*	 Funny chars = 252
*	  Cntrl-I, (ht) chars [0x09] = 146 
*	  Cntrl-J, (nl) chars [0x0a] = 106 
*
*  USE
*	C++ (1.2) cout stream sometimes inserts NULL chars into
*	output stream ?  Some printers (e.g. VAX LINE PRINTER),
*	don't handle NULLS so well.  Use with 'unfunny'
*	to strip out NULL or other funny chars.
*
*********************************************************/


struct cntrl {
	int count;
	char* name;
};

void
check (fp, add) /* copy file fp to standard output */

FILE *fp;
char add;

{
	int c, tmp;

	int total_char=0, printable_char=0, funny_char=0;
	int del_char=0;

	/* first 0x20 chars are cntrl chars */
	static struct cntrl cntrl_char[0x21] = {
	 {0, "nul"},	{0, "soh"},	{0, "stx"},	{0, "etx"},
	 {0, "eot"},	{0, "enq"},	{0, "ack"},	{0, "bel"},
	 {0, "bs"},	{0, "ht"},	{0, "nl"},	{0, "vt"}, 
	 {0, "ff"},	{0,"cr"},	{0, "so"},	{0, "si"},
	 {0, "dle"},	{0, "dc1"},	{0, "dc2"},	{0, "dc3"},
	 {0, "dc4"},	{0, "nak"},	{0, "syn"},	{0, "etb"},
	 {0, "can"},	{0, "em"},	{0, "sub"},	{0, "esc"},
	 {0, "fs"},	{0, "gs"},	{0, "rs"},	{0, "us"}
	};


	while ((c = getc(fp)) != EOF) {
		total_char++;
	
		if (isprint(c) != 0) 	/* printable */
			printable_char++;
		else {
			funny_char++;
			if (((char)c) == 0x7f)	/* del */
				del_char++;
			else {
				cntrl_char[c].count++;
			}
		}
	}

	printf ("Total chars = %d\n", total_char);
	printf (" Printable chars = %d\n", printable_char);
	printf (" Funny chars = %d\n", funny_char);

	if (del_char)
		printf ("  Del chars [0x7f] = %d\n", del_char);

	if (tmp = cntrl_char[0].count)
		printf ("  Null chars [0x00] = %d\n", tmp);

	for (c=1; c<=0x20; c++) {
		if (tmp = cntrl_char[c].count > 0) {
			printf ("  Cntrl-%c, (%s) chars [0x0%x] = %d \n", 
				(0x40+c), cntrl_char[c].name, c,
				cntrl_char[c].count );
		}
	}
}




main (argc, argv) /* cat: concatenate file */

int argc;
char *argv[];

{
	FILE *fp, *fopen();

	if (argc == 1) /* no args, copy standard input */
		check (stdin, 1);	/* 0 = strip, 1 = add ^M */
	else
		while (--argc > 0)
			if ((fp = fopen (*++argv, "r")) == NULL) {
				printf ("cat: can't open %s\n", *argv);
				break;
			}
			else {
				check (fp);
				fclose (fp);
			}
}

	
