/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/tools/SCCS/s.dingrep.cxx
 * Vers: 5.2    Time: 92/08/05, 14:47:17
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)dingrep.cxx	5.2 92/08/05";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/************************************************************************
dingrep.cxx

Reads otso log files and prints the input character
(surrounded by {{{ and }}}).

BUG: '}' is never printed.
************************************************************************/

#include "iostream.h"
#include "fstream.h"

void lookForInput(istream& is) {
  int c1 = 0;
  int c2 = 0;
  int c3 = 0;
  int yes = 0;

  while ((c1 = is.get()) != EOF) {
    if (c1=='}' && c2=='}' && c3=='}')
      yes = 0;
    if (yes && c1!='}') cout << (char)c1;	/* '}' never printed :( */
    if (c1=='{' && c2=='{' && c3=='{')
      yes = 1;
    c3 = c2;
    c2 = c1;
  }
}

main(int argc, char* argv[]) {

  if (argc == 1) {    /*read stdin*/
    lookForInput(cin);
    return 0;
  }
  
  while (*++argv) {
    ifstream is(*argv, ios::in);
    if (!is)
      cerr << "\n*****Cannot open file " << *argv << "\n";
    else {
      lookForInput(is);
    }
  }
  return 0;
}

