#######################################################################
# NAME 
#  RCC - remote CC (91/10/07 1.3)
#
# PURPOSE
#  Remotely executed (rsh CC) command exectued on tel2.tel.vtt.fi (Sun4)
#  from gra.vtt.fi (NeXT).  Implicitly uses NFS mounted dirs, shadow dirs, etc.
#  Run from OtsoShadow directory, modify remote path sed script
#  Otherwise.  Use: "CC -F" to produce .c files which are compilable
#  on gra.vtt.fi, otherwise you produce tel2 executables which aren't
#  all that intersting for use on gra.  
#
# BUGS
#  this is quite simplistic, it would be better to modify the CC
#  shell script to remotely execute cfront, cpp, etc.
#
#  Highly dependent on local environments (gra's shadow dir) and tel2
#  (e.g. include directories).
#
#  !!!!!! Not supported at all, For EXPERIMENTATION Purposes only !!!!!!
#
#  Questions can be directed to jfr@tel2.tel.vtt.fi
#
#######################################################################

#!/bin/sh

localPath=`pwd`

#remotePath=`echo $localPath | sed -e "s/\/private\/Net\/tel2.tel.vtt.fi\/home\/users\/otso\/official//"`
remotePath=`echo $localPath | sed -e "s/\/Users\/otso\/OtsoShadow/\/otso/"`

echo "/***********************************************************************"
echo "* NAME :"
echo "*   generated file using tel2.tel.vtt.fi's CC command from gra.vtt.fi"
echo "*"
echo "* WHO:"
echo "*   jfr@tel.vtt.fi otso@gra.vtt.fi"
echo "*"
echo "* Local Directory:  gra:" $localPath
echo "* Remote Directory: tel2:" $remotePath

remoteCCdir="/usr/owc/bin"
remoteCC="$remoteCCdir/CC"
remoteCCincludes="-I/usr/owc/include"

command="\
PATH=/usr/owc/bin:/otso/bin:$PATH;\
cd $remotePath;\
$remoteCC $remoteCCincludes $*\
"
echo "* Created by this 'rsh' command at tel2: " $command
echo "***********************************************************************/"

#
# On NeXT, -n redirects output to /dev/null.  Necessary for
# use of rsh from within csh (and OTSO make files).
# -n means diff't things with rsh on different systems though.
#
rsh tel2.tel.vtt.fi -l jfr -n $command
