/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/4/all/SCCS/s.trancod.hx
 *  Version:	1.3
 *  Time:	91/07/19, 14:32:51
 *
 **************************************************************/

/**********************************************************************
* NAME	trancod.hx
* 
* PURPOSE
*	Transport Protocol Data Unit (PDU) encoding and decoding.
**********************************************************************/

typedef slong TranRef;    

typedef slong TPDU_nr;

typedef slong TS_qos;


/////////////////////////////////////////////////////////////////////
//   Class TranDec contains the decoder functions for transport PDUs.
// Function decode(p1, p2, p3, p4) finds out the type of the pdu, and
// calls the decoder function for that pdu (e.g. dec_DT(p1, p2, p3, p4,
// p5)).  When the pdu has been decoded, the pdu is given as an input to
// the transport entity, by calling a function of class TranPeer
// (e.g. tran4.DT(pduNr, eot, data)).
/////////////////////////////////////////////////////////////////////
enum CR_or_CC { CR_pdu, CC_pdu };

class TranDec{
private:
  int  getPduSize (Byte byte);

  void dec_CR_or_CC (
               TranPeer &tran, int length, Bytes &header,
               CR_or_CC pdu_type, Frame &frame);

  void dec_DR (TranPeer &tran, int length, Bytes &header, Frame &frame);

  void dec_DC (TranPeer &tran, int length, Bytes &header);

  void dec_DT (TranPeer &tran, int length, Bytes &header, int trclass,
	       boolean extFormats, boolean checksum, Frame &frame); 

  void dec_ED (TranPeer &tran, int length, Bytes &header,
               boolean extFormats, boolean checksum, Frame &frame); 

  void dec_AK (TranPeer &tran, int length, Bytes &header,
               boolean extFormats, boolean checksum); 

  void dec_EA (TranPeer &tran, int length, Bytes &header,
               boolean extFormats, boolean checksum);

  void dec_ER (TranPeer &tran, int length, Bytes &header); 

  void dec_INVALID (TranPeer &tran);

  boolean corrupted (Frame &frame);

public:
  void decode (TranPeer &tran, boolean checksumUsed,
               boolean extFormatsUsed, int trclass,
               Frame frame);
};


////////////////////////////////////////////////////////////////////
// Class TranPeerEnc contains encoding functions for tpdus which 
// can be sent.  These functions appear in the actions of the
// transport state machine.
//
// EXAMPLE:
//   open_state DT(pduNr,data){
//       nsp -> n_dtr (encoder -> enc_AK (destref, pduNr+1, 1, true));
//   }
//
// The caller of these functions (e.g. tran4) might also define its own
// enc_AK which gives some of the parameter values automatically.
//
// EXAMPLE:
//   open_state DT(pduNr,data) { nsp -> n_dtr (enc_AK (pduNr+1))  }
//
////////////////////////////////////////////////////////////////////

class TranEnc{
private:
  Frame frame;
  void put_reference(TranRef ref);
  void put_chs_space ();
  void put_add_options (boolean checksum,boolean expData,int trclass);
  void put_pdu_size (int pduSize);
  void put_class_and_option (int trclass,boolean extFormat);
  void put_clearing_reason (Frame &clearingReason);
  void put_dr_reason (dr_reason drReason);
  void put_checksum();

public:

  Frame enc_CR (TranRef srcRef, int credit, int trclass,
                boolean extFormats, TSAPaddr &calling, TSAPaddr &called,
                int pduSize, boolean checksum, boolean expData,
                Frame &data);

  Frame enc_CC (TranRef destRef, TranRef srcRef, int trclass, int credit,
	        boolean extFormats, TSAPaddr &responding, int tpduSize,
	        boolean checksum, boolean expData, Frame &data);

  Frame enc_DR (TranRef destRef, TranRef srcRef,
                dr_reason drReason,
	        boolean checksum, Frame &clearingReason, Frame &data);

  Frame enc_DC (TranRef destRef, TranRef srcRef, boolean checksum);

  Frame enc_DT (TranRef destRef, int pduNr, boolean eot,
                boolean extFormat, boolean checksum, Frame &data,
                int trclass);

  Frame enc_ED (TranRef destRef, int pduNr, boolean extFormat,
                boolean checksum, Frame &data, int trclass);

  Frame enc_AK (TranRef destRef, int yourPduNr, int credit,
                boolean checksum, boolean extFormat);

  Frame enc_EA (TranRef destRef, int yourPduNr, boolean checksum,
	        boolean extFormat);

  Frame enc_ER (TranRef destRef, boolean checksum);

};

