/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/4/all/SCCS/s.tran_serv.hx
 *  Version:	1.4
 *  Time:	92/08/14, 15:06:24
 *
 **************************************************************/

/**********************************************************************
* NAME: tran_serv.hxx
*
* PURPOSE: Connection Oriented Transport Service (TRAN)
*	Service (user and provider) primitive definitions.
**********************************************************************/

/**********************************************************************
Connection Oriented Transport service provider interface.
**********************************************************************/

interface class TranSP {
public:
  /* Connection establishment */
  virtual async t_cr (
    TSAPaddr	calling,		/* caller */
    TSAPaddr	called,			/* callee */
    slong	expData,		/* use expedited data ? */
    slong	qos,			/* quality of service */
    Frame	data			/* user_data */
  ) = 0;

  virtual async t_cresp (
    TSAPaddr	responding,		// responding address
    slong	expData,		// use expedited data?
    slong	qos,			// quality of service
    Frame	data			// user_data
  ) = 0;


  /* Connection dis-establishment */
  virtual async t_dr (
    slong	reason,			/* reason for disconnect */
    Frame	data			/* user_data */
  ) = 0;


  /* Data transfer */
  virtual async t_dtr (Frame data) = 0;
  virtual async t_edtr (Frame data) = 0;	/* expedited data transfer */
};


/**********************************************************************
Connection Oriented Transport service user interface.
**********************************************************************/

interface class TranSU {
public:

  /* Connection establishment */
  virtual async t_ci (
    TSAPaddr	calling,		/* caller */
    TSAPaddr	called,			/* callee */
    slong	expData,		/* use expedited data ? */
    slong	qos,			/* quality of service */
    Frame	data			/* user_data */
  ) = 0;

  virtual async t_cc (
    TSAPaddr	responding,		// responding address 
    slong	expData,		// use expedited data? 
    slong	qos,			// quality of service 
    Frame	data			// user_data 
  ) = 0;


  /* Connection dis-establishment */
  virtual async t_di (
    slong	reason,			/* reason for disconnect */
    Frame	data			/* user_data */
  ) = 0;


  /* Data Transfer */
  virtual async t_dti (Frame data) = 0;
  virtual async t_edti (Frame data) = 0;	/* expedited data transfer */
};

