.TH VoidGroup 3 - 
.SH CLASS
VoidGroup (abstract base class, only derived classes can be instantiated)
.SH PUBLIC BASE CLASSES
.in 4
.B
NamedObj
.in 7
.fi


.SH DESCRIPTION
.fi

Class VoidGroup is a base class for void* containers.
VoidFifo is a First-In-First-Out queue of void pointers,
VoidLifo is a Last-In-First-Out stack of void pointers.

The extracted elements can be typecasted after get() if you know exactly
the type of the element.  Use class Group when the elements are Runners. 

The basic services provided by VoidGroups are put() and get().
Iteration through all the elements in a VoidGroup:
.nf

  VoidGroup* q = ...
  VGP tmp; 
  for(void* voidp = g->first(tmp); !q->over(tmp); voidp = q->next(tmp)) {
    //... use voidp ...
  }

.fi

.SH BUGS
Elements may be instances of any type: no type-checking!
Using typed Groups (such as OTSO Group and application-specific queues)
is much more safe.

Proper print() cannot be implemented 
because the elements are not necessarily Objects.
reset() and isEmpty() could be implemented with slightly different meaning
than in Group.  However, not implemented.  

get() from an empty VoidGroup returns &dummyRunner !?
 
.SH PUBLIC MEMBERS


.SH VoidGroup services
 
.in 4
.B

virtual VoidGroup& put(const VGE r)
.in 7
.fi
Add one void* into the VoidGroup. Return *this. 
.in 4
.B

virtual VGE get()
.in 7
.fi
Get and return one void* from VoidGroup, return &dummyRunner if empty VoidGroup. The element is removed from the VoidGroup. 
.in 4
.B

VoidGroup& put(const VGE o1, const VGE o2, const VGE o3 = 0, const VGE o4 = 0, const VGE o5 = 0, const VGE o6 = 0)
.in 7
.fi
Add 2 to 6 void pointers to the VoidGroup, return *this. 
.in 4
.B

VGE head()
.in 7
.fi
Without removing, return the VGE that get() would return. 
.in 4
.B

virtual void reset()
.in 7
.fi
Make group empty. 
.in 4
.B

sint32 size() const
.in 7
.fi
Number of elements in this. 

.SH Iteration
 
.in 4
.B

virtual VGE first(VGP& )
.in 7
.fi
 
.in 4
.B

virtual VGE next(VGP& )
.in 7
.fi
 
.in 4
.B

virtual boolean over(const VGP )
.in 7
.fi
 
.SH PROTECTED MEMBERS

.in 4
.B

sint32 size_
.in 7
.fi
Number of elements in this. 

.SH FILE
voidgrp.hxx
.TH VoidLink 3 - 
.SH CLASS
VoidLink

.SH DESCRIPTION
.fi

A VoidLink attaches Group elements.
Each Group has its own list of VoidLinks,
so that any Object may belong to several independent Groups.
The elements do not contain any pointers to other elements.

.SH BUGS
 
.SH PUBLIC MEMBERS

.in 4
.B

void* element
.in 7
.fi
 
.in 4
.B

VoidLink* next
.in 7
.fi
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 VoidLink(const void* e, VoidLink* n)
.in 7
.fi


.SH FILE
voidgrp.hxx
.TH VoidFifo 3 - 
.SH CLASS
VoidFifo
.SH PUBLIC BASE CLASSES
.in 4
.B
VoidGroup
.in 7
.fi


.SH DESCRIPTION
.fi

A "first in, first out" queue,
a container of VoidGroup elements void*.
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 VoidFifo()
.in 7
.fi


.SH FILE
voidgrp.hxx
.TH VoidLifo 3 - 
.SH CLASS
VoidLifo
.SH PUBLIC BASE CLASSES
.in 4
.B
VoidFifo
.in 7
.fi
implementation reuse only, VoidLifo provides VoidGroup service 

.SH DESCRIPTION
.fi

A "last in, first out" grouping (container class) of VoidGroup elements VGE.
.SH BUGS
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 VoidLifo()
.in 7
.fi
 

.SH FILE
voidgrp.hxx
