.TH RunnerTrace 3 - 
.SH CLASS
RunnerTrace
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

RunnerTrace stores the trace settings of a Runner.
Each attribute tells if a piece of trace is printed or not.
 
.SH PUBLIC MEMBERS

.in 4
.B

boolean running
.in 7
.fi
 
.in 4
.B

boolean variablesBefore
.in 7
.fi
 
.in 4
.B

boolean receiving
.in 7
.fi
 
.in 4
.B

boolean inputParameters
.in 7
.fi
 
.in 4
.B

boolean actions
.in 7
.fi
 
.in 4
.B

boolean sending
.in 7
.fi
	 
.in 4
.B

boolean outputParameters
.in 7
.fi
 
.in 4
.B

boolean variablesAfter
.in 7
.fi
 
.in 4
.B

boolean verbose
.in 7
.fi
 
.in 4
.B

virtual async allOn()
.in 7
.fi
Set all tracing on. 
.in 4
.B

virtual async allOff()
.in 7
.fi
Set all tracing off. 
.in 4
.B

virtual async setDefault()
.in 7
.fi
Set default tracing on. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 RunnerTrace()
.in 7
.fi


.SH FILE
runner.hxx
.TH RunnerTrace 3 - 
.SH CLASS
RunnerTrace
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

This goes to the OTSO prepro only.  
This is a part of command interpreter implementation.
 
.SH PUBLIC MEMBERS

.in 4
.B

boolean running
.in 7
.fi
 
.in 4
.B

boolean variablesBefore
.in 7
.fi
 
.in 4
.B

boolean receiving
.in 7
.fi
 
.in 4
.B

boolean inputParameters
.in 7
.fi
 
.in 4
.B

boolean actions
.in 7
.fi
 
.in 4
.B

boolean sending
.in 7
.fi
	 
.in 4
.B

boolean outputParameters
.in 7
.fi
 
.in 4
.B

boolean variablesAfter
.in 7
.fi
 
.in 4
.B

boolean verbose
.in 7
.fi
 
.in 4
.B

virtual async allOn()
.in 7
.fi
Set all tracing on. 
.in 4
.B

virtual async allOff()
.in 7
.fi
Set all tracing off. 
.in 4
.B

virtual async setDefault()
.in 7
.fi
Set default tracing on. 

.SH FILE
runner.hxx
.TH Runner 3 - 
.SH CLASS
Runner
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

This part of code is enclosed between #if 0 ... #endif.
This is not given to C++ compiler but the OTSO preprocessor processes this
and generates code for the command interpreter.
The prepro is fooled to think that Runner is derived directly from Object,
so preprocessing all the intermediate classes between Runner and 
Object is not needed.
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual void run()
.in 7
.fi
Activates this to perform actions. 
.in 4
.B

virtual void run1()
.in 7
.fi
Activates this to handle one event. 
.in 4
.B

virtual void setPriority(RunnerPriority priority)
.in 7
.fi
Set the priority. 
.in 4
.B

virtual Time time()
.in 7
.fi
Current time; real or virtual. 
.in 4
.B

virtual void delay(Delay d)
.in 7
.fi
Simulate the elapsing of time; turn clock forward. 
.in 4
.B

virtual async timeout(sint32 id)
.in 7
.fi
Timer 'id' has expired. 
.in 4
.B

RunnerTrace trace
.in 7
.fi
Controls the amount of output that is printed when this is activated. 
.in 4
.B

RunnerPriority priority_
.in 7
.fi
Scheduling priority in priority queue. 
.in 4
.B

RunStatus runStatus
.in 7
.fi
Scheduling permission: 0=idle, 1=enabled, 2=running 
.in 4
.B

GroupPointer iQ
.in 7
.fi
Queue of input events (Runners, messages). 

.SH FILE
runner.hxx
.TH Runner 3 - 
.SH CLASS
Runner
.SH PUBLIC BASE CLASSES
.in 4
.B
NamedObj
.in 7
.fi


.SH DESCRIPTION
.fi

Runners can be activated for unspecified purposes, or "run".
Running means that Runners are given 
execution time to perform their own local actions.
A Runner often has an input Group for buffering input messages.
Messages are given to Runners through the runOrQueue(Message) operation.

The class Runner gives a default implementation in addition to the
general interface to Runners.  The runOrQueue() operation puts the
message into the input queue if there is one, otherwise processes the
message immediately. Also a high priority may cause the message to be
run immediately. The default run() operation takes one message from
the input queue and runs it.

A single operating system process will probably have many Runners. 
Runners may provide asynchronous services: service requests may be
packaged in messages, inserted into input queue and handled later
when the Runner is run.

A "Scheduler" is a type of runner, and it's Scheduler::run() 
controls execution of other runners in the scheduler's input queue.

A Runner is given execution time if it is "enabled", for example when
it has at least one "event" to be handled.
An event is itself a Runner, usually a message or a derived Runner. 
The base class Runner::run() can be used for handling messages 
in its input queue.
Another example of an event is that something has occured 
on a device associated with the runner that needs handling.
In this case, the runner is probably a derived Runner, and has
it's own unique run() function to handle the device (e.g. see
Istream::run()).

.SH IDEAS

Priorities: 
defaultAsyncMessagePriority = 30, 
defaultParallelMessagePriority = 50
defaultValueMessagePriority = 70,
runWhenEnabled = 100,
enablePriority = 150,
runIfNotRunning	= 170.

.SH BUGS

realTime() needed in simulation (and only in simulation)

.SH MODIFICATIONS
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual void run()
.in 7
.fi
Activates this to perform actions. The default run() gets the next Runner (usually a message) from inQ and handles (runs) it. There is no way to pre-empt a run() function. If it goes into an infinite loop,  nothing will stop it. Control is returned to the scheduler when run() returns. 
.in 4
.B

Group* inQ() const
.in 7
.fi
An input queue, i.e.  a container of received events (Runners) to  be handled later in run().   Group is not always a Fifo, it may be Lifo, round-robin etc.  See class Group. inQ() also determines if this wishes to  receive service requests as messages (inQ() != 0), or as direct function calls (inQ() == 0). 
.in 4
.B

void setInQ(Group* q)
.in 7
.fi
Set input queue iQ. 
.in 4
.B

virtual void runOrQueue(Runner& event)
.in 7
.fi
Gives an event for this. Specifies actions performed this (the receiver) when receiving an input event. This will either put the event on the inQ() to be handled later, or handle the event immediately  (event->priority >= runImmediately). Requests scheduling, if inQ was empty. 
.in 4
.B

void sendOrQueue(Message& msg)
.in 7
.fi
Actions performed by the sender after  building an output message msg. This checks if its ok to send msg to the destination, or if msg should be for example put into output queue. 
.in 4
.B

virtual void run1()
.in 7
.fi
Activate this to handle one event; by default the same as run(). The main usage is  in Scheduler's command interpreter interface. 
.in 4
.B

Runner* myScheduler()
.in 7
.fi
The Runner that this requests scheduling from. 
.in 4
.B

Process*& process() const
.in 7
.fi
The memory space that this resides in. 
.in 4
.B

RunStatus runStatus
.in 7
.fi
Tells the current execution state. Controls if myScheduler() is allowed to run this or not. 

'idle': This is not currently active.   In the default Runner implementation, runStatus is 'idle' when there are no messages in inQ(). 

'enabled': myScheduler() is allowed to run  this.  In the default Runner implementation, this is true when at least one Runner in inQ(). 

'running': An operation has begun but  has not been not completed, e.g. waiting for a synchronous return value. In the default Runner implementation, runStatus is 'running' run() is being  executed. 

.SH Priority
 
.in 4
.B

RunnerPriority priority() const
.in 7
.fi
The "urgency" of this.  Priority matters in priority queues, high priority may even cause immediate handling without queuing (priority == 'runImmediately'). If myScheduler()->inQ() is a PriorVec, priority() tells which Group of PriorVec this will go to. 
.in 4
.B

void setPriority(RunnerPriority p)
.in 7
.fi
Sets the priority.  Determines the queue of PriorVec that this goes to. Check that someone puts someone puts this back to the queue at a proper time, if this comes out of the queue. 

.SH Time and Simulation
 
.in 4
.B

virtual Time time()
.in 7
.fi
Returns the current time; real time in real systems, virtual time in simulation  
.in 4
.B

virtual void delay(Delay d)
.in 7
.fi
Tells that d time units have elapsed. 
.in 4
.B

virtual Delay slice()
.in 7
.fi
see simulation documents 
.in 4
.B

Group* futureQ()
.in 7
.fi
see simulation documents 
.in 4
.B

virtual Runner& schedules(Runner* r1, Runner* r2 = 0, Runner* r3 = 0, Runner* r4 =0, Runner* r5 = 0, Runner* r6 = 0)
.in 7
.fi
this will be parameters' myScheduler (see simulation documents) 
.in 4
.B

static Runner* lastConstructedRunner
.in 7
.fi
the Runner created latest 

.SH Tracing
 
.in 4
.B

virtual void print(Ostream& )
.in 7
.fi
Print name and contents. 
.in 4
.B

virtual void printNameFromTo(Ostream& os)
.in 7
.fi
Print name and  for Messages source and destination. Less verbose than print(). 
.in 4
.B

String className() const
.in 7
.fi
operator RunnerPtr();	//Needed for example when starting a timer, and this must be converted to RunnerPtr so that timeout can be sent to this. Compilation problems !!?? 
.SH PROTECTED MEMBERS

.in 4
.B

Runner* myScheduler_
.in 7
.fi
 
.in 4
.B

Memory* myMemory_
.in 7
.fi
 
.in 4
.B

RunnerTrace trace
.in 7
.fi
What trace is printed when this is run. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
  
.in 4
.B

 Runner(Group* i = 0)
.in 7
.fi
i is input queue inQ() for buffering input Runners, typically messages.  0 => no messages, direct function call. 

.SH FILE
runner.hxx
.TH Scheduler 3 - 
.SH CLASS
Scheduler
.SH PUBLIC BASE CLASSES
.in 4
.B
Runner
.in 7
.fi


.SH DESCRIPTION
.fi

A "Scheduler" is a type of runner, and it's Scheduler::run() 
controls execution of other runners (element runners).
There is one (main) Scheduler in each real process; its name is "scheduler".

If a runner is enabled, and the runner is to be executed, the
scheduler calls the runner's run() function.  The scheduler is
always enabled and should itself run (even if nothing else does).

The list of objects on a scheduler's inQ are Runners to be run.
Some Runners request scheduling and insert themselves into their scheduler's
inQ when they receive events to be processed.
Some Runners should be inserted into the inQ at system initialization time.
The scheduler gets Runners from its input queue, and runs the
ones that are enabled.  

The type of inQ used by the scheduler
is important.  If it is a Fifo, for example, when it gets
the next Runner, the Runner disappears from the 
scheduler's inQ.
This is because Fifo::get() removes the Runner from the queue.
If the inQ is a Ring, however get() operation doesn't remove the
the Runner from the Ring.  A Ring is a permanent list of
Runners to be run therefore.  If a Runner is inserted to the scheduler's
inQ at initialization time, it most likely should go to a Ring in order
to be run more than once.

.SH EXAMPLES
.nf
 main() {
   ...
   Derived_Runner_Class my_runner1, my_runner2;
   scheduler = new Scheduler;
   Ring* r = new Ring;
   r->ringPut(&my_runner, &my_runner2);
   scheduler->setInQ(r);
   scheduler->run();      //round-robin between my_runner1, my_runner2
 }
.fi
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual void run()
.in 7
.fi
Runs the inQ() Runners until the last synchronous "slow" message returns. 
.in 4
.B

virtual void run1()
.in 7
.fi
Activate this to handle one event: get() and run() one enabled Runner, then return. 
.in 4
.B

virtual void runUntilNotEmpty(Object* o)
.in 7
.fi
Runs the inQ() Runners until o->isEmpty() is false. 
.in 4
.B

Time time()
.in 7
.fi
Current real time. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Scheduler()
.in 7
.fi


.SH FILE
runner.hxx
.TH Objectifier 3 - 
.SH CLASS
Objectifier
.SH PUBLIC BASE CLASSES
.in 4
.B
Runner
.in 7
.fi


.SH DESCRIPTION
.fi

A temporary object, sitting on top of instances of 
any type for which OTSO interface has been defined.
Objectifier is a kind of converter between 
the OTSO Object interface and the interface provided the type.

Objectifier Must be derived from Object.
Derived from Runner only because Objectifiers are put into Groups.
 
.SH PUBLIC MEMBERS

.in 4
.B

Objectifier& operator +=(Offset offset)
.in 7
.fi
add offset to instance_ ? 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Objectifier(void* p, Type* type)
.in 7
.fi
allocated from free store 
.in 4
.B

 Objectifier(Object* o)
.in 7
.fi
not allocated from free store 

.SH FILE
runner.hxx
