.TH Ring 3 - 
.SH CLASS
Ring
.SH PUBLIC BASE CLASSES
.in 4
.B
Fifo
.in 7
.fi
Implementation reuse only,  Ring implements Group service. 

.SH DESCRIPTION
.fi

A container class implementing a round-robin (a circular list) of GEs.
GE is Runner*.
This is a permanent Group: the elements in the the ring are supposed to 
stay there until the whole Ring is deleted; 
put() does NOT add elements, get() does NOT remove elements.
This is to avoid accidental misuse when used through a Group*.

Operation putAnyway() can be used to really add elements to the Ring
(in the initialisation),
and getAnyway to really remove elements from the Ring.

.SH BUGS
The permanent nature of Ring is clearly different from the other Groups.

 
.SH PUBLIC MEMBERS

.in 4
.B

Group& put(const GE element)
.in 7
.fi
Does NOT add anything, returns *this. 
.in 4
.B

Group& get(GE& element)
.in 7
.fi
Element will point to the "next" GE, does not remove the element from ring. Returns *this. The next get() gives a different element (if there are >1 elements in the Ring). 
.in 4
.B

void reset()
.in 7
.fi
reset() all elements, but the elements remain in the Ring.  Dangerous if the  element's reset() deletes the element, which is the case for messages. 
.in 4
.B

virtual Group& putAnyway(const GE e)
.in 7
.fi
Insert a Runner* into this. 
.in 4
.B

virtual Group& getAnyway(GE& r)
.in 7
.fi
Extract a Runner* from this. 
.in 4
.B

Ring& ringPut(const GE e)
.in 7
.fi
Obsolete, use putAnyway(). 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Ring()
.in 7
.fi


.SH FILE
ring.hxx
