.TH PriorVec 3 - 
.SH CLASS
PriorVec
.SH PUBLIC BASE CLASSES
.in 4
.B
Group
.in 7
.fi


.SH DESCRIPTION
.fi

PriorVec is a priority vector of Runners. 
The number of priorities is fixed in the constructor 
by giving a certain number (1..5) of element Group pointers.
PriorVec elements are put into and get from the element Groups.

.SH BUGS
Iteration cannot be done concurrently, e.g. an iteration (first-next-over)
of a PriorVec inside another iteration of the same PriorVec instance
does not work (because of the shared currentGroup element).
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual Group& put(const GE e)
.in 7
.fi
Add e to the Group selected by e->priority(). 
.in 4
.B

virtual Group& get(GE& e)
.in 7
.fi
Remove one element from the highest-priority non-empty Group to e. e is &dummyRunner is all Groups are empty. 
.SH PROTECTED MEMBERS

.in 4
.B

Group* gp[priorVecSize]
.in 7
.fi
array of Groups that store the GEs 
.in 4
.B

sint16 currentGroupIndex
.in 7
.fi
Index of the element of gp that contains the GE that was last returned in iteration. 
.in 4
.B

sint16 hint_
.in 7
.fi
Performance optimization: higher-priority queues in gp have no elements.  
.in 4
.B

sint16 nGroups_
.in 7
.fi
The number of Group*'s in gp. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 PriorVec(Group* g0, Group* g1 = 0, Group* g2 = 0, Group* g3 = 0, Group* g4 = 0)
.in 7
.fi
Give as many arguments as you wish to have priorities.  Runners with priority 0 will go to the first argument Group, those with priority 1 to the second argument Group etc. Maximum number 4 == priorVecSize - 2. 

.SH FILE
priorvec.hxx
.TH FairPriorVec 3 - 
.SH CLASS
FairPriorVec
.SH PUBLIC BASE CLASSES
.in 4
.B
PriorVec
.in 7
.fi


.SH DESCRIPTION
.fi

FairPriorVec is a "fair" priority vector of Groups, 
breaking the strict priority every now and then.
This is partly a PriorVec, partly round-robin.
Elements are taken from lower-priority Groups 
even though higher-priority Groups have not exhausted.
The difference 1 in priority value doubles the frequency of 
checking the queue.
.SH BUGS
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 FairPriorVec(Group* g0, Group* g1 = 0, Group* g2 = 0, Group* g3 = 0, Group* g4 = 0)
.in 7
.fi
4 == priorVecSize - 2 

.SH FILE
priorvec.hxx
.TH Heap 3 - 
.SH CLASS
Heap
.SH PUBLIC BASE CLASSES
.in 4
.B
Group
.in 7
.fi


.SH DESCRIPTION
.fi

Heap is an Runner container, a kind of priority queue - it is suitable
for putting Runners in any order and getting the biggest one anytime.
In other words, get() gives the element that is 'greaterThan' all the 
other elements.  'greaterTran' is a virtual function in Runner.
Only Runners that can compare each other with the `greaterThan' 
may be put into one Heap.

.SH BUGS
Print shows the elements in an incorrect order.

Maybe a.greaterThan(b) should be true if a.priority() < b.priority()
by default.

 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Heap()
.in 7
.fi


.SH FILE
priorvec.hxx
