.TH VoidPointer 3 - 
.SH CLASS
VoidPointer

.SH DESCRIPTION
.fi

VoidPointer 
 
.SH FRIEND FUNCTIONS

.in 4
.B

friend Ostream& operator <<(Ostream& os, VoidPointer& p)
.in 7
.fi
friend Istream& operator>>(Istream& is, VoidPointer& p); 
.in 4
.B

friend ODump& operator <<(ODump& od, VoidPointer& p)
.in 7
.fi

.in 4
.B

friend IDump& operator >>(IDump& id, VoidPointer& p)
.in 7
.fi


.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 operator void*()
.in 7
.fi

.in 4
.B

 VoidPointer(void* i = 0)
.in 7
.fi


.SH FILE
object.hxx
.TH Object 3 - 
.SH CLASS
Object

.SH DESCRIPTION
.fi

This class is handled by the OTSO preprocessor, but not by C++ compiler.
Interface class Object defines the part of Object interface that is
shown to the user interface and remote objects 
(after a sed translation).
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual void printToDout()
.in 7
.fi
Output this to dout. 
.in 4
.B

virtual void askFromDin()
.in 7
.fi
Ask this from din. 

.SH FILE
object.hxx
.TH Object 3 - 
.SH CLASS
Object

.SH DESCRIPTION
.fi

In the hierarchy of OTSO objects, class Object is the
root of the hierarchy tree. Object is the base class of 
most of the classes in the OTSO class inheritance graph.
Classes written by an application programmer, however, 
need not necessarily be derived from Object.

Class Object has very basic functions that every object
will use, and most of them are virtual: 
printing to an output stream, asking from input stream,
encoding to transfer syntax, decoding etc.
Derived Objects can be inserted to Ostream and ODump,
and extracted from Istream and IDump.
These operations are implemented by print(), to(), ask(), and from()
virtual functions.

Object does not contain any data members.

.SH BUGS
... many ...

.SH MODIFICATIONS
... even more ...
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual String name() const
.in 7
.fi
Returns readable name, if a name has been given via setName(), and this is capable of storing the name string. Otherwise className() is returned. 
.in 4
.B

virtual void setName(const String& )
.in 7
.fi
Give this a global name that name()  should return.  Only NamedObj's are able to store the given name; simpler objects do not contain the data member needed to store a string. 
.in 4
.B

virtual String className() const
.in 7
.fi
The name of the class.  Derived classes should always redefine this method. 

.SH Emptiness
 
.in 4
.B

virtual boolean isEmpty()
.in 7
.fi
True if no value in this object. For example, a queue with no elements is empty.   Object::empty returns false. 
.in 4
.B

virtual void reset()
.in 7
.fi
Move this to initial state.  Make  empty so that isEmpty() will be true. 

.SH Encoding and Decoding
 
.in 4
.B

virtual void print(Ostream& os)
.in 7
.fi
Print in a human readable format to os. Usually the same as dout << *this; 
.in 4
.B

virtual void ask(Istream& is)
.in 7
.fi
Reads from is, usually also prints  a very short guiding help text (prompt). Usually the same as din >> *this; 
.in 4
.B

virtual void to(ODump& od)
.in 7
.fi
Encoding: flatten all data of this object and insert the generated  byte stream into od. 
.in 4
.B

virtual void from(IDump& id)
.in 7
.fi
Decoding from is to this. 
.in 4
.B

virtual void asnEncode(Frame& o)
.in 7
.fi
Encode according to ASN.1 basic encoding rules and insert into o.   Use of to() recommended. Implemented only if the  derived data type has been generated from ASN.1 description. 
.in 4
.B

virtual void asnDecode(Frame& i)
.in 7
.fi
ASN.1 decoding. Use of from() recommended. Implemented only if the  derived data type has been generated from ASN.1 description. 

.SH Command interpreter
 
.in 4
.B

virtual Member runUI(Objectifier sp, String prompt, String memberName)
.in 7
.fi
Read method name and execute it. No method name is read, if non-empty String given in 'memberName'. 
.in 4
.B

virtual void printMsgs(Ostream* out, boolean help)
.in 7
.fi
Prints the names of methods that this can convert to message objects in newMsg().  Prints also the names of data members that can be used from the command interpreter. If help is true, prints also explanatory help text about the alternatives. printMsgs is usually generated by OTSO for application types. 
.in 4
.B

virtual VoidPointer memberPointer(String memberName)
.in 7
.fi
Returns other that 0 if the command  interpreter knows about a member of this that has the name 'memberName'.   The member may be  data, a method, or a base class. If it is a data member or a base class, memberPointer() returns a pointer to the member. If it is a method member, memberPointer() returns a pointer to a message! 

.SH Address space
 
.in 4
.B

virtual Process*& process() const
.in 7
.fi
Returns the Process in whose address space this resides in. 

.SH Multiple connections (experimental, not worth trying)
 
.in 4
.B

virtual void* connection(ConnectionId conId)
.in 7
.fi
Return the identified connection, which is this unless multiple connections are used. 
.in 4
.B

virtual void* newConnection(ConnectionId& c)
.in 7
.fi
Return this, or a new instance in case of multiple connections. c will be the id of the returned object, noConnection if not new connection. 
.in 4
.B

virtual void deleteConnection(ConnectionId )
.in 7
.fi
Delete a connection. 
.in 4
.B

virtual void setSender(Agent* agent)
.in 7
.fi
Tells this who the service user (SU) is. agent is SU's MultiPtr to SP. 
.in 4
.B

static const ConnectionId noConnection
.in 7
.fi
Id of the objects that does not support multiple connections, or the Multi object itself in case of multiple connections. Will be removed soon. 
.in 4
.B

virtual Object* server()
.in 7
.fi
agent's server, this otherwise 

.SH Miscellaneous
 
.in 4
.B

String sender() const
.in 7
.fi
The name() of the most recent  service user object of this object. Updated just before running a  message sent by the SU, and before executing a function called via a Ptr directly without a message. 
.in 4
.B

virtual async timeout(sint32 id)
.in 7
.fi
Timer id expired. Probably will be moved to Runner. 
.in 4
.B

void undefined(char* ) const
.in 7
.fi
Delete when Object is abstract base class 
.in 4
.B

virtual ASNHOME* toASNHOME()
.in 7
.fi
Creates and returns an ASNHOME structure that points to this.  See CASN documents. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Object()
.in 7
.fi
Used only for free store memory  debugging purposes. 

.SH FILE
object.hxx
.TH Globals 3 - 
.SH CLASS
Globals
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

All OTSO global variables should be members of class Globals.
Add all new OTSO global variables here !

Later these may be put into classes Thread and Memory.

.SH BUGS

Used inconsistently.
 
.SH PUBLIC MEMBERS

.in 4
.B

Time time()
.in 7
.fi
?See simulation documents? 
.in 4
.B

timeval sys_time
.in 7
.fi
Approximate system time. 
.in 4
.B

static Time time_
.in 7
.fi
Virtual time, used in simulation? 
.in 4
.B

Process* lastConstructedNode
.in 7
.fi
Points to the Process that was  constructed most lately. Used in Runner initialization. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Globals()
.in 7
.fi


.SH FILE
object.hxx
