.TH ISOmacros 3 - 
.SH CLASS
ISOmacros
.SH PUBLIC BASE CLASSES
.IP Object 10


.SH DESCRIPTION
.fi

The class "ISOmacros" provides a macro substitution facility that uses 
the file "dvopmacros" to create macros for String encodings of PSAPs,
specifically for physical network addresses.

The class NETaddr (see isoaddrs.hxx) represents physical network
addresses (such as X.25, TCP/IP, and OSI IP addresses).  It is
possible to construct a NETaddr from a char string such as:
.nf
   NETaddr remote_host ("TELEX+00728722+RFC-1006+03+puppu.tel.fi");
.fi
The strings used to construct a NETaddr are often long ("TELEX..." above),
and their meaning is not obvious to the novice user of OTSO.  

The class ISOmacros is used to create a hash table of "macros" that map
simple names to more compicated strings needed to construct a NETaddr.  The
user can define these macros in the file "dvopsmacros" (5).

For example, if we had a macro "Internet" with a value
"TELEX+00728722+RFC-1006+03", we could rewrite the declaration of remote_host
as follows:
.nf
   NETaddr remote_host ("Internet=puppu.tel.fi");
.fi
and a novice user would be more likely to guess that the address string
above is simply the Internet TCP/IP address of remote_host.

Macros defined in the file "dvopmacros" (5) can be used in the
hostname file mapping "dvophosts" (5).

Note, that internally OTSO tends to use the full completely expanded
addresses, ISOmacros are just a notational convience for the user.

.SH NOTES
.nf
Remember to set the external OTSO pointer:
	extern ISOmacros *global_iso_macros;
if you wish to change the default macro table that OTSO will use.
.fi

.SH SYNOPSIS
.nf
 #include "isomacros.hxx"
.fi

.SH EXAMPLES
.nf
 #include "isoaddrs.hxx"
 #include "isomacros.hxx"

 ISOmacros macro_table;

 -- create ISOmacros table from file "dvopmacros"
 if (macro_table.read_macros())
 {
     global_iso_macros = &macro_table;	-- if we want to change default
					-- table used by OTSO

     cout << "OTSO ISO Macros : " << macro_table << "\\n";

     -- use macro "Internet"
     PSAPaddr remote_x500 ("#101/#80/#80/#01/Internet=puppu.tel.fi");
 }
.fi

.SH SEE ALSO
.nf
	dvopmacros(5) dvophosts(5) dvopservices(5)
	isoaddrs(3) isohosts(3) isoservices(3)
.fi
 
.SH PUBLIC MEMBERS

.in 5
.B

char* name2value(char* )
.in 10
.fi
 Convert a macro name into its value. 
.in 5
.B

char* value2name(char* )
.in 10
.fi
 Convert a macro value into its name. 
.in 5
.B

int read_macros()
.in 10
.fi
 Create the ISOmacros table from  the file "dvopmacros" (5). 
.in 5
.B

void print(ostream& )
.in 10
.fi
 cout << ISOmacros; 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 ISOmacros()
.in 10
.fi



.SH FILE
isomacros.hxx
