.TH NETaddr 3 - 
.SH CLASS
NETaddr
.SH PUBLIC BASE CLASSES
.IP Object 10


.SH DESCRIPTION
.fi

The header file isoaddrs.hxx contains several classes of "addresses".
They are:
.nf
   NETaddr NSAPaddr TSAPaddr SSAPaddr and PSAPaddr (OSIaddr = PSAPaddr)
.fi
They represent addresses / service access points as defined in various
OSI documents (e.g ISO 8348).  They are used for in the network,
transport, session, and presentation layers.

----------------------

A NETaddr is the base class that can be used to represent an OSI
"physical" network address.   

See ISO Standard 8348 (Network Service Definitions) about the usage/values 
of afi, idi, and dsp.  The afi, idi, dsp defined below are stored as ascii
strings and not byte encodings as defined in ISO 8348.  It is a local protocol
matter to convert the ascii string into the correct byte encoding.

(i.e. afi=08 is stored as two ascii bytes: 0x3038
            and not as a two byte integer: 0x0012)
 
.SH PUBLIC MEMBERS

.in 5
.B

Bytes afi
.in 10
.fi
 OSI Authority and Format Identifier 
.in 5
.B

Bytes idi
.in 10
.fi
 OSI Initial Domain Identifier 
.in 5
.B

Bytes dsp
.in 10
.fi
 OSI Domain Specific Part 
.in 5
.B

NETaddr& copy()
.in 10
.fi
 make a copy of the Object 
.in 5
.B

virtual void ask(Istream& )
.in 10
.fi
 cin >> PSAPaddr 
.in 5
.B

virtual void to(ODump& )
.in 10
.fi
 Channel encoder. 
.in 5
.B

virtual void from(IDump& )
.in 10
.fi
 Channel decoder. 
.in 5
.B

NETaddr& operator =(NETaddr& )
.in 10
.fi
 assignment 
.in 5
.B

boolean operator ==(NETaddr& )
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator ==(NSAPaddr& )
.in 10
.fi
 Equivalent if any NETaddr in  NSAPaddr matches. 
.in 5
.B

boolean operator !=(NETaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NSAPaddr& x)
.in 10
.fi
 non-equivalence 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 NETaddr()
.in 10
.fi



.SH FILE
isoaddrs.hxx
.TH NSAPaddr 3 - 
.SH CLASS
NSAPaddr
.SH PUBLIC BASE CLASSES
.IP Object 10


.SH DESCRIPTION
.fi

Network Sevice Access Point (NSAP) :

An NSAPaddr is a base class that can be used to represent an OSI
Network Service access point (NSAP).

An "NSAPaddr" consists of two parts:
.nf
	- na_selector : arbitrary format string that selects the layer 
		above the network layer.  However, it is quite common
		for other OSI vendors to use a 2 byte GOSIP identifier.
	- na_addrs array : A choice of up to 4 possible physical network
		addresses (see NETaddr above).
.fi
 
.SH PUBLIC MEMBERS

.in 5
.B

Bytes na_selector
.in 10
.fi
 network selector string 
.in 5
.B

NETaddr* na_addrs[NTADDR]
.in 10
.fi
 Array of physical netwk addresses 
.in 5
.B

int na_naddr
.in 10
.fi
 Number of network addresses 
.in 5
.B

NSAPaddr& copy()
.in 10
.fi
 make a copy of the Object 
.in 5
.B

virtual void reset()
.in 10
.fi
 make object empty 
.in 5
.B

virtual void ask(Istream& )
.in 10
.fi
  cin >> NSAPaddr 
.in 5
.B

virtual void print(Ostream& )
.in 10
.fi
 cout << NSAPaddr 
.in 5
.B

virtual void to(ODump& )
.in 10
.fi
 Channel encoder. 
.in 5
.B

virtual void from(IDump& )
.in 10
.fi
 Channel decoder. 
.in 5
.B

NSAPaddr& operator =(NSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

boolean operator ==(NSAPaddr& )
.in 10
.fi
 Equivalent if any NETaddr  in NSAPaddr matches any NETaddr  in other NSAPaddr and   na_selectors match. 
.in 5
.B

boolean operator ==(NETaddr& x)
.in 10
.fi
 Equivalent if any NETaddr  in NSAPaddr matches. 
.in 5
.B

boolean operator !=(NETaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NSAPaddr& x)
.in 10
.fi
 non-equivalence 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 NSAPaddr()
.in 10
.fi

.in 5
.B

 NSAPaddr(char* )
.in 10
.fi
 Construct an NSAPaddr from a ascii string of  form : "nsel/NS+afi+idi+dsp|NS+afi+idi+dsp" 
.in 5
.B

 NSAPaddr(NSAPaddr& )
.in 10
.fi

.in 5
.B

 NSAPaddr(NETaddr& )
.in 10
.fi



.SH FILE
isoaddrs.hxx
.TH TSAPaddr 3 - 
.SH CLASS
TSAPaddr
.SH PUBLIC BASE CLASSES
.IP NSAPaddr 10


.SH DESCRIPTION
.fi

Transport Service Access Point:

"TSAPaddr" is a derived class that can be used to represent an OSI
Transport Service access point (TSAP).

"TSAPaddr" consists of a NSAPaddr (via inheritance) and a "ta_selector" 
to select the layer on top of the TSAP (i.e. session layer).
The ta_selector can be a 2-byte GOSIP selector (e.g. '0001'H is the ISO
session layer), or a longer implementation dependent string.
 
.SH PUBLIC MEMBERS

.in 5
.B

Bytes ta_selector
.in 10
.fi
 transport selector string. 
.in 5
.B

TSAPaddr& copy()
.in 10
.fi
 make a copy of the Object 
.in 5
.B

virtual void reset()
.in 10
.fi
 make object empty 
.in 5
.B

virtual void ask(Istream& )
.in 10
.fi
 cin >> PSAPaddr 
.in 5
.B

virtual void print(Ostream& )
.in 10
.fi
 cout << TSAPaddr 
.in 5
.B

TSAPaddr& operator =(TSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

TSAPaddr& operator =(NSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

TSAPaddr& operator =(NETaddr& )
.in 10
.fi
 assignment 
.in 5
.B

boolean operator ==(TSAPaddr& )
.in 10
.fi
 Equivalent if ta_selector's and  NSAPaddr's match. 
.in 5
.B

boolean operator ==(NSAPaddr& x)
.in 10
.fi
 Equivalent if NSAPaddr's match. 
.in 5
.B

boolean operator ==(NETaddr& x)
.in 10
.fi
 Equivalent if any NETaddr in  matches. 
.in 5
.B

boolean operator !=(TSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NETaddr& x)
.in 10
.fi
 non-equivalence 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 TSAPaddr()
.in 10
.fi

.in 5
.B

 TSAPaddr(char* )
.in 10
.fi
 Construct an NSAPaddr from a ascii string of  form : Form: "tsel/nsel/NS+afi+idi+dsp" 
.in 5
.B

 TSAPaddr(NSAPaddr& )
.in 10
.fi

.in 5
.B

 TSAPaddr(TSAPaddr& tmp)
.in 10
.fi



.SH FILE
isoaddrs.hxx
.TH SSAPaddr 3 - 
.SH CLASS
SSAPaddr
.SH PUBLIC BASE CLASSES
.IP TSAPaddr 10


.SH DESCRIPTION
.fi

Session Service Access Point:

"SSAPaddr" is a derived class that can be used to represent an OSI
Session Service access point (SSAP).

"SSAPaddr" consists of a TSAPaddr (via inheritance) and a "sa_selector" 
to select the layer on top of the SSAP (i.e. session layer).
The sa_selector can be a 2-byte GOSIP selector (e.g. '0001'H is the ISO
presentaion layer), or a longer implementation dependent string.
 
.SH PUBLIC MEMBERS

.in 5
.B

Bytes sa_selector
.in 10
.fi
 session selector string 
.in 5
.B

SSAPaddr& copy()
.in 10
.fi
 make a copy of the Object 
.in 5
.B

virtual void reset()
.in 10
.fi
 make object empty 
.in 5
.B

virtual void ask(Istream& )
.in 10
.fi
 cin >> PSAPaddr 
.in 5
.B

virtual void print(Ostream& )
.in 10
.fi
 cout << SSAPaddr 
.in 5
.B

SSAPaddr& operator =(SSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

SSAPaddr& operator =(TSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

SSAPaddr& operator =(NSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

boolean operator ==(SSAPaddr& )
.in 10
.fi
 Equivalent if sa_selector, and  TSAPaddr's match. 
.in 5
.B

boolean operator ==(TSAPaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator ==(NSAPaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator ==(NETaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator !=(SSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(TSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NETaddr& x)
.in 10
.fi
 non-equivalence 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 SSAPaddr()
.in 10
.fi

.in 5
.B

 SSAPaddr(char* )
.in 10
.fi
 Construct an SSAPaddr from a ascii string of  form : "ssel/tsel/nsel/NS+afi+idi+dsp" 
.in 5
.B

 SSAPaddr(NSAPaddr& tmp)
.in 10
.fi
 !WARNING move! 
.in 5
.B

 SSAPaddr(TSAPaddr& tmp)
.in 10
.fi
 !WARNING move! 
.in 5
.B

 SSAPaddr(SSAPaddr& tmp)
.in 10
.fi
 !WARNING move !  


.SH FILE
isoaddrs.hxx
.TH PSAPaddr 3 - 
.SH CLASS
PSAPaddr
.SH PUBLIC BASE CLASSES
.IP SSAPaddr 10


.SH DESCRIPTION
.fi

Presentation Layer Service Access Point:

"PSAPaddr" is a derived class that can be used to represent an OSI
Presentation Service access point (PSAP).

"PSAPaddr" consists of a SSAPaddr (via inheritance) and a "pa_selector" 
to select the layer on top of the PSAP (i.e. application layer (FTAM, DTAM,
X500, ...).

The pa_selector can be a 2-byte GOSIP selector (e.g. '0101'H is the GOSIP
selector for an ISO X.500 application layer), or a longer implementation 
dependent string (e.g. "pres").

PSAPaddr, SSAPaddr, TSAPaddr, NSAPaddr, and NETaddr can all constructed 
from simple ASCII strings according to the following format :

.SH STRING ENCODING OF PRESENTATION ADDRESSES
.nf

The BNF grammar for the strings looks like:

<presentation_address>	::= [<psel> "/" ] session_address
<session_address>	::= [<ssel> "/" ] transport_address
<transport_address>	::= [<tsel> "/" ] network_address
<network_address>	::= [<nsel> "/" ] <phys_net_address_list>
<phys_net_address_list> ::=
	<phys_net_address> "|" <phys_net_address_list>
	| <phys_net_address>

<psel> ::= <selector>
<ssel> ::= <selector>
<tsel> ::= <selector>
<nsel> ::= <selector>
     
<selector> ::= <string> | <hexstring> 

<phys_net_address> ::=  "NS" + <afi> "+" <idi> [ "+" <dsp> ]
     
<afi> ::= <digitstring>
<idi> ::= <digitstring>
<dsp> ::= <digitstring>			-- OSI dsp
          | <portnum> "@" <quadstring>	-- fake TCPIP dsp (e.g 102@tel.vtt.fi)
     
quadstring ::=
	digitstring "." digitstring "." digitstring [ "." digitstring ]
	| otherstring "." otherstring "." otherstring [ "." otherstring ]
	-- e.g. 130.188.12.1  OR  tel3.tel.vtt.fi

<portnum> ::= <digitstring>	-- e.g. 102

<digit>    ::= [09]
<other>    ::= [09azAZ+.]
<hexdigit> ::= [09af]
     
<digitstring> ::= <digit> <digitstring> | <digit>
<hexstring>   ::= <hexdigit> <hexstring> | <hexdigit>

     
.SH EXAMPLES
.nf
PSAPaddr p1("101H/1H/01H/001H/NS+0+0+0001");	-- psel/ssel/tsel/nsel/naddr
SSAPaddr s1("01H/01H/01H/NS+0+0+0001");		--      ssel/tsel/nsel/naddr
TSAPaddr t1("01H/01H/NS+0+0+0001");		--           tsel/nsel/naddr
NSAPaddr n1("01H/NS+0+0+0001");			--                nsel/naddr
NETaddr n1("NS+0+0+0001|NS+54+00728722+102@tel3.tel.vtt.fi");	-- phys network
.fi
 
.SH PUBLIC MEMBERS

.in 5
.B

Bytes pa_selector
.in 10
.fi
 presentation selector string 
.in 5
.B

PSAPaddr& copy()
.in 10
.fi
 make a copy of the Object 
.in 5
.B

virtual void reset()
.in 10
.fi
 make object empty 
.in 5
.B

virtual void ask(Istream& )
.in 10
.fi
 cin >> PSAPaddr 
.in 5
.B

virtual void print(Ostream& )
.in 10
.fi
 cout << PSAPaddr 
.in 5
.B

PSAPaddr& operator =(PSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

PSAPaddr& operator =(SSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

PSAPaddr& operator =(TSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

PSAPaddr& operator =(NSAPaddr& )
.in 10
.fi
 assignment 
.in 5
.B

boolean operator ==(PSAPaddr& )
.in 10
.fi
 Equivalent if pa_selector  and SSAPaddr's match. 
.in 5
.B

boolean operator ==(SSAPaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator ==(TSAPaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator ==(NSAPaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator ==(NETaddr& x)
.in 10
.fi
 equivalence 
.in 5
.B

boolean operator !=(PSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(SSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(TSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NSAPaddr& x)
.in 10
.fi
 non-equivalence 
.in 5
.B

boolean operator !=(NETaddr& x)
.in 10
.fi
 non-equivalence 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 PSAPaddr()
.in 10
.fi

.in 5
.B

 PSAPaddr(char* )
.in 10
.fi
 Construct a PSAPaddr from an ascii string  of form: "psel/ssel/tsel/nsel/NS+afi+idi+dsp" 
.in 5
.B

 PSAPaddr(NSAPaddr& tmp)
.in 10
.fi

 !WARNING move!  
.in 5
.B

 PSAPaddr(TSAPaddr& tmp)
.in 10
.fi

 !WARNING move!  
.in 5
.B

 PSAPaddr(SSAPaddr& tmp)
.in 10
.fi

 !WARNING move!  
.in 5
.B

 PSAPaddr(PSAPaddr& tmp)
.in 10
.fi

 alias 

.SH FILE
isoaddrs.hxx
