.TH Group 3 - 
.SH CLASS
Group (abstract base class, only derived classes can be instantiated)
.SH PUBLIC BASE CLASSES
.in 4
.B
Multi
.in 7
.fi


.SH DESCRIPTION
.fi

Class Group is an abstract base class for Runner pointer containers.
The Group element type (GE) is Runner*.
Derived classes are specialized container classes
(such as Fifo, Lifo, Heap, Ring, Priorvec) that define which element
is taken from the Group next.
These derived classes must share basic properties
(defined virtually in the base class Group), so they can be used
interchangeably without major re-writes of user code that
uses a specific group :

(1) Uniform Container Contents : all contain Runner pointers,
which can of course point to any object derived from Runner. 

(2) Uniform Access of Container contents : put() and get().

(3) Iteration thru the elements of a group in a group-independent fashion:
.nf

    GP aid;	//GP is void*, stores the current position in Group
    Group* g = ...
    for (Runner* r = g->first(aid); !g->over(aid); r = g->next(aid)) {
        //...use r...
    }

.fi
Think twice before using iteration, put() and get() are the basic 
services provided by Groups.

Most of the derived Groups are "dynamic": 
put() increases the number of elements, and get() decreases it.
Ring, however, is an exception: put() does nothing, 
and get() gives a Runner* but does not extract it from the Ring.
Therefore there are "stronger" operations for inserting and extracting
elements to/from any kind of Group (Ring and all others):
putAnyway() and getAnyway().
These operations always increase/decrease the number of elements.

.SH BUGS
Probably we should have put for 1, 2, 3, etc. parameters, not
default parameters => put(&) instead of put(*) ???

Type-casting the pointer returned by get() is dangerous.  
Write a container class of your own or take a look
at class VoidGroup if you need Groups of other types than Runners.

If the number of elements is big, print() should print only the first
few element names, " ... ", and the last element name.

get() should return the extracted Runner*.
 
.SH PUBLIC MEMBERS


.SH Group services
 
.in 4
.B

virtual Group& put(const GE r)
.in 7
.fi
Add one Runner into the Group. Return *this. Ring is an exception. 
.in 4
.B

virtual Group& get(GE& r)
.in 7
.fi
Remove one Runner* from Group to r. r = &dummyRunner if empty group. Returns *this. Ring is an exception. 
.in 4
.B

Group& put(const GE o1, const GE o2, const GE o3 = 0, const GE o4 = 0, const GE o5 = 0, const GE o6 = 0)
.in 7
.fi
Add runners to the group, return *this.  Ring is an exception. 
.in 4
.B

GE head()
.in 7
.fi
Without removing, return  the Runner that get() would return. 
.in 4
.B

sint32 size() const
.in 7
.fi
Number of elements (Runner*'s) currently in the Group. 
.in 4
.B

virtual Group& putAnyway(const GE r)
.in 7
.fi
Add one Runner into the Group,  even if it is permanent by nature  (get() does not remove elements) such as Ring. Returns *this. 
.in 4
.B

virtual Group& getAnyway(GE& r)
.in 7
.fi
Remove one Runner* from Group to r, even if the Group is permanent by nature  (get() does not remove elements)  such as Ring. r = &dummyRunner if empty group. Returns *this. 

.SH Iteration
 
.in 4
.B

virtual GE first(GP& )
.in 7
.fi
 
.in 4
.B

virtual GE next(GP& )
.in 7
.fi
 
.in 4
.B

virtual boolean over(const GP )
.in 7
.fi
 

.SH Miscellaneous
 
.in 4
.B

virtual void print(Ostream& os)
.in 7
.fi
Prints '(', the space separated name()'s  of Group elements, and ')' to os. 
.in 4
.B

virtual void reset()
.in 7
.fi
reset() elements one by one, make the Group empty.  
.in 4
.B

virtual boolean isEmpty()
.in 7
.fi
true if no elements, or isEmpty() is true for all the elements. 
.SH PROTECTED MEMBERS

.in 4
.B

sint32 size_
.in 7
.fi
Number of elements (Runner*'s) currently in the Group. 

.SH FILE
group.hxx
.TH Link 3 - 
.SH CLASS
Link

.SH DESCRIPTION
.fi

A Link attaches Group elements.  It is used in derived class implementations.
Each Group has its own list of Links,
so that any Runner may belong to several independent Groups.
The elements do not contain any pointers to other elements.
.SH BUGS
It might be interesting to define a special memory allocation algorithm
for Link and see how it affects performance.
 
.SH PUBLIC MEMBERS

.in 4
.B

GE element
.in 7
.fi
 
.in 4
.B

Link* next
.in 7
.fi
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Link(const GE e, Link* n)
.in 7
.fi
 

.SH FILE
group.hxx
