.TH Commented 3 - 
.SH CLASS
Commented

.SH DESCRIPTION
.fi

Each class derived from Commented may have comment text associated with it,
for example an OperHeader (class operation prototype).
C style (old) block comments should be written 
before the object (class, for example),
while C++ style line comments after the object (e.g. operation).

When the OTSO preprocessor encounters C style block comment text, 
the text is copied to lastComment.
The next Commented will get get lastComment.(?)
When lineComments are encountered, 
the comment text is appended to the latest instance of Commented.
 
.SH PUBLIC MEMBERS

.in 5
.B

static Commented* current
.in 10
.fi
The latest Commented instance that will "own" the possible comments. 
.in 5
.B

static String* lastComment
.in 10
.fi
Contains always the latest C style block comment. 
.in 5
.B

String blockComments
.in 10
.fi
 /*...*/ comment text associated with this Commented. 
.in 5
.B

String lineComments
.in 10
.fi
 //... comment text associated with this Commented. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 Commented()
.in 10
.fi



.SH FILE
classdef.hxx
.TH Param 3 - 
.SH CLASS
Param
.SH PUBLIC BASE CLASSES
.IP Runner 10


.SH DESCRIPTION
.fi

Relevant information of one function parameter in text string format.
 
.SH PUBLIC MEMBERS

.in 5
.B

void printAsMember(Ostream& )
.in 10
.fi
part of members() function 
.in 5
.B

String type
.in 10
.fi
type name 
.in 5
.B

String indirection
.in 10
.fi
string of '*'s and '&'s 
.in 5
.B

String name() const
.in 10
.fi
parameter name 
.in 5
.B

String parName
.in 10
.fi
parameter name 
.in 5
.B

String bracketedText
.in 10
.fi
text between '[' and ']', array size 
.in 5
.B

boolean isPointer
.in 10
.fi
any '*'s in indirection? 
.in 5
.B

boolean isReference
.in 10
.fi
any '&'s in indirection? 
.in 5
.B

boolean isConstant
.in 10
.fi
const parameter? 
.in 5
.B

boolean isEnumVariable
.in 10
.fi
True only if type is an enum declared in this class scope. 
.in 5
.B

boolean isOtsoSupported()
.in 10
.fi
When true, OTSO supports distribution and and user interface for this parameter. 
.in 5
.B

Param* oper
.in 10
.fi
the OperHeader that owns this 
.in 5
.B

ParamMode mode()
.in 10
.fi
COPY, MOVE or MODIFY parameter 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 Param()
.in 10
.fi



.SH FILE
classdef.hxx
.TH OperHeader 3 - 
.SH CLASS
OperHeader
.SH PUBLIC BASE CLASSES
.IP Param 10

.IP Commented 10


.SH DESCRIPTION
.fi

 Info of one class member function
 
.SH PUBLIC MEMBERS

.in 5
.B

Fifo paramQ
.in 10
.fi
list of function parameter info Params 
.in 5
.B

void print(Ostream& )
.in 10
.fi
Print in function prototype format for service document. 
.in 5
.B

boolean isStatic
.in 10
.fi
true if static member (1/class) 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 OperHeader()
.in 10
.fi



.SH FILE
classdef.hxx
.TH BaseClass 3 - 
.SH CLASS
BaseClass
.SH PUBLIC BASE CLASSES
.IP Object 10

.IP Commented 10


.SH DESCRIPTION
.fi

 Info of one base class
 
.SH PUBLIC MEMBERS

.in 5
.B

boolean isVirtual
.in 10
.fi
true if virtual base class 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 BaseClass()
.in 10
.fi



.SH FILE
classdef.hxx
.TH ClassDef 3 - 
.SH CLASS
ClassDef
.SH PUBLIC BASE CLASSES
.IP Runner 10
only because Group contains Runners 
.IP Commented 10


.SH DESCRIPTION
.fi

 A ClassDef object stores the text Strings of one class
 definition relevant for prepro's code generation.
 
.SH PUBLIC MEMBERS

.in 5
.B

ClassType classType
.in 10
.fi
 
.in 5
.B

String name() const
.in 10
.fi
class name 
.in 5
.B

String clName
.in 10
.fi
class name 
.in 5
.B

VoidFifo baseClasses
.in 10
.fi
list of base classes 
.in 5
.B

Fifo operQ
.in 10
.fi
list of member function OperHeaders 
.in 5
.B

void printHeader(Ostream& os)
.in 10
.fi
generates .hxx to os 
.in 5
.B

void printCode(Ostream& os)
.in 10
.fi
generates .cxx to os 
.in 5
.B

void printService(Ostream& os, String& headerFile)
.in 10
.fi
generates service document to os. headerName is the header file name (!=maintained :(  
.in 5
.B

boolean generateMessageClasses(MemberType member)
.in 10
.fi
true if message class is needed for member 
.in 5
.B

boolean generateCodingFunctions
.in 10
.fi
true if asn1ClassType and $COD > 0 
.in 5
.B

boolean generateTestingFunctions
.in 10
.fi
true if asn1ClassType and $TST > 0 
.in 5
.B

boolean isAbstractBaseClass
.in 10
.fi
true iff at least one member function = 0; 
.in 5
.B

Access memberAccess
.in 10
.fi
set by "public:", "private:", "protected:" 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 ClassDef()
.in 10
.fi



.SH FILE
classdef.hxx
.TH LineNumber 3 - 
.SH CLASS
LineNumber

.SH DESCRIPTION
.fi



 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 LineNumber(slong i = 0)
.in 10
.fi



.SH FILE
classdef.hxx
.TH TextFSAItem 3 - 
.SH CLASS
TextFSAItem
.SH PUBLIC BASE CLASSES
.IP Runner 10


.SH DESCRIPTION
.fi

 Info of one Finite State Automaton triplet (state-input-actions)
 in text strings
 
.SH PUBLIC MEMBERS

only because Group contains Runners 
.in 5
.B

String automatonName
.in 10
.fi
given in AUTOMATON(xxx, ) 
.in 5
.B

String stateVariable
.in 10
.fi
given in AUTOMATON( ,xxx) 
.in 5
.B

String state
.in 10
.fi
automaton state (1st column) 
.in 5
.B

String functionType
.in 10
.fi
optionally between state and input 
.in 5
.B

String functionName
.in 10
.fi
functionName without class, ::, parentheses 
.in 5
.B

String functionPars
.in 10
.fi
parentheses and the stuff inside them 
.in 5
.B

LineNumber functionLineNr
.in 10
.fi
source file line number of AUTOMATON input 
.in 5
.B

String actions
.in 10
.fi
all the stuff inside braces { } 
.in 5
.B

LineNumber actionLineNr
.in 10
.fi
source file line number of 1st action 
.in 5
.B

virtual boolean greaterThan(Runner& )
.in 10
.fi
for sorting by functionNames   virtual void	print(Ostream&);//for debugging 


.SH FILE
classdef.hxx
