.TH Channel 3 - 
.SH CLASS
Channel
.SH PUBLIC BASE CLASSES
.in 4
.B
Runner
.in 7
.fi


.SH DESCRIPTION
.fi

Channels (or Streams) transform objects to byte strings
or byte strings to objects.
Objects can be inserted to OStreams, producing bytes 
(e.g. dout << message), or extracted from IStreams, consuming bytes
and creating an object (e.g. din >> parameter).

Channels are communication pipes, or byte streams.
Istreams and Ostreams are generally used for user input and output.
An OStream prints objects in a human readable form.
An IStream reads terminal input, translating the human readable representation
into an internal object representation.
Derived OStreams take care of encoding objects to some transfer syntax,
while derived IStreams do the decoding.
For each transfer syntax, an OStream-IStream pair is written.

IDumps and ODumps are inter-process communication (IPC) channels, that 
are intended to impose a transfer syntax on the messages passed thru
them by overloading of the << and >> operators.

Printing, asking, encoding, and decoding functions are an important
part of the 'OTSO interface' definition for a type.
Objects are inserted to a Channel by "ch << obj".
Ostream's operator<< calls obj's printing function,
ODump::operator<< calls obj's encoding function.
Objects are extracted from a Channel by "ch >> obj".
Istream's operator>> calls obj's asking function,
IDump::operator>> calls obj's decoding function.

.SH BUGS

The implementation is somewhat tied to the operating system used,
since channels should be watched for activity (some event occurance),
before the body of the Channel's run() function is executed,
to prevent blocking a thread if there is nothing to read, for example.
However, the thread gets blocked if the beginning but not the end of a message
is readable or writable.

Currently, only BSD Unix Devices are supported in OTSO.


Cfront needs to use file streams, not plain streams.  Code
has been ifdef'd to work either Cfront way or g++ way.
(jimmy 22.11.90)

*BSD-NOTE*
  I have added class ServerSocket as a friend to an Istream, because
the Istream should be constructed immediately from a Device, but
this can't happen in this case; because until a client connects to
the ServerSocket, no ServiceSocket exists for the Istream (for reads/writes).
Therefore the ServerSocket must accept a client connection, create a
ServiceSocket to handle the connection, and then modify the appropriate
Istream so it has a pdevice = new ServiceSocket.  This only for BSD UNIX.
(jim 12.11.90)


 
.SH PUBLIC MEMBERS

.in 4
.B

FileDescriptor& fd()
.in 7
.fi
 

.SH FILE
channel.hxx
.TH Filebuf 3 - 
.SH CLASS
Filebuf
.SH PUBLIC BASE CLASSES
.in 4
.B
filebuf
.in 7
.fi


.SH DESCRIPTION
.fi

Filebuf is the iostream library filebuf with redefined underflow 
and overflow functions to take care of input/output logging.
 
.SH PUBLIC MEMBERS

.in 4
.B

virtual int underflow()
.in 7
.fi
Actions to be performed when input buffer has exhausted  (read from file etc.). 
.in 4
.B

virtual int overflow(int c = EOF)
.in 7
.fi
Actions to be performed when output buffer is full   (write to file etc.). 
.in 4
.B

void putBack(String& s)
.in 7
.fi
putback s, even though s may be long. 
.in 4
.B

boolean isEmpty()
.in 7
.fi
true if no chars in the buffer 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Filebuf(int fd)
.in 7
.fi

.in 4
.B

 Filebuf(int fd, char* tab, int len)
.in 7
.fi


.SH FILE
channel.hxx
.TH OstreamIndent 3 - 
.SH CLASS
OstreamIndent

.SH DESCRIPTION
.fi

This is just a new type that is used for overloading.
It is needed to implement 'ostream << INDENT'.
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 OstreamIndent(sint16 )
.in 7
.fi
g++ complains without this 

.SH FILE
channel.hxx
.TH IstreamSP 3 - 
.SH CLASS
IstreamSP (abstract base class, only derived classes can be instantiated)

.SH DESCRIPTION
.fi

Defines e.g. Istream's interface to command interpreter.
 
.SH PUBLIC MEMBERS

read by OTSO prepro only 
.in 4
.B

virtual void Exit()
.in 7
.fi
exit OTSO 
.in 4
.B

virtual void debug()
.in 7
.fi
Go to debugger (set a break point in ::debug()) 
.in 4
.B

virtual void outputRedirection(String filename, boolean isDoutLoggingThereToo)
.in 7
.fi
logging: copy input and output  to a file 
.in 4
.B

virtual void inputRedirection(String filename)
.in 7
.fi
read command input from a file 
.in 4
.B

virtual void logInputToFile(boolean yes_1_or_no_0)
.in 7
.fi
Set din input logging to file  on or off. 

.SH FILE
channel.hxx
.TH OstreamSP 3 - 
.SH CLASS
OstreamSP (abstract base class, only derived classes can be instantiated)

.SH DESCRIPTION
.fi

Defines e.g. Ostream's interface to command interpreter.
 
.SH PUBLIC MEMBERS

read by OTSO prepro only 
.in 4
.B

virtual void outputLogging(String filename, boolean isDinLoggingThereToo)
.in 7
.fi
logging: copy (!) output to file 
.in 4
.B

virtual void logOutputToFile(boolean yes_1_or_no_0)
.in 7
.fi
Logging dout output to file: set on or off. 

.SH FILE
channel.hxx
.TH Ostream 3 - 
.SH CLASS
Ostream
.SH PUBLIC BASE CLASSES
.in 4
.B
Channel
.in 7
.fi

.in 4
.B
ostream_withassign
.in 7
.fi

.in 4
.B
OstreamSP
.in 7
.fi

.SH PUBLIC MEMBERS

.in 4
.B

Device* pdevice
.in 7
.fi
asynchronous OTSO output device. 
.in 4
.B

FILE* fdstream
.in 7
.fi
created from fd ... ? 
  ostream_withassign		os;	
.in 4
.B

ofstream* pofs
.in 7
.fi
for Ostream(fd) ctor 
.in 4
.B

void addIndent(sint16 delta)
.in 7
.fi
Add or decrease indentLevel_ to  change the subsequent indents. 
.in 4
.B

Ostream& operator <<(OstreamIndent dummy)
.in 7
.fi
Print 'indentLevel_' spaces. 
.in 4
.B

virtual void logOutputToFile(boolean yes_1_or_no_0 =false)
.in 7
.fi
Copying dout output to file: set on (true) or off. 

.SH Connection to the receiver
 
.in 4
.B

boolean isConnected()
.in 7
.fi
True if this has a device that is  connected to a receiving device. 
.in 4
.B

boolean connect()
.in 7
.fi
Attempt to establish a connection, return true if successful. 
.in 4
.B

sint32 indentLevel()
.in 7
.fi
returns indentLevel_ 

.SH Logging
 
.in 4
.B

virtual void outputLogging(String filename, boolean isDinLoggingThereToo)
.in 7
.fi
send output to file= 
.in 4
.B

boolean logging
.in 7
.fi
log state 
.in 4
.B

Ostream* logger
.in 7
.fi
log stream 
.SH PROTECTED MEMBERS

.in 4
.B

int port_
.in 7
.fi
e.g. 4000 
.in 4
.B

String hostName_
.in 7
.fi
e.g. "tel2" 
.in 4
.B

boolean isConnected_
.in 7
.fi
True if clientSocket->Connect was successful. 
.in 4
.B

ClientSocket* clientSocket_
.in 7
.fi
the same as pdevice!? but of type ClientSocket* 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Ostream(ClientSocket* , String hostName, sint16 port)
.in 7
.fi
 
.in 4
.B

 Ostream(Ostream& O, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Ostream(ostream& o, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Ostream(Device* pdev, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Ostream()
.in 7
.fi

.in 4
.B

 Ostream(Ostream& O, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Ostream(ostream& o, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Ostream(Device* pdev, Ostream* log =NULL)
.in 7
.fi


.SH FILE
channel.hxx
.TH Istream 3 - 
.SH CLASS
Istream
.SH PUBLIC BASE CLASSES
.in 4
.B
Channel
.in 7
.fi

.in 4
.B
istream_withassign
.in 7
.fi

.in 4
.B
IstreamSP
.in 7
.fi


.SH DESCRIPTION
.fi

Istreams decode a byte stream into variables.
There is one derived Istream for each transfer syntax.
The basic Istream reads from a human writer.
Istream objects must be run every now and then.
 
.SH PUBLIC MEMBERS

.in 4
.B

boolean isReadyToRead()
.in 7
.fi
true iff there is something to read in buffer 

.SH Logging
 
.in 4
.B

boolean logging
.in 7
.fi
log state (true: log Istream::operator>>) 
.in 4
.B

Ostream* logger
.in 7
.fi
log stream 
.in 4
.B

Ostream* tiedTo()
.in 7
.fi
like istream::tie() but Ostream* 
.in 4
.B

Device* pdevice
.in 7
.fi
asynchronous OTSO input device. 
.in 4
.B

FILE* fdstream
.in 7
.fi
created from fd ... ? 
.in 4
.B

ifstream* pifs
.in 7
.fi
ctor (int fd) 
.in 4
.B

virtual void Exit()
.in 7
.fi
exit OTSO 
.in 4
.B

virtual void debug()
.in 7
.fi
Go to debugger (if there is a break point in debug() function) 
.in 4
.B

virtual void outputRedirection(String filename, boolean isDoutLoggingThereToo)
.in 7
.fi
send output to file (log?) 
.in 4
.B

virtual void inputRedirection(String filename)
.in 7
.fi
read input from file 
.in 4
.B

virtual void logInputToFile(boolean yes_1_or_no_0 =false)
.in 7
.fi
Copying input to log file: set on or off. 
.SH PROTECTED MEMBERS


.SH Command interpreter
 
.in 4
.B

virtual void commandInterpreter()
.in 7
.fi
Read and interpret a command. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Istream(Istream& I, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Istream(istream& i, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Istream(Device* pdev, Ostream* out =NULL, int skip =0, Ostream* log =NULL)
.in 7
.fi
old 
.in 4
.B

 Istream(istream& i, Device* pdev, Ostream* out =NULL, int skip =0, Ostream* log =NULL)
.in 7
.fi
new 
.in 4
.B

 Istream(String filename)
.in 7
.fi
e.g. macro file input 
.in 4
.B

 Istream()
.in 7
.fi

.in 4
.B

 Istream(const Istream& i, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Istream(const istream& i, Ostream* log =NULL)
.in 7
.fi

.in 4
.B

 Istream(Device* pdev, Ostream* out =NULL, int skip =0, Ostream* log =NULL)
.in 7
.fi


.SH MORE ABOUT CLASS Istream
.in 4
  

.SH FILE
channel.hxx
.TH ODump 3 - 
.SH CLASS
ODump
.SH PUBLIC BASE CLASSES
.in 4
.B
Ostream
.in 7
.fi


.SH DESCRIPTION
.fi

ODump and IDump specify the transfer syntax between two address spaces.
ODump and IDump implement a very simple, default version of 
inter-process communication.  It is not fast, reliable, or elegant.

ODump encodes objects by applying their to() operation.
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 ODump(Ostream& O)
.in 7
.fi

.in 4
.B

 ODump(ostream& o)
.in 7
.fi

.in 4
.B

 ODump(Device* pdev)
.in 7
.fi

.in 4
.B

 ODump(ClientSocket* , String hostName, sint16 port)
.in 7
.fi
 

.SH FILE
channel.hxx
.TH IDump 3 - 
.SH CLASS
IDump
.SH PUBLIC BASE CLASSES
.in 4
.B
Istream
.in 7
.fi


.SH DESCRIPTION
.fi

IDump decodes objects by applying their from() operation.
IDump objects must be run every now and then.
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 IDump(Istream& I)
.in 7
.fi

.in 4
.B

 IDump(istream& i)
.in 7
.fi

.in 4
.B

 IDump(Device* pdev, ODump* out =NULL, int skip =0)
.in 7
.fi

.in 4
.B

 IDump()
.in 7
.fi


.SH FILE
channel.hxx
