/*********************************************************************
FILE sdoctest.hxx - an example for testing and demonstrating (p)sdoc
**********************************************************************/

/**********************************************************************
Description of the class goes here.
TestClass is general a purpose class that can be used to do anything.

A new paragraph 
etc ........................

.SH BUGS
No bugs available.

.SH EXAMPLES
Here you see how to use TestClass.  
bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla 
bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla 
bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla 
Let's first switch filling off.

.nf
    TestClass t;
    int i = 1;
    t.myMethod(&i, 2);
.fi

Filling is on again.
bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla 
bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla 
**********************************************************************/

class TestClass : public MyMother,	//mom
                  public MyFather 	//Who is my father?
{

friend class MyFriendClass;		//Do I have any friends?
friend void friendFunction(int i);	//I have 2.

public:
                    //This comment is not associated with any member 
                    //because of 'public:'

  void myMethod (int* x, int y);
                    //Purpose:     Every man has a purpose.
                    //
                    //Parameters:  x, (in/out), allowed values etc.  
                    //y, (in), ...
                    //
                    //Errors:      Description of error situations and 
                    //appropriate approach
                    //
                    //Remarks:     Limitations, missing features, bugs etc.
/*
.SH Less interesting functions
*/
                    //This comment is not associated with any member 
                    //because of /*...*/.

  void slightlyInteresting();
                    //bla bla bla.  
                    //The function notInteresting() is not included in the 
                    //service document since it has no comments.

  void notInteresting();

  TestClass ();	    //
  operator MyAlternativeAppearance& ();
                    //conversion from TestClass to MyAlternativeAppearance&

protected:

  void myMethodForMyDescendants ();
                    //Purpose:     etc.
                    //
                    //Parameters:  formatting goes fine?
  sint32 aProtectedVariable;
                    //hello, world

private:
  void myPrivateMethod();
                    //This private stuff is not included in the man page.

  
  sint16 a;         //bla bla bla 
  sint16 b;	    //a
                    //long
                    //story about b
};

//Line comments for class TestClass.
//
//.SH SEE ALSO
//
//ARelatedClass(3)
//
//.SH PS 
//
//Original author Jari Kuittinen.  Modified by Juha Koivisto.

/* */
void sayHI() {	//The preceding empty /* */ is needed to keep this line comment
                //separated from TestClass line comments.  A semicolon
                //is another "separator".
  cout << "HI\n";
}

const int haha = 2; //There is no danger of putting this to TestClass's
                    //comments because a semicolon has been encountered.


const int a = 1;

/*Another class*/

class AnotherClass {
public:
  const int*& hai(); 		//hai is not a const function
  const int*& hui() const; 	//hui is a const function
};

