.TH sdoc 1 - 
.SH NAME
sdoc, psdoc \- prepare a service document of C++ class headers
.SH SYNOPSIS
.nf
sdoc filename
psdoc filename
.SH DESCRIPTION
.fi

sdoc reads C++ class headers and comments and generates service documents.
One file is handled at a time, and
a separate document is generated for each class.
sdoc generates ascii text, psdoc generates PostScript.
Use sdoc for terminal output, psdoc if you have a PostScript printer.

The document contains those parts of class definitions that are meaningful
for the users' of the class: the public part for those who use the 
services provided by the class, and the protected part for those who 
use the class as a base class for further derivation.
The generated document is meant to be easier to read than C++ files,
even though C++ syntax must be known to completely understand the document.
When the document is not detailed enough, look at the C++ header file.

Notice that implementation-specific comments are in the C++ code file.
Header file contains only description of the service,
and the bugs of the current implementation.

Some formatting conventions must be followed.
These conventions, in addition to making it possible for the prepro to 
associate the comments with the correct C++ classes and members,
make the header files more standardized and thus more readable.
See OTSO User's Guide for more information about the commenting style.

.SH EXAMPLE
See the listing of sdoctest.hxx and the output produced by psdoc.

.SH SEE ALSO
OTSO User's Guide for commenting style.

.SH BUGS
See prepro documents for information about prepro parsing deficiencies.

Because no C preprocessing is done, headers containing conditional
compilation directives may produce unsatisfactory results.

