/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/isoaddrs/SCCS/s.isoaddrs.cxx
 * Vers: 5.4    Time: 92/08/04, 16:24:34
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)isoaddrs.cxx	5.4 92/08/04";
#endif

/***************************************************************
* 
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* 
* 
***************************************************************/


/************************************************************************
* FILE
*	isoaddrs.cxx
*************************************************************************/

#define BYTES_HXX		1
#define CHANNEL_HXX		1
#define GROUP_HXX		1
#define MULTI_HXX		1
#define NAMEDOBJ_HXX		1
#define OBJECT_HXX		1
#define RUNNER_HXX		1
#define SAMPLED_HXX		1
#define STATOBJ_HXX		1
#define STRING_HXX		1
#define TIME_HXX		1
#define TYPE_HXX		1

#define OTSO_SELECT_INCLUDES	1	/* take only the above headers */
#include "OTSO.hxx"			/* include them now */

#ifndef ISOADDRS_HXX
#include "isoaddrs.hxx"
#endif



#define MAX_STRING 1024
static char query_string [MAX_STRING];

/*  */

/************** Physical Network Address ****************/

NETaddr& NETaddr::copy () {
  NETaddr *n = new NETaddr;
  n -> afi = this -> afi.copy();
  n -> idi = this -> idi.copy();
  n -> dsp = this -> dsp.copy();
  return *n;
}

NETaddr& NETaddr::operator= (NETaddr& naddr) {
  this -> afi = naddr.afi;
  this -> idi = naddr.idi;
  this -> dsp = naddr.dsp;
  return *this;
}

boolean NETaddr::operator==(NETaddr& rhs)
{
  if ((this -> afi == rhs.afi) && (this -> idi == rhs.idi) && 
      (this -> dsp == rhs.dsp)
  ) {
    return true;
  }
  return false;	/* default is not equals */
}

boolean NETaddr::operator==(NSAPaddr& rhs)
{
  /* does any NETaddr in NSAPaddr match ? */
  for (sint16 i=0; i < rhs.na_naddr; i++) {
    if (rhs.na_addrs[i]) {
      if (*rhs.na_addrs[i] == *this)
        return true;	
    }
  }
  return false;
}

void NETaddr::print (Ostream& os) {
  os << "NS+" << this -> afi << "+" << this -> idi << "+" << this -> dsp;
}
void NETaddr::ask (Istream& is) {
  is >> query_string;	// input formatted string
  PSAPaddr ptmp(query_string);
  if (ptmp.na_naddr > 0) {
    *this = *ptmp.na_addrs[0];		// !WARNING move!
  }
}


// encoding to/from a ODump/IDump IPC pair uses ascii string encoding
void NETaddr::to(ODump& od) {
 this -> print (od);
}
void NETaddr::from(IDump& id) {
 this -> ask(id);
}

/*  */

/*********** NETWORK SERVICE ACCESS POINT *************/

// empty out NSAPaddr
void NSAPaddr::reset() {
  if (this->na_selector.length() > 0) {
    this->na_selector.reset();
  }
  if (this->na_naddr > 0) {
    for (sint16 i=0; i<NTADDR; i++) {
      if (this->na_addrs[i]) {
        delete this -> na_addrs[i];
        this -> na_addrs[i] = NULL;
      }
    }
  }
}

void NSAPaddr::NSAPinit() {
  this -> na_naddr = 0;
  for (sint16 i=0; i<NTADDR; i++) { this -> na_addrs[i] = NULL; }
}

NSAPaddr::NSAPaddr() { this -> NSAPinit(); }

NSAPaddr::NSAPaddr (NSAPaddr& tmp) {
  this -> NSAPinit();
  *this = tmp;
}

NSAPaddr::NSAPaddr (char *str) {
  this -> NSAPinit();
  PSAPaddr psap(str);
  *this = psap;
}

/* WARNING: destructive to caller's arg */
NSAPaddr& NSAPaddr::operator= (NSAPaddr& rhs) {
  this -> na_selector = rhs.na_selector;
  this -> na_naddr    = rhs.na_naddr;

  rhs.na_naddr = 0;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    if (this -> na_addrs[i])
      delete this -> na_addrs[i];		// delete old
    this -> na_addrs[i] = rhs.na_addrs[i];	// move new
    rhs.na_addrs[i] = NULL;
  }
  rhs.reset();	/* empty derived class parts */
  return *this;
}

NSAPaddr& NSAPaddr::copy () {
  NSAPaddr *n = new NSAPaddr;
  n -> na_selector = this -> na_selector.copy();
  n -> na_naddr    = this -> na_naddr;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    n -> na_addrs[i] = new NETaddr;
    *(n -> na_addrs[i]) = this -> na_addrs[i] -> copy();	// move copy !!
  }
  return *n;
}

boolean NSAPaddr::operator== (NSAPaddr& rhs) {
  if (this -> na_selector != rhs.na_selector)
    return false;

  /* if any NETaddr matches, they are equivalent */
  if (this -> na_naddr > 0 && rhs.na_naddr > 0) {
    for (sint16 i=0; i < this -> na_naddr; i++) {
      for (sint16 j=0; j < rhs.na_naddr; j++) {
        if (this -> na_addrs[i] && rhs.na_addrs[j]) {
          if (*this -> na_addrs[i] == *this -> na_addrs[j]) {
            return true;	// selector and at least one na_addrs[] match
          }
        }
      }
    }
  }
  else {
    return true;	// no na_addrs[] exist, but selectors match
  }

  return false;	/* default */
}


void NSAPaddr::ask (Istream& is) {
  is >> query_string;	// input formatted string
  PSAPaddr ptmp(query_string);
  *this = ptmp;		// !WARNING move!
}

void NSAPaddr::print (Ostream& os) {
  os << this -> na_selector << "/NS+";
  for (sint16 i=0; i < this -> na_naddr; i++) {
    if (this -> na_addrs[i]) {
      os << this -> na_addrs[i]->afi 
         << "+" << this -> na_addrs[i]->idi 
         << "+" << this -> na_addrs[i]->dsp;
    }
    if (i < this -> na_naddr - 1)
      os << "|";
  }
}

// encoding to/from a ODump/IDump IPC pair uses ascii string encoding
// (TSAPaddr, SSAPaddr, PSAPaddr can use this, since they redefine
// print and ask.
void NSAPaddr::to(ODump& od) {
 this -> print (od);
}
void NSAPaddr::from(IDump& id) {
 this -> ask(id);
}

/*  */

/*********** TRANSPORT SERVICE ACCESS POINT***********/


// empty out NSAPaddr
void TSAPaddr::reset() {
  if (this->ta_selector.length() > 0) {
    this->ta_selector.reset();
  }
  if (this->na_selector.length() > 0) {
    this->na_selector.reset();
  }
  if (this->na_naddr > 0) {
    for (sint16 i=0; i<NTADDR; i++) {
      if (this->na_addrs[i]) {
        delete this -> na_addrs[i];
        this -> na_addrs[i] = NULL;
      }
    }
  }
}

TSAPaddr::TSAPaddr (char *str) {
  PSAPaddr tmp(str);
  *this = (TSAPaddr&)tmp;
}

TSAPaddr::TSAPaddr (NSAPaddr& n) {
  *this = n;
}

/* WARNING - destructive to called argument */
TSAPaddr& TSAPaddr::operator= (NSAPaddr& rhs) {
  this -> na_selector = rhs.na_selector;	/* !WARNING move ! */

  this -> na_naddr    = rhs.na_naddr;
  rhs.na_naddr = 0;

  rhs.na_naddr = 0;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    if (this -> na_addrs[i])
      delete this -> na_addrs[i];		// delete old
    this -> na_addrs[i] = rhs.na_addrs[i];	// move new
    rhs.na_addrs[i] = NULL;
  }
  rhs.reset();	// empty derived class parts
  return *this; 
}

TSAPaddr& TSAPaddr::copy () {
  TSAPaddr *t = new TSAPaddr;
  t -> ta_selector = this -> ta_selector.copy();
  t -> na_selector = this -> na_selector.copy();
  t -> na_naddr    = this -> na_naddr;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    t -> na_addrs[i] = new NETaddr;
    *(t -> na_addrs[i]) = this -> na_addrs[i] -> copy();	// move copy !!
  }
  return *t;
}

TSAPaddr& TSAPaddr::operator= (TSAPaddr& rhs) {
  this -> na_selector = rhs.na_selector;	/* !WARNING move ! */
  *this = (NSAPaddr&)rhs;	/* copy NSAP part - !WARNING move! */
  return *this;
}

boolean TSAPaddr::operator== (TSAPaddr& rhs) {
  if ((this -> na_selector != rhs.na_selector) ||
      (this -> ta_selector != rhs.ta_selector )) {
    return false;
  }

  /* if any NETaddr matches, they are equivalent */
  if (this -> na_naddr > 0 && rhs.na_naddr > 0) {
    for (sint16 i=0; i < this -> na_naddr; i++) {
      for (sint16 j=0; j < rhs.na_naddr; j++) {
        if (this -> na_addrs[i] && rhs.na_addrs[j]) {
          if (*this -> na_addrs[i] == *this -> na_addrs[j]) {
            return true;	// selector and at least one na_addrs[] match
          }
        }
      }
    }
  }
  else {
    return true;	// no na_addrs[] exist, but selectors match
  }

  return false;
}

void TSAPaddr::ask (Istream& is) {
  is >> query_string;	// input formatted string
  PSAPaddr ptmp(query_string);
  *this = ptmp;		// !WARNING move!
}

void TSAPaddr::print (Ostream& os) {
  os << this -> ta_selector << "/" << this -> na_selector << "/NS+"; 
  for (sint16 i=0; i < this -> na_naddr; i++) {
    if (this -> na_addrs[i]) {
      os << this -> na_addrs[i]->afi 
         << "+" << this -> na_addrs[i]->idi 
         << "+" << this -> na_addrs[i]->dsp;
    }
    if (i < this -> na_naddr - 1)
      os << "|";
  }
}

/*  */

/************** SESSION SERVICE ACCESS POINT *************/


// empty out NSAPaddr
void SSAPaddr::reset() {
  if (this->sa_selector.length() > 0) {
    this->sa_selector.reset();
  }
  if (this->ta_selector.length() > 0) {
    this->ta_selector.reset();
  }
  if (this->na_selector.length() > 0) {
    this->na_selector.reset();
  }
  if (this->na_naddr > 0) {
    for (sint16 i=0; i<NTADDR; i++) {
      if (this->na_addrs[i]) {
        delete this -> na_addrs[i];
        this -> na_addrs[i] = NULL;
      }
    }
  }
}

SSAPaddr::SSAPaddr (char *str) {
  PSAPaddr tmp(str);
  *this = tmp;	// !WARNING move!
}

SSAPaddr& SSAPaddr::operator= (NSAPaddr& rhs) {
  this -> na_selector = rhs.na_selector;	/* !WARNING move ! */

  this -> na_naddr    = rhs.na_naddr;
  rhs.na_naddr = 0;

  rhs.na_naddr = 0;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    if (this -> na_addrs[i])
      delete this -> na_addrs[i];		// delete old
    this -> na_addrs[i] = rhs.na_addrs[i];	// move new
    rhs.na_addrs[i] = NULL;
  }
  rhs.reset();	// make derived class part empty
  return *this;
}

SSAPaddr& SSAPaddr::copy () {
  SSAPaddr *s = new SSAPaddr;
  s -> sa_selector = this -> sa_selector.copy();
  s -> ta_selector = this -> ta_selector.copy();
  s -> na_selector = this -> na_selector.copy();
  s -> na_naddr    = this -> na_naddr;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    s -> na_addrs[i] = new NETaddr;
    *(s -> na_addrs[i]) = this -> na_addrs[i] -> copy();	// move copy !!
  }
  return *s;
}

SSAPaddr& SSAPaddr::operator= (TSAPaddr& rhs) {
  this -> ta_selector = rhs.ta_selector;	/* !WARNING move ! */
  *this = (NSAPaddr&)rhs;	/* copy NSAP part - !WARNING move ! */
  return *this;
}

SSAPaddr& SSAPaddr::operator= (SSAPaddr& rhs) {
  this -> sa_selector = rhs.sa_selector;	/* !WARNING move ! */
  *this = (TSAPaddr&)rhs;	/* copy TSAP part - !WARNING move ! */
  return *this;
}

boolean SSAPaddr::operator== (SSAPaddr& rhs) {
  if ((this -> na_selector != rhs.na_selector) ||
      (this -> ta_selector != rhs.ta_selector) ||
      (this -> sa_selector != rhs.sa_selector)) {
    return false;
  }

  /* if any NETaddr matches, they are equivalent */
  if (this -> na_naddr > 0 && rhs.na_naddr > 0) {
    for (sint16 i=0; i < this -> na_naddr; i++) {
      for (sint16 j=0; j < rhs.na_naddr; j++) {
        if (this -> na_addrs[i] && rhs.na_addrs[j]) {
          if (*this -> na_addrs[i] == *this -> na_addrs[j]) {
            return true;	// selector and at least one na_addrs[] match
          }
        }
      }
    }
  }
  else {
    return true;	// no na_addrs[] exist, but selectors match
  }

  return false;
}

void SSAPaddr::ask (Istream& is) {
  is >> query_string;	// input formatted string
  PSAPaddr ptmp(query_string);
  *this = ptmp;		// !WARNING move!
}

void SSAPaddr::print (Ostream& os) {
  os << this -> sa_selector << "/" << this -> ta_selector
     << "/" << this -> na_selector << "/NS+";
  for (sint16 i=0; i < this -> na_naddr; i++) {
    if (this -> na_addrs[i]) {
      os << this -> na_addrs[i]->afi 
         << "+" << this -> na_addrs[i]->idi 
         << "+" << this -> na_addrs[i]->dsp;
    }
    if (i < this -> na_naddr - 1)
      os << "|";
  }
}

/*  */

/************* PRESENTATION SERVICE ACCESS POINT *************/


// empty out NSAPaddr
void PSAPaddr::reset() {
  if (this->pa_selector.length() > 0) {
    this->pa_selector.reset();
  }
  if (this->sa_selector.length() > 0) {
    this->sa_selector.reset();
  }
  if (this->ta_selector.length() > 0) {
    this->ta_selector.reset();
  }
  if (this->na_selector.length() > 0) {
    this->na_selector.reset();
  }
  if (this->na_naddr > 0) {
    for (sint16 i=0; i<NTADDR; i++) {
      if (this->na_addrs[i]) {
        delete this -> na_addrs[i];
        this -> na_addrs[i] = NULL;
      }
    }
  }
}

PSAPaddr& PSAPaddr::operator= (NSAPaddr& rhs) {
  this -> na_selector = rhs.na_selector;	/* !WARNING move ! */

  this -> na_naddr    = rhs.na_naddr;
  rhs.na_naddr = 0;

  rhs.na_naddr = 0;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    if (this -> na_addrs[i])
      delete this -> na_addrs[i];		// delete old
    this -> na_addrs[i] = rhs.na_addrs[i];	// move new
    rhs.na_addrs[i] = NULL;
  }
  rhs.reset();
  return *this;
}

PSAPaddr& PSAPaddr::copy () {
  PSAPaddr *p = new PSAPaddr;
  p -> pa_selector = this -> pa_selector.copy();
  p -> sa_selector = this -> sa_selector.copy();
  p -> ta_selector = this -> ta_selector.copy();
  p -> na_selector = this -> na_selector.copy();
  p -> na_naddr    = this -> na_naddr;
  for (sint16 i=0; i<this -> na_naddr; i++) {
    p -> na_addrs[i] = new NETaddr;
    *(p -> na_addrs[i]) = this -> na_addrs[i] -> copy();	// move copy !!
  }
  return *p;
}


PSAPaddr& PSAPaddr::operator= (TSAPaddr& rhs) {
  this -> ta_selector = rhs.ta_selector;	/* !WARNING move ! */
  *this = (NSAPaddr&)rhs;	/* copy NSAP part - !WARNING move ! */
  return *this;
}

PSAPaddr& PSAPaddr::operator= (SSAPaddr& rhs) {
  this -> sa_selector = rhs.sa_selector;	/* !WARNING move ! */
  *this = (TSAPaddr&)rhs;	/* copy TSAP part - !WARNING move ! */
  return *this;
}

PSAPaddr& PSAPaddr::operator= (PSAPaddr& rhs) {
  this -> pa_selector = rhs.pa_selector;	/* !WARNING move ! */
  *this = (SSAPaddr&)rhs;	/* copy SSAP part - !WARNING move ! */
  return *this;
}

boolean PSAPaddr::operator== (PSAPaddr& rhs) {
  if ((this -> na_selector != rhs.na_selector) ||
      (this -> ta_selector != rhs.ta_selector) ||
      (this -> sa_selector != rhs.sa_selector) ||
      (this -> pa_selector != rhs.pa_selector)) {
    return false;
  }

  /* if any NETaddr matches, they are equivalent */
  if (this -> na_naddr > 0 && rhs.na_naddr > 0) {
    for (sint16 i=0; i < this -> na_naddr; i++) {
      for (sint16 j=0; j < rhs.na_naddr; j++) {
        if (this -> na_addrs[i] && rhs.na_addrs[j]) {
          if (*this -> na_addrs[i] == *this -> na_addrs[j]) {
            return true;	// selector and at least one na_addrs[] match
          }
        }
      }
    }
  }
  else {
    return true;	// no na_addrs[] exist, but selectors match
  }

  return false;
}

void PSAPaddr::ask (Istream& is) {
  is >> query_string;	// input formatted string
  PSAPaddr ptmp(query_string);
  *this = ptmp;		// !WARNING move!
}

void PSAPaddr::print (Ostream& os) {
  os << this -> pa_selector << "/" << this -> sa_selector
     << "/" << this -> ta_selector << "/" << this -> na_selector << "/NS+";
  for (sint16 i=0; i < this -> na_naddr; i++) {
    if (this -> na_addrs[i]) {
      os << this -> na_addrs[i]->afi 
         << "+" << this -> na_addrs[i]->idi 
         << "+" << this -> na_addrs[i]->dsp;
    }
    if (i < this -> na_naddr - 1)
      os << "|NS+";
  }
}

/*  */

static void pushsels (char **psel, char **ssel, char **tsel, char **nsel,
			char **next)
{
  *psel = *ssel;  *ssel = *tsel; *tsel = *nsel; *nsel = *next;
}
		 

/*********************************************************************
* NAME
*	PSAPaddr::PSAPaddr (char *str)
*
* PURPOSE
*	Construct a PSAPaddr object from an ascii string,
* --      [1] 101H/pres/01H/01H/NS+0+0+0
* --      [1] 101H/pres/01H/01H/NS+54+00728722+102@tel3.tel.vtt.fi
*
* USAGE
* BUGS
* MODIFICATIONS
*****************************************************************
*/

PSAPaddr::PSAPaddr (char *str)
{
  sint16 n_netaddrs = 0;
  sint16 parse_errors = 0, parse_flag1 = 0;
  
  char	*fp=NULL, *ep=NULL;
  char	*psel=NULL, *ssel=NULL, *tsel=NULL, *nsel=NULL;
  char	*pafi=NULL, *pidi=NULL, *pdsp=NULL;

  
  /* PARSING OF SELECTORS */
  for (fp = ep = str; (!(psel&&ssel&&tsel&&nsel) && *ep != '\0'); ep++) {
    if (*ep == '/') {
      if (::strncmp (ep, "/NS+", 3) == 0) { // premature net addresses
          parse_flag1 = -1;
          *ep++ = '\0';
          pushsels(&psel, &ssel, &tsel, &nsel, &fp);
          fp = ep;
          break;
      }

      if (nsel != NULL) {	// push
	if (tsel != NULL) {	// push
	  if (ssel != NULL) {	// push
	    if (psel != NULL) {	// push
              *ep++ = '\0';
              fp = ep;
              break;		// out of for loop
	    }
            else {
              pushsels(&psel, &ssel, &tsel, &nsel, &fp);
              *ep++ = '\0';
              fp = ep;
	    }
          }
          else {
            pushsels(&psel, &ssel, &tsel, &nsel, &fp);
            *ep++ = '\0';
            fp = ep;
          }
        }
        else {
          pushsels(&psel, &ssel, &tsel, &nsel, &fp);
          *ep++ = '\0';
          fp = ep;
        }
      }
      else {
        pushsels(&psel, &ssel, &tsel, &nsel, &fp);
        *ep++ = '\0';
        fp = ep;
      }
    }
  }
  if (*ep == '\0' && !(psel&&ssel&&tsel&&nsel) && !parse_flag1) {
    pushsels(&psel, &ssel, &tsel, &nsel, &fp);
  }


  /* PARSING OF PHYSICAL NETWORK ADDRESSES */
  if (ep > &str[::strlen(str)]) {
    if (fp) {
      if (*fp != NULL) {
        while (*ep != NULL && parse_errors == 0) {
	  if (::strncmp (fp, "NS+", 3) != 0) {	// no match
            //cerr << form("error: No Network address at : %s\n", fp);
	    cerr << "error: No Network address at : " << fp << "\n";
          }
          else {	// parse network addresses
            // advance past NS+
            fp = fp + 3; ep = fp;
            n_netaddrs = 0;

	    while (*ep != NULL && parse_errors == 0) {
              switch (*ep) {
              case '+': 
                *ep++ = '\0';
                if (pafi == NULL) {pafi = fp; fp = ep;}
                else if (pidi == NULL) {pidi = fp; fp = ep;}
                else {
                  //cerr << form ("Bad Network address at : %s", fp);
		  cerr << "Bad Network address at : " << fp << "\n";
                  pafi = pidi = pdsp = NULL;
                  parse_errors++;
                }
                break;

              case '|':
                if (pafi!=NULL && pidi!=NULL && pdsp==NULL) {
                  *ep++ = '\0'; // move past '|'
                  pdsp = fp;
                  fp = ep;	// net net addr (NS+)
                  this->na_addrs [n_netaddrs++] = new NETaddr(pafi, pidi, pdsp);
                  this -> na_naddr = n_netaddrs;
                  pafi = pidi = pdsp = NULL;
	          if (::strncmp (fp, "NS+", 3) == 0) {	// match
                    fp = fp + 3;
                    ep = fp;
                  } else {
                    //cerr << form("error: Bad Netwk address format at %s\n", fp);
		    cerr << "error: Bad Netwk address format at " << fp << "\n";
                    pafi = pidi = pdsp = NULL;
                    parse_errors++;
                  }
                } else {
                  //cerr << form("error: Missing afi or idi at %s\n", fp);
		  cerr << "error: Missing afi or idi at " << fp << "\n";
                  pafi = pidi = pdsp = NULL;
                  parse_errors++;
                }
                break;

              default:
                ep++;
                break;
              }
	    }
            if (parse_errors == 0) {
              pdsp = fp;
              if (pafi && pidi && pdsp && n_netaddrs < NTADDR) {
                this->na_addrs [n_netaddrs++] = new NETaddr (pafi, pidi, pdsp);
                this -> na_naddr = n_netaddrs;
                pafi = pidi = pdsp = NULL;
              }
            }
          }
        }
      }
    }
  }

  if (psel != NULL) if (*psel != NULL) this -> pa_selector = *(new Bytes(psel));
  if (ssel != NULL) if (*ssel != NULL) this -> sa_selector = *(new Bytes(ssel));
  if (tsel != NULL) if (*tsel != NULL) this -> ta_selector = *(new Bytes(tsel));
  if (nsel != NULL) if (*nsel != NULL) this -> na_selector = *(new Bytes(nsel));

}

