/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.voidgrp.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:35
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILE
*	VoidGrp.hxx
**********************************************************************/


typedef void* VGE;	//VoidGroup element, must be a pointer
typedef void* VGP;	//stores the current position in a VoidGroup,
                        //the actual type depends on derived class.

/*********************************************************************
Class VoidGroup is a base class for void* containers.
VoidFifo is a First-In-First-Out queue of void pointers,
VoidLifo is a Last-In-First-Out stack of void pointers.

The extracted elements can be typecasted after get() if you know exactly
the type of the element.  Use class Group when the elements are Runners. 

The basic services provided by VoidGroups are put() and get().
Iteration through all the elements in a VoidGroup:
.nf

  VoidGroup* q = ...
  VGP tmp; 
  for(void* voidp = g->first(tmp); !q->over(tmp); voidp = q->next(tmp)) {
    //... use voidp ...
  }

.fi

.SH BUGS
Elements may be instances of any type: no type-checking!
Using typed Groups (such as OTSO Group and application-specific queues)
is much more safe.

Proper print() cannot be implemented 
because the elements are not necessarily Objects.
reset() and isEmpty() could be implemented with slightly different meaning
than in Group.  However, not implemented.  

get() from an empty VoidGroup returns &dummyRunner !?
***********************************************************************/

class VoidGroup : public NamedObj {
public:

/***************
.SH VoidGroup services
***************/
  virtual VoidGroup&  put(const VGE r) = 0;
                                 //Add one void* into the VoidGroup.
				 //Return *this.
  virtual VGE   get() = 0;	 //Get and return one void* from VoidGroup,
                                 //return &dummyRunner if empty VoidGroup.
                                 //The element is removed from the VoidGroup.
  VoidGroup&	  put(const VGE o1    , const VGE o2,
		      const VGE o3 = 0, const VGE o4 = 0,
		      const VGE o5 = 0, const VGE o6 = 0);
                                 //Add 2 to 6 void pointers to the VoidGroup,
                                 //return *this.
  VGE		  head()	 {return first(dummyVGP);}
                                 //Without removing, return the VGE
                                 //that get() would return.
  virtual void	  reset() = 0;	 //Make group empty.
  sint32	  size() const;	 //Number of elements in this.

/**************
.SH Iteration
**************/
  virtual VGE	  first(VGP&) = 0;//
  virtual VGE	  next(VGP&) = 0; //
  virtual boolean over(const VGP);//

/**************
.SH Miscellaneous
**************/
  virtual void	  print(Ostream& os);
  virtual String  className() const;
  static VGP 	  dummyVGP;
protected:
                  VoidGroup();
  sint32	  size_;	 //Number of elements in this.

};


/* 
 Iterates through Q once beginning from first.
 At each step, voidp points to the member.
*/
#define FOR_EACH_voidp_IN(Q) \
  VGP ddLvp; for(VGE voidp = (Q).first(ddLvp);\
	      !(Q).over(ddLvp); voidp = (Q).next(ddLvp))


/********************************************************************
A VoidLink attaches Group elements.
Each Group has its own list of VoidLinks,
so that any Object may belong to several independent Groups.
The elements do not contain any pointers to other elements.

.SH BUGS
**********************************************************************/

class VoidLink {
public:
  void*		element;	//
  VoidLink*	next;		//
  VoidLink(const void* e, VoidLink* n): element(e), next(n) {}
};


/**********************************************************************
A "first in, first out" queue,
a container of VoidGroup elements void*.
**********************************************************************/

class VoidFifo : public VoidGroup {
protected:
  VoidLink* 		fst;
  VoidLink*		last;
public:
  virtual VoidGroup& 	put(const VGE);
  virtual VGE 		get();		     
  virtual VGE		first(VGP&);
  virtual VGE		next(VGP&);
  virtual void		reset();	     
  virtual String	className() const;
                        VoidFifo();
                       ~VoidFifo();
};



/********************************************************************
A "last in, first out" grouping (container class) of VoidGroup elements VGE.
.SH BUGS
**********************************************************************/

class VoidLifo : public VoidFifo        //implementation reuse only,
                                        //VoidLifo provides VoidGroup service
{
public:
  String 	className() const;
  VoidGroup& 	put(const VGE);
                VoidLifo();		//
};

