/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.type.hxx
 * Vers: 5.3    Time: 92/09/01, 09:52:35
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILENAME
*	type.hxx
*
* PURPOSE
*	Macro "templates" for defining the OTSO interface for types.
*	Classes used in the OTSO command interpreter.
*
*	The usage of these macros is documented in OTSO User's Guide
*	and only in OTSO User's Guide!
*
* BUGS
* MODIFICATIONS
**********************************************************************/

extern String* otsoInitializationErrors;  //append error messages to this
                                          //when constructing global objects   

typedef Ostream& (*OtsoPrintFnPointer) (Ostream&, ...);	//... == TYPE&
typedef Istream& (*OtsoAskFnPointer) (Istream&, ...);	//... == TYPE&
typedef ODump& (*OtsoEncodeFnPointer) (ODump&, ...);	//... == TYPE&
typedef IDump& (*OtsoDecodeFnPointer) (IDump&, ...);	//... == TYPE&
typedef NewMsg* (*OtsoNewMsgFnPointer) ();

extern Type* otsoType_void;
extern Type* otsoType_async;

/**********************************************************************
The declaration of OTSO interface for a TYPE:
call one of the following macros in a header file.
**********************************************************************/

/***********************************************************************
Usage documented in OTSO User's Guide.
***********************************************************************/

#define DECLARE_OTSO_INTERNALS_FOR(TYPE)				\
  extern Type* concat(otsoType_,TYPE);					\
  inline Type** otsoTypeOf(TYPE *) {return & concat(otsoType_,TYPE);}	\
  extern Object* objectify(TYPE& t);	 				

/**********************************************************************
Usage documented in OTSO User's Guide.
**********************************************************************/

#define DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(CLASS)			\
   DECLARE_OTSO_INTERNALS_FOR(CLASS)					


/**********************************************************************
Usage documented in OTSO User's Guide.
**********************************************************************/

#define DECLARE_OTSO_PAED_FOR(TYPE)					\
  DECLARE_OTSO_INTERNALS_FOR(TYPE)					\
  extern ClassMember* otsoInterfaceFunction(TYPE*);			\
  extern Ostream& operator<<(Ostream& os, TYPE & t); 			\
  extern Istream& operator>>(Istream& is, TYPE & t); 			\
  extern ODump& operator<<(ODump& od, TYPE & t);			\
  extern IDump& operator>>(IDump& id, TYPE & t);			

/**********************************************************************
Used by other macro "templates".
Must be used when type name must be given in two parts (prefix and suffix).
Otherwise the same as DECLARE_OTSO_PAED_FOR(TYPE).
**********************************************************************/

#define DECLARE_OTSO_PAED_FOR2(T1,T2)					\
  extern Type* concat3(otsoType_,T1,T2);				\
  inline Type** otsoTypeOf(concat(T1,T2) *) 				\
    {return & concat3(otsoType_,T1,T2);}				\
  extern Object* objectify(concat(T1,T2)& t);				\
  extern ClassMember* otsoInterfaceFunction(concat(T1,T2)*);		\
  extern Ostream& operator<<(Ostream& os, concat(T1,T2) & t);		\
  extern Istream& operator>>(Istream& is, concat(T1,T2) & t);		\
  extern ODump& operator<<(ODump& od, concat(T1,T2) & t);		\
  extern IDump& operator>>(IDump& id, concat(T1,T2) & t);		


/**********************************************************************
The implementation of OTSO interface for a TYPE:
Call one of the following macros in a code file.
**********************************************************************/

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define IMPLEMENT_OTSO_INTERNALS_FOR(TYPE,PF,AF,EF,DF)			\
  Object* objectify(TYPE& t) 						\
        {return new Objectifier(&t, concat(otsoType_,TYPE));}		\
  static Ostream& (*concat(TYPE,OtsoPrintFn)) (Ostream&,TYPE&) = PF;	\
  static Istream& (*concat(TYPE,OtsoAskFn))   (Istream&,TYPE&) = AF;	\
  static ODump&   (*concat(TYPE,OtsoEncodeFn))(ODump&,  TYPE&) = EF;	\
  static IDump&   (*concat(TYPE,OtsoDecodeFn))(IDump&,  TYPE&) = DF;	\
  Type* concat(otsoType_,TYPE) = new HardType (String(stringize(TYPE))	\
	,(OtsoPrintFnPointer) concat(TYPE,OtsoPrintFn)			\
	,(OtsoAskFnPointer) concat(TYPE,OtsoAskFn)			\
	,(OtsoEncodeFnPointer) concat(TYPE,OtsoEncodeFn)		\
	,(OtsoDecodeFnPointer) concat(TYPE,OtsoDecodeFn)		\
	,0								\
					       );			

/**********************************************************************
Used by other macro "templates".
Use this when type name must be given in two parts (prefix and suffix).
Otherwise the same as IMPLEMENT_OTSO_INTERNALS_FOR(TYPE,PF,AF,EF,DF).
**********************************************************************/

#define IMPLEMENT_OTSO_INTERNALS_FOR2(T1,T2,PF,AF,EF,DF)		\
  Object* objectify(concat(T1,T2)& t) 					\
        {return new Objectifier(&t, concat3(otsoType_,T1,T2));}		\
  static Ostream& (*concat3(T1,T2,OtsoPrintFn)) (Ostream&,concat(T1,T2)&) = PF;	\
  static Istream& (*concat3(T1,T2,OtsoAskFn))   (Istream&,concat(T1,T2)&) = AF;	\
  static ODump&   (*concat3(T1,T2,OtsoEncodeFn))(ODump&,  concat(T1,T2)&) = EF;	\
  static IDump&   (*concat3(T1,T2,OtsoDecodeFn))(IDump&,  concat(T1,T2)&) = DF;	\
  Type* concat3(otsoType_,T1,T2) = new HardType (			\
         String(stringize(T1)) + stringize(T2)			 	\
	,(OtsoPrintFnPointer) concat3(T1,T2,OtsoPrintFn)		\
	,(OtsoAskFnPointer) concat3(T1,T2,OtsoAskFn)			\
	,(OtsoEncodeFnPointer) concat3(T1,T2,OtsoEncodeFn)		\
	,(OtsoDecodeFnPointer) concat3(T1,T2,OtsoDecodeFn)		\
	,0								\
					       );			


/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(CLASS,MEMBERLIST)		\
  IMPLEMENT_OTSO_PAED_FOR(CLASS,0,0,0,0,MEMBERLIST)			


/**********************************************************************
TYPE must be a class that defines DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS;
Functions pointers: 0, or otsoPrintFn etc. for OTSO Objects.
This is probably not used by application programmers. (?)
Maybe not needed at all!
**********************************************************************/

#define IMPLEMENT_OTSO_PAED_FOR(TYPE,PF,AF,EF,DF,MEMBERLIST)  	\
  static Ostream& (*concat(TYPE,OtsoPrintFn)) (Ostream&,TYPE&) = PF;	\
  static Istream& (*concat(TYPE,OtsoAskFn))   (Istream&,TYPE&) = AF;	\
  static ODump&   (*concat(TYPE,OtsoEncodeFn))(ODump&,  TYPE&) = EF;	\
  static IDump&   (*concat(TYPE,OtsoDecodeFn))(IDump&,  TYPE&) = DF;	\
  Type* concat(otsoType_,TYPE) = new HardType (String(stringize(TYPE)) 	\
	,(OtsoPrintFnPointer) concat(TYPE,OtsoPrintFn)			\
	,(OtsoAskFnPointer) concat(TYPE,OtsoAskFn)			\
	,(OtsoEncodeFnPointer) concat(TYPE,OtsoEncodeFn)		\
	,(OtsoDecodeFnPointer) concat(TYPE,OtsoDecodeFn)		\
	,otsoInterfaceFunction((TYPE*)10000)				\
				   );					\
  Ostream& operator<<(Ostream& os, TYPE & t) 				\
        {concat(otsoType_,TYPE)->print(os, &t); return os;}		\
  Istream& operator>>(Istream& is, TYPE & t) 				\
        {concat(otsoType_,TYPE)->ask(is, &t); return is;}		\
  ODump& operator<<(ODump& od, TYPE & t)				\
        {concat(otsoType_,TYPE)->encode(od, &t); return od;}		\
  IDump& operator>>(IDump& id, TYPE & t)				\
        {concat(otsoType_,TYPE)->decode(id, &t); return id;}		\
	                                                                \
  void* TYPE::otsoMostDerivedPointer() {return this;}			\
  ClassMember* otsoInterfaceFunction(TYPE* otsoP) 			\
        {return (MEMBERLIST).first();}					\
  Type& TYPE ::otsoType()						\
        {return * concat(otsoType_,TYPE);}				\
  Object* objectify(TYPE& t) 						\
        {return new Objectifier(&t, concat(otsoType_,TYPE));}		

extern ClassMember* otsoInterfaceFunction(void*);	//returns 0

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(CLASS,MEMBERLIST)		\
  Type* concat(otsoType_,CLASS) = new HardType (String(stringize(CLASS)) \
	,(OtsoPrintFnPointer)	otsoPrintObject				\
	,(OtsoAskFnPointer)	otsoAskObject				\
	,(OtsoEncodeFnPointer)	otsoEncodeObject			\
	,(OtsoDecodeFnPointer)	otsoDecodeObject			\
	,otsoInterfaceFunction((CLASS*)10000)				\
				   );					\
  void* CLASS::otsoMostDerivedPointer() {return this;}			\
  ClassMember* otsoInterfaceFunction(CLASS* otsoP) 			\
        {return (MEMBERLIST).first();}					\
  Type& CLASS ::otsoType()						\
        {return * concat(otsoType_,CLASS);}				\
  Object* objectify(CLASS& t) 						\
        {return new Objectifier(&t, concat(otsoType_,CLASS));}		


/**********************************************************************
If TYPE is used as a return type, these must be called:
**********************************************************************/

#define DECLARE_OTSO_RETURN_TYPE(TYPE)					\
  extern TYPE concat3(otso,TYPE,Dummy); 				\
  inline TYPE& otsoDummyOf(TYPE *) {return concat3(otso,TYPE,Dummy);}	

#define IMPLEMENT_OTSO_RETURN_TYPE(TYPE)				\
  TYPE concat3(otso,TYPE,Dummy);					

/**********************************************************************
The implementation of OTSO interface for integral types.
This macro is called by OTSO, probably not called by application programs.
**********************************************************************/

extern boolean otsoReadLong(sint32&);
extern boolean otsoReadPositiveLong(sint32&);

#define IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(TYPE,SIZEOF_TYPE,PA_TYPE)	\
  Object* objectify(TYPE& t) 						\
        {return new Objectifier(&t, concat(otsoType_,TYPE));}		\
  Ostream& operator<<(Ostream& os, TYPE &  t)		\
        {os.ostream_withassign::operator<<((PA_TYPE)t);			\
	 return os;}							\
  Istream& operator>>(Istream& is, TYPE & t) 				\
	{								\
         sint32 tmp; 							\
	 while (!otsoReadLong(tmp))					\
	   OTSO_WARNING("Invalid input, try again (" << stringize(TYPE) << ")");\
	 t = (TYPE)tmp;							\
	 return is;}							\
  ODump& operator<<(ODump& od, TYPE &  t)			\
        {		      od.put((unsigned char) t);		\
	 if (SIZEOF_TYPE > 1) 						\
	   od.put((unsigned char) ((t&0xff00)>>8));			\
	 if (SIZEOF_TYPE > 2) 						\
	   od.put((unsigned char) ((t&0xff0000)>>16));			\
	 if (SIZEOF_TYPE > 3) 						\
	   od.put((unsigned char) ((t&0xff000000)>>24));		\
	 return od;}							\
  IDump& operator>>(IDump& id, TYPE & t)				\
        {sint32 tmp = 0;						\
	 unsigned char c;						\
	                      {id.get(c); tmp |= c;      }		\
	 if (SIZEOF_TYPE > 1) {id.get(c); tmp |= (c*0x100);}		\
	 if (SIZEOF_TYPE > 2) {id.get(c); tmp |= (c*0x10000);}		\
	 if (SIZEOF_TYPE > 3) {id.get(c); tmp |= (c*0x1000000);}	\
	 if (SIZEOF_TYPE ==2) {if (tmp & 0x8000) tmp |= 0xffff0000; }	\
	 t = (TYPE)tmp;							\
	 return id;}							\
  Istream& concat(otsoAsk,TYPE) (Istream& is, TYPE * t)			\
        {is >> *t; return is;}						\
  Ostream& concat(otsoPrint,TYPE) (Ostream& os, TYPE * t)		\
        {os << *t; return os;}						\
  ODump& concat(otsoEncode,TYPE) (ODump& od, TYPE * t)			\
        {od << *t; return od;}						\
  IDump& concat(otsoDecode,TYPE) (IDump& id, TYPE * t)			\
        {id >> *t; return id;}						\
  Type* concat(otsoType_,TYPE) = new HardType(				\
	 String(stringize(TYPE))					\
         ,(OtsoPrintFnPointer) concat(otsoPrint,TYPE)			\
         ,(OtsoAskFnPointer) concat(otsoAsk,TYPE)			\
	 ,(OtsoEncodeFnPointer) concat(otsoEncode,TYPE)			\
	 ,(OtsoDecodeFnPointer) concat(otsoDecode,TYPE)			\
	);								\
  TYPE concat3(otso,TYPE,Dummy);					

/**********************************************************************
double
**********************************************************************/

#define IMPLEMENT_OTSO_PAED_FOR_DOUBLE(TYPE,SIZEOF_TYPE)		\
  Object* objectify(TYPE& t) 						\
        {return new Objectifier(&t, concat(otsoType_,TYPE));}		\
  Ostream& operator<<(Ostream& os, TYPE &  t)				\
        {os.ostream_withassign::operator<<(t);				\
	 return os;}							\
  Istream& operator>>(Istream& is, TYPE & t) 				\
	{is.istream_withassign::operator>>(t);				\
	 return is;}							\
  ODump& operator<<(ODump& od, TYPE &  t)				\
        {OTSO_ERROR(stringize(TYPE) "encoding not implemented");	\
	 return od;}							\
  IDump& operator>>(IDump& id, TYPE & t)				\
        {OTSO_ERROR(stringize(TYPE) "decoding not implemented");	\
	 return id;}							\
  Istream& concat(otsoAsk,TYPE) (Istream& is, TYPE * t)			\
        {is >> *t; return is;}						\
  Ostream& concat(otsoPrint,TYPE) (Ostream& os, TYPE * t)		\
        {os << *t; return os;}						\
  ODump& concat(otsoEncode,TYPE) (ODump& od, TYPE * t)			\
        {od << *t; return od;}						\
  IDump& concat(otsoDecode,TYPE) (IDump& id, TYPE * t)			\
        {id >> *t; return id;}						\
  Type* concat(otsoType_,TYPE) = new HardType(				\
	 String(stringize(TYPE))					\
         ,(OtsoPrintFnPointer) concat(otsoPrint,TYPE)			\
         ,(OtsoAskFnPointer) concat(otsoAsk,TYPE)			\
	 ,(OtsoEncodeFnPointer) concat(otsoEncode,TYPE)			\
	 ,(OtsoDecodeFnPointer) concat(otsoDecode,TYPE)			\
	);								\
  TYPE concat3(otso,TYPE,Dummy);					


/**********************************************************************
The MEMBERLIST argument in IMPLEMENT_OTSO_... macros
should be a comma-separated list of the following macros.

Note that ostoP points to an instance of the containing structure.
**********************************************************************/

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define OTSO_DATA_MEMBER(TYPE,NAME,HELP)				\
  *new DataMember(stringize(NAME),					\
		  otsoTypeOf(&otsoP->NAME),				\
		  (char*)&otsoP-> NAME - (char*)otsoP,			\
		  HELP )


/**********************************************************************
Usage documented in OTSO User's Guide.
No leading or trailing space in CLASS and METHOD arguments!
**********************************************************************/

#define OTSO_METHOD_MEMBER(CLASS,METHOD,HELP)				\
  *new MethodMember(stringize(METHOD),					\
		    concat4(new_,CLASS,_,METHOD),			\
		    (otsoP , HELP) )

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define OTSO_RENAMED_METHOD_MEMBER(CLASS,METHOD,COMMAND_NAME,HELP)	\
  *new MethodMember(COMMAND_NAME,					\
		    concat4(new_,CLASS,_,METHOD),			\
		    (otsoP , HELP) )

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define OTSO_PUBLIC_BASE_CLASS(BASE,HELP)				\
   *new PublicBaseClass(stringize(BASE),				\
			otsoTypeOf((BASE*)0), 				\
			(char*)(BASE *)otsoP - (char*)otsoP,		\
			HELP )

/**********************************************************************
Used in a list of objects defined in the system logical description (*.str).
Used in main() by generated code.
**********************************************************************/

#define OTSO_NAMED_OBJECT(TYPE,NAME,HELP)				\
  *new AbsoluteDataMember(stringize(NAME),				\
			  otsoTypeOf((TYPE*)0),				\
			  (Offset) & NAME,				\
			  HELP )


/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#if COMPILER_BORLANDCPP
WRITE_THIS_MACRO_WITHOUT_SCOPE forTheStupidBorlandCompiler;
#else
#define DECLARE_OTSO_PAED_FOR_ENUM(SCOPE,TYPE)				\
  extern EnumInfo concat3(SCOPE,TYPE,Info) [];				\
  extern Type* concat3(otsoType_,SCOPE,TYPE);				\
  inline Type** otsoTypeOf(SCOPE::TYPE *) 				\
        {return & concat3(otsoType_,SCOPE,TYPE);}			\
  extern SCOPE::TYPE concat4(otso,SCOPE,TYPE,Dummy); 			\
  inline SCOPE::TYPE& otsoDummyOf(SCOPE::TYPE *) 			\
        {return concat4(otso,SCOPE,TYPE,Dummy);}			\
  inline Object* objectify(SCOPE::TYPE& t) 				\
        {return new Objectifier(&t, concat3(otsoType_,SCOPE,TYPE));}	\
  extern Ostream& operator<<(Ostream& os, SCOPE::TYPE & t); 		\
  extern Istream& operator>>(Istream& is, SCOPE::TYPE & t); 		\
  extern ODump& operator<<(ODump& od, SCOPE::TYPE & t);			\
  extern IDump& operator>>(IDump& id, SCOPE::TYPE & t);			

#define IMPLEMENT_OTSO_PAED_FOR_ENUM(SCOPE,TYPE)			\
  Ostream& operator<<(Ostream& os, SCOPE::TYPE & t) 			\
     {concat3(otsoType_,SCOPE,TYPE)->print(os, &t); 			\
      return os;}							\
  Istream& operator>>(Istream& is, SCOPE::TYPE & t) 			\
     {concat3(otsoType_,SCOPE,TYPE)->ask(is, &t); 			\
      return is;} 							\
  ODump& operator<<(ODump& od, SCOPE::TYPE & t)				\
     {sint32 tmp = t; 						\
      od << tmp; 							\
      return od;}							\
  IDump& operator>>(IDump& id, SCOPE::TYPE & t)				\
     {sint32 tmp; 						\
      id >> tmp;		 					\
      t = (SCOPE::TYPE)tmp; 						\
      return id;}							\
  Ostream& concat3(otsoPrint,SCOPE,TYPE) (Ostream& os, SCOPE::TYPE * t)	\
     {return os << *t;}							\
  Istream& concat3(otsoAsk,SCOPE,TYPE) (Istream& is, SCOPE::TYPE * t)	\
     {return is >> *t;}							\
  Type* concat3(otsoType_,SCOPE,TYPE) = new EnumType			\
     (stringize(TYPE) 							\
      ,concat3(SCOPE,TYPE,Info)						\
      ,(OtsoPrintFnPointer) concat3(otsoPrint,SCOPE,TYPE)		\
      ,(OtsoAskFnPointer) concat3(otsoAsk,SCOPE,TYPE)			\
      );								\
  SCOPE::TYPE concat4(otso,SCOPE,TYPE,Dummy);				


#endif

/**********************************************************************
Generic macro "templates" for pointer types 
**********************************************************************/

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define DECLARE_OTSO_MV_POINTER(TYPE)					\
 class concat(TYPE,MV) {						\
  friend Ostream& operator<<(Ostream& os, concat(TYPE,MV)& p);		\
  friend Istream& operator>>(Istream& is, concat(TYPE,MV)& p);		\
  friend ODump& operator<<(ODump& od, concat(TYPE,MV)& p);		\
  friend IDump& operator>>(IDump& id, concat(TYPE,MV)& p);		\
                                                                        \
  TYPE* p;								\
 public:								\
  TYPE* operator->();							\
  concat(TYPE,MV)& operator=(concat(TYPE,MV)& r)			\
    { p = r.p; r.p = 0;	return *this; }					\
  operator TYPE*()							\
    { return p;}							\
  concat(TYPE,MV)(TYPE* i = 0);						\
  concat(TYPE,MV)(concat(TYPE,MV)& i)					\
    { p = i.p; i.p = 0;}						\
 };									\
 DECLARE_OTSO_PAED_FOR2(TYPE,MV);					

#define SRC_IMPLEMENT_OTSO_MV_POINTER(TYPE)				\
  TYPE* concat(TYPE,MV)::operator->() 					\
    { if (!p)								\
	OTSO_ERROR("Referencing through NULL " stringize(TYPE) "MV pointer"); \
      return p;								\
    }									\
  Ostream& operator<<(Ostream& os, concat(TYPE,MV)& p) {		\
    if (p.p)								\
      os << "->" << *p.p;						\
    return os;								\
    }									\
  Istream& operator>>(Istream& is, concat(TYPE,MV)& p) {		\
    TYPE i;								\
    is >> i;								\
    p.p = new TYPE(i);							\
    return is;								\
  }									\
  ODump& operator<<(ODump& od, concat(TYPE,MV)& p) {			\
    if (p.p) {								\
      od << *p.p;							\
      delete (TYPE*)p.p;						\
    }									\
    return od;								\
  }									\
  IDump& operator>>(IDump& id, concat(TYPE,MV)& p) {			\
    TYPE i;								\
    id >> i;								\
    p.p = new TYPE(i);							\
    return id;								\
  }									\
  IMPLEMENT_OTSO_INTERNALS_FOR2(TYPE,MV,operator<<,operator>>,operator<<,operator>>);

#if DEBUGGING_FREE_STORE_MEMORY
#define IMPLEMENT_OTSO_MV_POINTER(TYPE)					\
  SRC_IMPLEMENT_OTSO_MV_POINTER(TYPE)					\
  concat(TYPE,MV) :: concat(TYPE,MV)(TYPE* i): p(i)			\
    { if (i && !isOtsoFreeStorePointer(i))				\
	OTSO_WARNING(stringize(TYPE) "MV should be constructed from free store pointer");	\
    }									

#else  
#define IMPLEMENT_OTSO_MV_POINTER(TYPE)					\
  SRC_IMPLEMENT_OTSO_MV_POINTER(TYPE)					\
  concat(TYPE,MV) :: concat(TYPE,MV)(TYPE* i): p(i)	{}		

#endif

/**********************************************************************
Usage documented in OTSO User's Guide
**********************************************************************/

#define DECLARE_OTSO_RCP_POINTER(TYPE)					\
 class concat(TYPE,RCP) {						\
  friend Ostream& operator<<(Ostream& os, concat(TYPE,RCP)& p);		\
  friend Istream& operator>>(Istream& is, concat(TYPE,RCP)& p);		\
  friend ODump& operator<<(ODump& od, concat(TYPE,RCP)& p);		\
  friend IDump& operator>>(IDump& id, concat(TYPE,RCP)& p);		\
  friend void otsoOutEncode(ODump& od, concat(TYPE,RCP)* p);		\
  friend void otsoOutDecode(IDump& id, concat(TYPE,RCP)* p);		\
                                                                        \
  TYPE* p;								\
  TYPE  inst;								\
 public:								\
  TYPE* operator->()							\
    { if (!p)								\
	OTSO_ERROR("Referencing through NULL " stringize(TYPE) "RCP pointer");\
      return p;								\
    }									\
  concat(TYPE,RCP)& operator=(concat(TYPE,RCP)& r)			\
    { p = r.p; 	return *this; }					\
  operator TYPE*()							\
    { return p;}							\
  concat(TYPE,RCP)(TYPE* i = 0): p(i)	{}				\
  concat(TYPE,RCP)(concat(TYPE,RCP)& i): p(i.p), inst(i.inst) 		\
    { }									\
 };									\
 DECLARE_OTSO_PAED_FOR2(TYPE,RCP);					\
 extern void otsoOutEncode(ODump&, concat(sint32,RCP));			\
 extern void otsoOutDecode(IDump&, concat(sint32,RCP));			


#define IMPLEMENT_OTSO_RCP_POINTER(TYPE)				\
  Ostream& operator<<(Ostream& os, concat(TYPE,RCP)& p) {		\
    if (p)								\
      os << "->" << *p;							\
    return os;								\
  }									\
  Istream& operator>>(Istream& is, concat(TYPE,RCP)& p) {		\
    is >> p.inst;							\
    p.p = &p.inst;							\
    return is;								\
  }									\
  ODump& operator<<(ODump& od, concat(TYPE,RCP)& p) {			\
    if (p)								\
      od << *p.p;							\
    else {								\
      OTSO_ERROR("0 " stringize(TYPE) "RCP pointer in operator<<(ODump&," stringize(TYPE) "RCP&), arbitrary value encoded.");			       \
      od << p.inst;							\
    }									\
    return od;								\
  }									\
  IDump& operator>>(IDump& id, concat(TYPE,RCP)& p) {			\
    id >> p.inst;							\
    p.p = &p.inst;							\
    return id;								\
  }									\
  void otsoOutEncode(ODump& od, concat(TYPE,RCP)* p) {			\
    od << p->inst;							\
  }									\
  void otsoOutDecode(IDump& id, concat(TYPE,RCP)* p) {			\
    id >> *p->p;							\
  }									\
  IMPLEMENT_OTSO_INTERNALS_FOR2(TYPE,RCP,operator<<,operator>>,operator<<,operator>> );

/************ end of pointer type macro "templates" ********************/

/**********************************************************************
Classes used in the implementation of OTSO command interpreter.
**********************************************************************/

/**********************************************************************
Type represents either a structured type or an atomic type.
In case of a structured type, 
the user gives list of members and OTSO implements ask and print
(and default versions of encode and decode).
In case of an atomic type, the internal structure of the type is unknown
and user implements the handling functions.
**********************************************************************/

class Type {
public: //?
  String 	name_;
  ClassMember*	firstMember_;
public:
  String 	name()			{return name_;}
  virtual void	print(Ostream& os, void* p);
  virtual void	ask(Istream& is, void* p);
  virtual void	encode(ODump& od, void* p);
  virtual void  decode(IDump& id, void* P);
  virtual void	printMsgs(Ostream*, boolean help);
  virtual ClassMember*  firstMember();
  virtual Member memberObject(String& /*name*/, Objectifier& sp);
  virtual Member memberObject2(String& /*name*/, Objectifier& sp,
			       MemberObjectList& mol);
  Type(const String& name, ClassMember* memberList = 0);
};

extern Ostream& operator<<(Ostream& os, Type& t);
extern Istream& operator>>(Istream& is, Type& t);


/**********************************************************************
ask,print written by user
**********************************************************************/

class HardType: public Type {
  OtsoPrintFnPointer	printFn_;
  OtsoAskFnPointer	askFn_;
  OtsoEncodeFnPointer	encodeFn_;
  OtsoDecodeFnPointer	decodeFn_;
public:
  Member	memberObject(String& name, Objectifier& sp);
  Member	memberObject2(String& name, Objectifier& sp,
			      MemberObjectList& mol);
  virtual void	print(Ostream& os, void* p);
  virtual void	ask(Istream& is, void* p);
  virtual void	encode(ODump& od, void* p);
  virtual void  decode(IDump& id, void* P);
  virtual void	printMsgs(Ostream*, boolean help);

  HardType(const String& 	name, 
	   OtsoPrintFnPointer	printFn,
	   OtsoAskFnPointer	askFn, 
	   OtsoEncodeFnPointer	encodeFn = 0,
	   OtsoDecodeFnPointer	decodeFn = 0,	   
	   ClassMember* 	memberList = 0);
};


extern Ostream& otsoPrintObject(Ostream& os, Object* op);
extern Istream& otsoAskObject(Istream& is, Object* op);
extern ODump& otsoEncodeObject(ODump& od, Object* op);
extern IDump& otsoDecodeObject(IDump& id, Object* op);

/**********************************************************************

**********************************************************************/

class EnumType: public HardType {
public:
  EnumInfo* const info_ ;
  virtual void 		print(Ostream& os, void* p);
  virtual void		ask(Istream& is, void* p);
  EnumType(const String& name, EnumInfo* info,
	   OtsoPrintFnPointer printFn = 0, OtsoAskFnPointer askFn = 0);
};

/**********************************************************************

**********************************************************************/

class ClassMember {
protected:
  void		printMsgHelp(Ostream* os, sint16 charsPrintedOnThisLine);
  String 	name_;
public:
  virtual String name() const;
  String	helpText_;
  ClassMember*	next_;
public:
  ClassMember*  first_;
  ClassMember* 	first() const;
  ClassMember(const String& name, const String& helpText);
  virtual void	print(Ostream&, void* structPtr) = 0;
  virtual void	ask(Istream&, void* structPtr) = 0; 
  virtual void	encode(ODump& od, void* p) = 0;
  virtual void  decode(IDump& id, void* p) = 0;
  virtual void	printMsgs(Ostream* os, boolean help) = 0;
  virtual boolean isWorthPrinting() = 0;
                                //True if print() is likely to print 
                                //something.  Used for avoiding empty 
                                //blocks { }.
  virtual Member memberObject(String& name, Objectifier& sp) = 0;
  virtual Member memberObject2(String& name, Objectifier& sp,
			      MemberObjectList& mol) = 0;
  friend ClassMember& operator,(ClassMember& l, ClassMember& r);
};

#define FOR_EACH_mbr_IN(CLASS)					\
    for (ClassMember* mbr = (CLASS)->firstMember(); 		\
	 mbr; 							\
	 mbr = mbr->next_)

ClassMember& operator,(ClassMember& l, ClassMember& r);

/**********************************************************************

**********************************************************************/

class DataMember: public ClassMember {
  Type**	type_;
  Offset	offset_;
public:
  Type*		type() const;
  virtual void	print(Ostream& os, void* structPtr);
  virtual void	ask(Istream& is, void* structPtr);
  virtual void	encode(ODump& od, void* p);
  virtual void  decode(IDump& id, void* p);
  virtual void	printMsgs(Ostream* os, boolean help);
  virtual boolean isWorthPrinting();

  virtual Member	memberObject(String& name, Objectifier& sp);
  virtual Member	memberObject2(String& name, Objectifier& sp,
			     MemberObjectList& mol);
  DataMember(const String& name, Type** type, Offset offset, 
	     const String& helpText); 
};

extern DataMember noOtsoMembers;	//A dummy instance of ClassMember
                                        //to represent an empty MEMBERLIST.
                                        //first() must be 0.

/*********************************************************************
AbsoluteDataMember has an absolute address,
not relative to the address of the containing structure.
*********************************************************************/

class AbsoluteDataMember: public DataMember {
public:
  virtual Member	memberObject(String& name, Objectifier& sp);
  virtual Member	memberObject2(String& name, Objectifier& sp,
			     MemberObjectList& mol);
  AbsoluteDataMember(const String& name, Type** type, Offset offset, 
		     const String& helpText); 
};

/**********************************************************************

**********************************************************************/

class MethodMember: public ClassMember {
  OtsoNewMsgFnPointer	newMsgFn_;
public:
  virtual void		print(Ostream&, void* /*structPtr*/);
  virtual void		ask(Istream&, void* /*structPtr*/);
  virtual void		encode(ODump&, void* /*structPtr*/);
  virtual void  	decode(IDump&, void* /*structPtr*/);
  virtual void		printMsgs(Ostream* os, boolean help); 
  virtual boolean 	isWorthPrinting();
  virtual Member	memberObject(String& name, Objectifier& sp);
  virtual Member	memberObject2(String& name, Objectifier& sp,
			     MemberObjectList& mol);
  MethodMember(const String& name, 
               OtsoNewMsgFnPointer newMsgFn, 
	       const String& helpText);
};

/**********************************************************************

**********************************************************************/

class PublicBaseClass: public ClassMember {
  Type**		type_;		//Type* would require that otsoType_BBB
                                        //for the base class BBB is initialized
                                        //before otsoType_DDD for the derived
                                        //class DDD.
  Offset		offset_;
  boolean		isWorthPrinting_;
  boolean		isKnownIfWorthPrinting_;
public:
  String 		name() const;
  Type*			type() const;
  virtual void		print(Ostream& os, void* structPtr);
  virtual void		ask(Istream& is, void* structPtr);
  virtual void		encode(ODump& od, void* p);
  virtual void  	decode(IDump& id, void* p);
  virtual void		printMsgs(Ostream* os, boolean help);
  virtual boolean	isWorthPrinting();

  virtual Member	memberObject(String& name, Objectifier& sp);
  virtual Member	memberObject2(String& name, Objectifier& sp,
			      MemberObjectList& mol);
  PublicBaseClass(const String& name, Type** base, 
                  Offset offset, const String& helpText);
};


/**********************************************************************
Define OTSO_ISTREAM_DEFAULT_MEMBERS that specifies the list of 
global objects that appears "automatically" in each OTSO process.
Typically called in main() by generated code.
**********************************************************************/

#if DEBUGGING_FREE_STORE_MEMORY

#define OTSO_ISTREAM_DEFAULT_MEMBERS 					\
    OTSO_NAMED_OBJECT(Ostream,dout,"terminal output (cout)")		\
   ,OTSO_NAMED_OBJECT(Scheduler,*scheduler,"scheduler")			\
   ,OTSO_NAMED_OBJECT(DynDir,*otsoProcesses,"list of operating system processes involved in this application")	\
   ,OTSO_NAMED_OBJECT(MBlockInfoArray,*memoryWatchdog,"keeps an eye on free store memory")

#else

#define OTSO_ISTREAM_DEFAULT_MEMBERS 					\
    OTSO_NAMED_OBJECT(Ostream,dout,"terminal output (cout)")		\
   ,OTSO_NAMED_OBJECT(Scheduler,*scheduler,"scheduler")			\
   ,OTSO_NAMED_OBJECT(DynDir,*otsoProcesses,"list of operating system processes involved in this application")	

#endif /*DEBUGGING_FREE_STORE_MEMORY*/

/**********************************************************************
Declare OTSO interface for predefined types:
**********************************************************************/

DECLARE_OTSO_PAED_FOR(sint32);
DECLARE_OTSO_PAED_FOR(uint32);
DECLARE_OTSO_PAED_FOR(sint16);
DECLARE_OTSO_PAED_FOR(uint16);
DECLARE_OTSO_PAED_FOR(sint8);
DECLARE_OTSO_PAED_FOR(uint8);

DECLARE_OTSO_PAED_FOR(double)

DECLARE_OTSO_RETURN_TYPE(sint8);
DECLARE_OTSO_RETURN_TYPE(uint8);
DECLARE_OTSO_RETURN_TYPE(sint16);
DECLARE_OTSO_RETURN_TYPE(uint16);
DECLARE_OTSO_RETURN_TYPE(sint32);
DECLARE_OTSO_RETURN_TYPE(uint32);

DECLARE_OTSO_RETURN_TYPE(double);

/**********************************************************************
VoidPointer
***********************************************************************/

DECLARE_OTSO_INTERNALS_FOR(VoidPointer);
DECLARE_OTSO_RETURN_TYPE(VoidPointer);
Ostream& operator<<(Ostream& os, VoidPointer& p);
//Istream& operator>>(Istream& is, VoidPointer& p);
ODump& operator<<(ODump& od, VoidPointer& p);
IDump& operator>>(IDump& id, VoidPointer& p);

