/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.tree.hxx
 * Vers: 5.2    Time: 92/08/06, 12:16:23
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//	tree.hxx 	- Juha 18.3.92

/**********************************************************************
This file is the combination of llist.hxx and tree.hxx
**********************************************************************/

//#include "object.hxx"


/*	llist.hxx	*/

/**********************************************************************

**********************************************************************/

class VLink {
public:
	VLink(void* o)	{ obj = o; next = 0; }
	VLink*	next;
	void*		obj;
};

/**********************************************************************
Class LinkedList implements a simple linked list.
The implementation is a bit rude.
We should really have a more general implementation for
container classes than the Group implementation can provide!
**********************************************************************/

class LinkedList {
private:
	VLink*	fst;
	VLink*	cur;
	VLink*	lst;
	uint16	count;
public:
	LinkedList();
	void	add(void*);
	void	del(void*);
	boolean	isEmpty()	{ return !count; }
	uint16	size()		{ return count; }
	void*	first();	/*  *E* implement a separate iterator */
	void*	next();
	boolean	over();
	void	reset();
};


/*	tree.hxx	*/

/**********************************************************************
*MJS* implemented the TreeNode class to form tree hierarchies.

.SH BUGS
*E* we should use Object* instead of void* .
At this stage we cannot do that because StatObj is not an Object...
**********************************************************************/

class TreeNode: public Object {
private:
	TreeNode*	parNode;
	LinkedList	cldNodes;
	void*		obj;
public:
	TreeNode()	{ parNode = 0; obj = 0; }
       ~TreeNode();				//makes compiled code smaller
	void		setObject(void* o)	{ obj = o; }
	void*		object()		{ return obj; }
	void		setParentLink(TreeNode* pp) { parNode = pp; }
	void		setParent(TreeNode* pp);
	TreeNode*	parent()		{ return parNode; }
	uint16		noOfChildren()		{ return cldNodes.size(); }
	TreeNode*	child(uint16 id);	//id of the 1st child is 1
	void		addChildLink(TreeNode* cp);
	void		delChildLink(TreeNode* cp);
	void		addChild(TreeNode* cp);
	void		delChild(TreeNode* cp);
};

