/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.sampled.hxx
 * Vers: 5.1    Time: 92/08/03, 15:48:32
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//sampled.hxx	- Juha 18.3.92

/**********************************************************************
This file is the combination of 
 - histogram.hxx
 - student.hxx
 - samplnum.hxx
 - samplcon.hxx
 - sampcohg.hxx
 - sampldis.hxx
 - sampdihg.hxx
 - samplrat.hxx
**********************************************************************/

//#include "numobj.hxx"

/*	student.hxx	*/

/**********************************************************************
student() calculates point x: Prob{ T(df) <= x } = p, where
.nf

	- T() is student's distribution (also known as t-distribution)
	- p is value between ]0.0, 1.0[
	- df is degree of freedom

.fi
**********************************************************************/

extern double	student (double p, int df);


/*	histogram.hxx	*/

/**********************************************************************
This class enables the gathering of histograms. The basic idea is to
divide the interval into smaller intervals each having the same width
and calculate percentages for each of these intervals.
**********************************************************************/

class Histogram {
private:
	double	lo;
	double	hi;
	double	wi;
public:
	Histogram(double lo_, double hi_, double width_);
	virtual double	perCentOfSimilar(double d) = 0;
	sint32	index(double v);
	uint16	maxIndex()	{ return index(hi); }
	double	low() const	{ return lo; }
	double	high() const	{ return hi; }
	double	width()	const	{ return wi; }
};


/*	samplnum.hxx	*/

/**********************************************************************

**********************************************************************/

class SampledNum: public Object {
protected:
	double	val;
	double	x;
	double	x2;
	double	minValue, maxValue;
public:
	SampledNum(double v = 0.0);
	double	value()	{ return val; }
	double	min()	{ return minValue; }
	double	max()	{ return maxValue; }
	double	sum()	{ return x; }
	virtual void	reset();
	virtual void	operator+=(double) = 0;
	virtual	double	mean() = 0;
	virtual	double	stdDev() = 0;
	virtual double	var() = 0;
	redefined void	print(Ostream& os);
};


/*	samplcon.hxx	*/

/**********************************************************************

**********************************************************************/

class SampledCont: public SampledNum {
private:
	Time	startCnt;
	Time	stopCnt;
	Time	startIVal;
	Time	stopIVal;
	Time	ival;
	double	tmp;
	void	updIgral();
public:
	SampledCont(double v = 0.0);
       ~SampledCont();				//makes compiled code smaller
	redefined void		reset();
	redefined void		operator+=(double);
	redefined double	mean();
	redefined double	var();
	redefined double	stdDev();
	void	start();
	void	stop();
	virtual SampledCont*	copy()	{ return new SampledCont(*this); }
				// we need copy() in class SONumObj
	Time	sampleInterval();
	boolean	hasBeenCounted()	{ return startIVal.isSet() &&
						 stopIVal.isSet(); }
	void	checkCount();
	virtual void	updDerived(Time)	{}
				// see SampledContHg for explanation!
};


/*	sampcohg.hxx	*/

/**********************************************************************

**********************************************************************/

class SampledContHg: public SampledCont, public Histogram {
private:
	Time*	shares;
public:
	SampledContHg(double lo = 0.0, double hi = 1.0, double width = 1.0);
	SampledContHg(const SampledContHg&);
	Time	spentBySimilar(double v);
	redefined void		reset();
	redefined SampledCont*	copy()	{ return new SampledContHg(*this); }
	redefined void		updDerived(Time iv);
	redefined double	perCentOfSimilar(double d);
					//[0.0, 100.0], of total time
};


/*	sampldis.hxx	*/

/**********************************************************************

**********************************************************************/

class SampledDisc: public SampledNum {
private:
	uint32	n;
public:
	SampledDisc();
	redefined void		reset();
	redefined void		operator+=(double);
	redefined double	mean();
	redefined double	var();
	redefined double	stdDev();

	uint32	size()	{ return n; }
					//p: [mean()-x,mean()+x]
	double	confForMean(int p_percentage)
				{ return confForMean(p_percentage / 100.0); }
	virtual double	confForMean(double p_value);
	redefined void	print(Ostream& os);
};


/*	sampdihg.hxx	*/

/**********************************************************************

**********************************************************************/

class SampledDiscHg: public SampledDisc, public Histogram {
private:
	uint32	accCount;
	uint32*	shares;
public:
	SampledDiscHg(double lo, double hi, double width);
	uint32	noOfAccepted()	{ return accCount; }
	uint32	noOfSimilar(double v);
	redefined void		reset();
	redefined void		operator+=(double v);
	redefined double	perCentOfSimilar(double d);
					//[0.0, 100.0], of accepted
};


/*	samplrat.hxx	*/

/**********************************************************************
Class SampledRatio calculates statistics for ratio n/d.
**********************************************************************/

class SampledRatio: public SampledDisc {
private:
	SampledDisc	ntor;	//x in x/y (numerator)
	SampledDisc	dtor;	//y in x/y (denominator)
	double		xy;
public:
	SampledRatio();
	redefined void		reset();
	redefined void		operator+=(double) {}
	redefined double	mean();
	redefined double	var();
	redefined double	confForMean(double p_value);
	void	ratioSample(double n, double d);
	double	covar();
};

