/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.process.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:21
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILE
*  process.hxx
**********************************************************************/

/**********************************************************************
A Process instance represents an operating system process.
A Process is a kind of agent of the real "server" process.
In each real process, there is one instance of Process for each
real process in the system.
Data can be transferred to remote real processes through readsFrom()
and writesTo() O/Istreams.

'::thisProcess' is a Process instance representing the local real process.
thisProcess is a pointer to the Process instance that represent the 
local process.  Each object's process() returns pointer to the Process
instance that the object resides in.

The class Process is used to create aliases for physical processes.  
It allows Inter-process communication (IPC) between processes by
allowing the process to create Process aliases for other processes
that assign physical communciation channels between processes using
readsFrom() and writesTo().  For the IPC to work, both processes must
have complementary aliases for each other.

.SH USAGE
readsFrom() is an Ostream (output channel).
writesTo() is an Istream (input channel) and should be watched
for events (ev_read).

The names readsFrom() and writesTo() may be confusing when they
are attached to din and dout, but they make sense when
they refer to Process Objects used for IPC :

.nf
                Process A               Pipe       Process B
           ------------------------    ====    ---------------------
   dout << a.readsFrom  b.readsFrom >>  a2b  >> a.writesTo  b.writesTo  << din
   din  >> a.writesTo   b.writesTo  <<  b2a  << a.readsFrom b.readsFrom >> dout
           ------------------------           ----------------------
.fi

.SH EXAMPLE
This is a (specific) example of two Unix Processes that communicate 
with each other via Named Unix Pipes (see mknod(8), devxfile.hxx).
Some details have been left out.

.nf
-----------------------------------------------------------------
  //a.out                               | //b.out
                                        | 
  Process a, b;                         | Process a, b;
  thisProcess = & a;                    | thisProcess = & b;
                                        | 
  a.writesTo() = &din;                  | b.writesTo() = &din;
  a.readsFrom() = &dout;                | b.readsFrom() = &dout;
                                        | 
  File_Device a2b ("a.send_to.b",       | File_Device b2a ("b.send_to.a",
          namedPipe);                   |         namedPipe);
  File_Device b2a ("b.send_to.a",       | File_Device a2b ("a.send_to.b",
          namedPipe, ev_read);          |         namedPiped, ev_read);
                                        | 
  b.readsFrom() = new ODump(&a2b);  --->--- a.writesTo() = new IDump(&a2b);
  b.writesTo() = new IDump(&b2a);   ---<--- a.readsFrom() = new ODump(&b2a);
                                        | 
  scheduler -> inQ() ->                 | scheduler -> inQ() ->
    put(...,a.writesTo(),b.writesTo()); |   put(...,b.writesTo(),a.writesTo());
  ----------------------------------------------------------------  
.fi

The above snippets of code from 2 physical Processes (a.out and b.out)
produces the following effects :

.nf  
  UNIX Process a.out (varA resides somewhere in a.out) :
    a.readsFrom() << varA.        // cout readsFrom varA 
    a.writesTo() >> varA.         // cin writesTo varA
  
    b.readsFrom() << varA.        // b.out (a2b) reads varA
    b.writesTo() >> varA.         // b.out (b2a) writes into varA
  
  UNIX Process b.out (varB resides somewhere in b.out) :
    b.readsFrom() << varB.        // cout readsFrom varB
    b.writesTo() >> varB.         // cin writesTo varB
  
    a.readsFrom() << varB.        // a.out (b2a) readsFrom varB
    a.writesTo() >> varB.         // a.out (a2b) writesTo varB
.fi

The IPC takes place thru the OTSO Devices a2b and b2a, which
actually read from and write to Named Unix Pipes.

.SH BUGS
Should have the name Process_agent (?).

Should encapsulate all Operating System service (?).

.SH MODIFICATIONS

***********************************************************************/


class Process : public Runner {
private:
  Ostream*	re;
  Istream*	wr;
  void		contains1(Runner* r);
public:

  virtual boolean local();	//is this thisProcess?

  Ostream*&	readsFrom()	{return re;}
                                //readsFrom writes to the channel
                                //transferring data from
                                //thisProcess to the "server" 
                                //process represented by this.

  Istream*&	writesTo()	{return wr;}
                                //writesTo istream reads the channel
                                //where the "server" writes to

  boolean	operator==(Process&);
  virtual int 	select(int width, fd_set* readFds, fd_set* writeFds,
	               fd_set* exceptFds, timeval* timeout);
                                //The same as BSD select.  
                                //Enables devices if they are
                                //ready for reading or writing.
                                //Further info: man select
  Process&	contains(Runner* r1  , Runner* r2 = 0, Runner* r3 = 0,
			 Runner* r4=0, Runner* r5 = 0, Runner* r6 = 0);
				//this will be parameters' myMemory

  void		print(Ostream& os);
                                //Prints '(', names of namedObjs that reside
                                //in this process, and ')'.
  String	className() const;
  Process(Ostream* readsfrom = dummyOstream);
};

extern DynDir* otsoProcesses;   //Directory of Process instances.
                                //Process constructor inserts them here.
                                //A problem: elements are NamedObjs.
