/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.object.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:16
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILE object.hxx
**********************************************************************/


/*****************************************************
* OTSO CLASS NAMES
*****************************************************/
  
class Agent;
struct ASNHOME; //?
class Bytes;
class Channel;
class ClassMember;
class Device;
class DynDir;
class Fifo;
class Frame;
class Group;
class Heap;
class IDump;
class Int;
class Istream;
class Link;
class MemberObjectList;
class Message;
class Multi;
class MultiPtr;
class NamedObj;
extern NamedObj *dummyNamedObj;
typedef Message NewMsg; 
class Object;
class Objectifier;
class Ostream;
extern Ostream* dummyOstream;
class ODump;
class Pointer;
class PriorVec;
class Process;
extern Process* thisProcess;
class Promise;
class Ring;
class Runner;
class Task;
class Type;
class Scheduler;
class String;
class Time;	// *MJS* changes
class Timer;
class VoidGroup;
class VoidFifo;
class VoidLifo;

#if SIMULATING       /* *MJS* changes */
  class SimObs;
  class SOGroup;
  class SORunStatus;
  class VThread;
  //...
#endif

/**********************************************************************
Overloaded form() functions are declared in channel.hxx.
Their implementation needs sprintf().
**********************************************************************/

#include <stdio.h>

/*********************************************************************
Used for the definition of OTSO interface of a class.
See OTSO User's Guide.
*********************************************************************/

#define DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(CLASS)			\
  friend ClassMember* otsoInterfaceFunction(CLASS*);			\
  virtual void* otsoMostDerivedPointer();				\
  virtual Type& otsoType()


/**********************************************************************
Send normal output to dout (OTSO counterpart to cout).
Read input from din (OTSO counterpart to cin).
din tests if input stream is in good state.
**********************************************************************/

#define dout (*doutStream)
#define dlog (*dlogStream)

extern VoidLifo* dinStack;
extern Istream& endOfOtsoInputFile(); 
#define din ( (void*)*dinStream ? (*dinStream) : endOfOtsoInputFile() )

extern char *debug();

/**********************************************************************
Warning and error messages should be printed using these macros:
**********************************************************************/

#define OTSO_WARNING(xxx)						\
  *warningStream << "\n***** Warning: " << xxx << "\n" << ::debug()
#define OTSO_ERROR(xxx)						        \
  *errorStream << "\n***** Error: " << xxx << "\n" << ::debug()

#if OTSO_DEBUGGING
#define OTSO_ASSERT(XXX) 						\
     { if (!(XXX)) 							\
         OTSO_ERROR("OTSO_ASSERT failed. "				\
                     "File " << __FILE__ << ", line " << __LINE__ ); 	\
     }
#else
#define OTSO_ASSERT(XXX) /*?*/
#endif

#define OTSO_UNDEFINED(XXX) 						\
  OTSO_ERROR( "Undefined " << XXX << " called." );


extern Ostream* warningStream;
extern Ostream* errorStream;

/********************************************************************
These are needed when translating AUTOMATON to C++ (juhaOptions)
*********************************************************************/

#define DEFAULT_in DEFAULT()
#define DEFAULT_inOtsoArguments
#define DEFAULT_inOtsoHomeArguments(IMPLE) IMPLE* home
#define DEFAULT_out DEFAULT()
#define DEFAULT_outOtsoArguments
#define DEFAULT_outOtsoHomeArguments home

#define Runner_otsoHomeInterface(IM)

/**********************************************************************
This is usually false.  OTSO wizards may set this true for debugging purposes
(for example to print certain warnings only to wizards).
**********************************************************************/

extern boolean otsoJuhaIsDebugging;

/**********************************************************************
Miscellaneous typedefs
**********************************************************************/

typedef Object* Member;
typedef sint32 ConnectionId;
//typedef sint32 Time; 	// *MJS* changes: use class Time instead - jfr!
//typedef Time Delay;	// *MJS* changes - jfr!
typedef uint32 Offset;	       //Should be able to store any pointer
                               //and should know operator+ and operator- .
                               //env?.h

/********************************************************************
EnumInfo stores the string name and the numeric value of enum constants.
One table may be generated for each enum type.
********************************************************************/

struct EnumInfo {
  char*		name;
  sint32	value;
};

/********************************************************************
VoidPointer 
********************************************************************/

class VoidPointer {
  friend Ostream& operator<<(Ostream& os, VoidPointer& p);
  //friend Istream& operator>>(Istream& is, VoidPointer& p);
  friend ODump& operator<<(ODump& od, VoidPointer& p);
  friend IDump& operator>>(IDump& id, VoidPointer& p);
private:
  void* p;
public:
  operator void* ()			{return p;}
  void* operator->()			{return p;}
  VoidPointer(void* i = 0): p(i)	{}
};

#if 0

/*********************************************************************
Implementation of (list of remote SPs of service XXX) could use this:

  virtual VoidPointer	memberPointer(String memberName); 
                                        //Returns other that 0 if 'memberName'
                                        //is a member of this.
*********************************************************************/

/*********************************************************************
This class is handled by the OTSO preprocessor, but not by C++ compiler.
Interface class Object defines the part of Object interface that is
shown to the user interface and remote objects 
(after a sed translation).
*********************************************************************/

interface class Object {
public:
  virtual void		printToDout();	//Output this to dout.
  virtual void		askFromDin();	//Ask this from din.
};

#endif


/*******************************************************************
In the hierarchy of OTSO objects, class Object is the
root of the hierarchy tree. Object is the base class of 
most of the classes in the OTSO class inheritance graph.
Classes written by an application programmer, however, 
need not necessarily be derived from Object.

Class Object has very basic functions that every object
will use, and most of them are virtual: 
printing to an output stream, asking from input stream,
encoding to transfer syntax, decoding etc.
Derived Objects can be inserted to Ostream and ODump,
and extracted from Istream and IDump.
These operations are implemented by print(), to(), ask(), and from()
virtual functions.

Object does not contain any data members.

.SH BUGS
... many ...

.SH MODIFICATIONS
... even more ...
*********************************************************************/

class Object {

/********************
.SH Names (see also class NamedObj)
********************/
public:

  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(Object);


  virtual String	name() const;
                                    //Returns readable name, if a name has
                                    //been given via setName(), and this is
                                    //capable of storing the name string.
                                    //Otherwise className() is returned.
  virtual void 		setName(char*);
  virtual void 		setName(const String&);
                                    //Give this a global name that name() 
                                    //should return.  Only NamedObj's are able
                                    //to store the given name; simpler objects
                                    //do not contain the data member needed
                                    //to store a string.
  virtual String 	className() const;
                                    //The name of the class.  Derived classes
                                    //should always redefine this method.
/********************
.SH Emptiness
********************/

  virtual boolean	isEmpty();  //True if no value in this object.
                                    //For example, a queue with no elements
                                    //is empty.  
                                    //Object::empty returns false.
  virtual void		reset();    //Move this to initial state.  Make 
                                    //empty so that isEmpty() will be true.

/********************
.SH Encoding and Decoding
********************/

  virtual void		print(Ostream& os);
                                    //Print in a human readable format to os.
                                    //Usually the same as dout << *this;
  virtual void		ask(Istream& is); 
                                    //Reads from is, usually also prints 
                                    //a very short guiding help text (prompt).
                                    //Usually the same as din >> *this;
  virtual void		to(ODump& od); 
                                    //Encoding: flatten all data of this object
                                    //and insert the generated 
                                    //byte stream into od.
  virtual void		from(IDump& id);
                                    //Decoding from is to this.
  virtual void		asnEncode(Frame& o); 
                                    //Encode according to ASN.1 basic encoding
                                    //rules and insert into o.  
                                    //Use of to() recommended.
                                    //Implemented only if the 
                                    //derived data type has been generated
                                    //from ASN.1 description.
  virtual void		asnDecode(Frame& i);
                                    //ASN.1 decoding.
                                    //Use of from() recommended.
                                    //Implemented only if the 
                                    //derived data type has been generated
                                    //from ASN.1 description.
/******************
.SH Command interpreter
******************/
  virtual Member runUI(Objectifier sp, String prompt, String memberName);
                                    //Read method name and execute it.
                                    //No method name is read,
                                    //if non-empty String given in
                                    //'memberName'.
  virtual void		printMsgs(Ostream* out, boolean help); 
                                    //Prints the names of methods that
                                    //this can convert to message objects
                                    //in newMsg().  Prints also the names
                                    //of data members that can be used from
                                    //the command interpreter.
                                    //If help is true, prints also explanatory
                                    //help text about the alternatives.
                                    //printMsgs is usually generated by OTSO
                                    //for application types.
  virtual VoidPointer	memberPointer(String memberName);
                                    //Returns other that 0 if the command 
                                    //interpreter knows about a member of this
                                    //that has the name 'memberName'.  
                                    //The member may be 
                                    //data, a method, or a base class.
                                    //If it is a data member or a base class,
                                    //memberPointer() returns
                                    //a pointer to the member.
                                    //If it is a method member, memberPointer()
                                    //returns a pointer to a message!
/*******************
.SH Address space
********************/

  virtual Process*&     process() const;
                                    //Returns the Process in whose address
                                    //space this resides in.
  virtual Runner*	myScheduler() const;
                                    //Returns the Runner that gives execution
                                    //time for this.  Makes sense only for 
                                    //Runners.
/******************
.SH Messages (documented in class Runner)
******************/

  virtual void		runOrQueue(Runner& runner);
  virtual void		sendOrQueue(Message& msg);
  virtual Group*	inQ() const;                                    

/******************
.SH Multiple connections (experimental, not worth trying)
******************/
  virtual void*		connection(ConnectionId conId);
                                    //Return the identified connection,
                                    //which is this unless multiple connections
                                    //are used.
  virtual void*		newConnection(ConnectionId& c);
                                    //Return this, or a new instance in case
                                    //of multiple connections.
                                    //c will be the id of the returned object,
                                    //noConnection if not new connection.
  virtual void 		deleteConnection(ConnectionId);
                                    //Delete a connection.
  virtual void		setSender(Agent* agent);
                                    //Tells this who the service user (SU) is.
                                    //agent is SU's MultiPtr to SP.
  static const ConnectionId noConnection;
				    //Id of the objects that does not support
                                    //multiple connections,
                                    //or the Multi object itself
                                    //in case of multiple connections.
                                    //Will be removed soon.
  virtual Object*	server();   //agent's server, this otherwise

/******************
.SH Simulation	
******************/
  virtual Time&         time();     // *MJS*: the current time in real systems,
                                    // simulation time in simulation systems
  Time&                 cpuTime();  // *MJS*: the CPU time used by this process
                                    //(or thread).
  Time&                 realTime(); // *MJS*: the current time.

/*****************
.SH Miscellaneous
******************/
  String		sender() const;
                                    //The name() of the most recent 
                                    //service user object
                                    //of this object.
                                    //Updated just before running a 
                                    //message sent by the SU,
                                    //and before executing a function called
                                    //via a Ptr directly without a message.
  virtual async		timeout(sint32 id);
                                    //Timer id expired.
                                    //Probably will be moved to Runner.
  void			undefined(char*) const; 
                                    //Delete when Object is abstract base class
  virtual ASNHOME*	toASNHOME();
                                    //Creates and returns an ASNHOME structure
                                    //that points to this.  See CASN documents.

  virtual ~Object();

#if DEBUGGING_FREE_STORE_MEMORY
  Object();			    //Used only for free store memory 
                                    //debugging purposes.
#endif
};


extern Object dummyObject;

/*******************************************************************
isOtsoPromiseType functions are needed to tell if a variable is Promise type or
not, because DVOPS prepro cannot tell it. true for Promises, false for others.
*******************************************************************/

inline boolean isOtsoPromiseType(Promise*) {return true;}
inline boolean isOtsoPromiseType(void*) {return false;}

extern Ostream& operator<<(Ostream& os, const Object& o);
extern Istream& operator>>(Istream& is, Object& o);
extern ODump& operator<<(ODump& od, Object& o);
extern IDump& operator>>(IDump& id, Object& o);

extern Ostream& operator<<(Ostream& os, Object*& o);
extern Istream& operator>>(Istream& is, Object*& o);
extern ODump& operator<<(ODump& od, Object*& o);
extern IDump& operator>>(IDump& id, Object*& o);


/********************************************************************
objectify functions are used in those parts of command interpreter
that handle one element of a structure accessed via name.
********************************************************************/

extern Object* objectify(Object& o);
extern Object* objectify(Object*);


/********************************************************************
otsoSetName functions can be used to give a name to OTSO Objects.
Empty implementation (?) to non-Object objects is needed because
prepro does not know if a type is derived from OTSO Object or not.
********************************************************************/

void otsoSetName(Object* o, char* name);
void otsoSetName(void*   p, char* name);


/****************************************************************
All OTSO global variables should be members of class Globals.
Add all new OTSO global variables here !

Later these may be put into classes Thread and Memory.

.SH BUGS

Used inconsistently.
****************************************************************/
class Globals : public Object {

public:
#if 0
  // Remove these !!! *MJS* changes
  Time&			time();
                                            //?See simulation documents?
  timeval		sys_time;	    //Approximate system time.
  static Time		time_;		    //Virtual time, used in simulation?
#endif

  boolean		simulating_;	    
  boolean		simulating() const; //Return true iff we are currently
                                            //running a simulation application.
                                            //Used when files are compiled 
                                            //with SIMULATING option on.
  Process*		lastConstructedNode;//Points to the Process that was 
                                            //constructed most lately.
                                            //Used in Runner initialization.

  void			print(Ostream&);    
  void			ask (Istream&);	    
  String		className () const;

  Globals();
};

extern Globals *globals;
