/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.multi.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:12
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************************
*
* FILE multi.hx
*
******************************************************************/

/**********************************************************************
Almost a dummy class.
Will be used for the implementation of multiple simultaneous connections
someday.
**********************************************************************/

class Multi: public Object {
public:
  Multi();
 ~Multi();
protected:
  String 	    sender() const;	  //SU name, the caller of the
                                          //function.
  void	            setSender(Agent* agent);
                                          //Called in MultiPtr::op->() and
                                          //<derived>Message::run() to update
                                          //sender().
private:
  Agent*	    senderAgent_;	  //The user who sent the latest
                                          //service request.
                                          //Updated in MultiPtr::op->() and
                                          //<derived>Message::run().
};

#if 0

/*********************************************************************

THIS IS AN OUT-OF-DATE PROTOTYPE OF CLASS Multi:

Application code should be independent of multiple/single connections.

Each object that sometimes may support multiple connections
should be derived from class Multi.
(To make things simple, Runner is derived from Multi.)
A multi is the manages instance of a class derived from Multi.
A connection is a cloned instance of the same class.
The initialization of its Multi part determines if the instance
supports multiple connections or not: 

     Multi(n)

where n > 0 allows n simultaneous connections to be created at run
time.  0 or no explicit initialization means no multiple connections.

Each derived Multi should redefine clone() to return
pointer to a free-store copy of itself, a new connection object.
clone() functions should use the copy constructor C::C(const C& m),
where m is the multi instance.
All other constructors are used to construct multi objects.

.SH BUGS
clone() should be abstract (= 0;) !
*********************************************************************/

class Multi: public Object {
  friend class MultiPtr;		  //manipulates conId
public:
  void* newConnection(ConnectionId& c);
					  //Return a new connection instance,
					  //c will be its id. Return this if
					  //no new connection can be created.
  void* connection(ConnectionId c);
                                          //Returns the connection c,
				       	  //or this if unknown ConnectionId.
  void deleteConnection(ConnectionId); 
                                          //Delete a connection; no effect
                                          //if ConnectionId refers to multi.
  virtual void* clone();		  //Create and return a free-store 
                                          //copy of this, created 
                                          //using the copy constructor. Must
                                          //be redefined.
  boolean isMulti()			  {return (conId == Multi::itself);}
                                          //True if this the multi instance,
                                          //false for connections.
  Multi(sint32 maxConns = 0);		  //Max number of dynamic connection,
                                          //default is none but the multi
                                          //instance.  1 does not make sense:
                                          //if maxConns > 0, multi instance is
                                          //not used (except for constructing
                                          //new connection instances).
  ~Multi();				  //If this is connection, deletes this
                                          //and resets multi's pointer to this.
					  //If this is multi, deletes all 
                                          //connections.
protected:
  ConnectionId	    conId;		  //ConnectionId of this.
  Multi**	    connections;	  //
  sint32	    maxConnectionNumber;  //Max number of connections,
                                          //excluding multi itself.
  void	            setSender(Agent* agent);
  String 	    sender() const;	  //SU name.
private:
  Agent*	    senderAgent_;	  //The user who sent the latest
                                          //service request.
                                          //Updated in MultiPtr::op->() and
                                          //<derived>Message::run().

private:
  static const ConnectionId itself;	  //ConnectionId of the multi, not connection.
  ConnectionId	freeConnectionId();	  //Return a ConnectionId of a free connection
};

#endif
