/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/incfirst/SCCS/s.PROTOCOL.hxx
 * Vers: 5.2    Time: 92/08/03, 16:57:09
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef PROTOCOL_HXX
#define PROTOCOL_HXX


#if 0


This is a general OTSO header file. Include this into every .cxx
module dealing with OTSO *PROTOCOL* classes !

OTSO developers might do the following (in OTSO's kernel .cxx:s):

1. #define as 1 only the names of headers you want to include
2. #define OTSO_PROTOCOL_INCLUDES as 1
3. #include "OTSO.hxx"
   #include "PROTOCOL.hxx"

and OTSO PROTOCOL users would probably just (in application .cxx:s):

1. #include "OTSO.hxx"
   #include "PROTOCOL.hxx"


IMPORTANT NOTE.1:
	Other OTSO kernel header files don't need anymore extraneous
	#define lines to know if they are already included. It is handled
	here.

IMPORTANT NOTE.2:
	If new header files are added to OTSO or old headers
	are deleted, modify this file accordingly !!!

IMPORTANT NOTE.3:
	#include lines in this file should be ordered properly !!!


-------------- start of example -----------------

// Example.cxx:

#define OBJECT_HXX		1 /* I want these headers included */
#define FRAME_HXX		1
...
...
#define OTSO_PROTOCOL_INCLUDES	1 /* Prevent including other OTSO headers; */
				  /* this speeds up compilation! */
#include "OTSO.hxx"
#include "PROTOCOL.hxx"

-------------- end of example -----------------

#endif  /* #if 0 */



/* make this usable in #if:s here */
#ifdef OTSO_PROTOCOL_INCLUDES
# if (OTSO_PROTOCOL_INCLUDES != 0) && (OTSO_PROTOCOL_INCLUDES != 1)
#  undef OTSO_PROTOCOL_INCLUDES
#  define OTSO_PROTOCOL_INCLUDES	1
# endif
#else
# define OTSO_PROTOCOL_INCLUDES	0
#endif


/**************************************************/
/* OSI Connection Oriented Network Service (CONS) */
/**************************************************/
#if (!OTSO_PROTOCOL_INCLUDES) || (CONS_PEER_HXX == 1)
#include "cons_peer.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (CONS_SERV_HXX == 1)
#include "cons_serv.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (CONS_HXX == 1)
#include "cons.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (NETTCP_HXX == 1)
#include "nettcp.hxx"
#endif

/*********************************************/
/* OSI Connectionless Network Service (CLNS) */
/*********************************************/
#if (!OTSO_PROTOCOL_INCLUDES) || (CLNS_PEER_HXX == 1)
#include "clns_peer.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (CLNS_SERV_HXX == 1)
#include "clns_serv.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (CLNS_HXX == 1)
#include "clns.hxx"
#endif

/******************************/
/* OSI Transport Layers 0 - 4 */
/******************************/
#if (!OTSO_PROTOCOL_INCLUDES) || (TRAN_PEER_HXX == 1)
#include "tran_peer.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (TRAN_SERV_HXX == 1)
#include "tran_serv.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (TRANCOD_HXX == 1)
#include "trancod.hxx"
#endif

#if (!OTSO_PROTOCOL_INCLUDES) || (TRAN0_HXX == 1)
#include "tran0.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (TRAN4_HXX == 1)
#include "tran4.hxx"
#endif


/******************************/
/* VIRTUAL PHYSICAL LAYER     */
/******************************/
#if (!OTSO_PROTOCOL_INCLUDES) || (VPHYS_PEER_HXX == 1)
#include "vphys_peer.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (VPHYS_SERV_HXX == 1)
#include "vphys_serv.hxx"
#endif
#if (!OTSO_PROTOCOL_INCLUDES) || (VPHYS_HXX == 1)
#include "vphys.hxx"
#endif


#endif    /* PROTOCOL_HXX */
