/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.memdbg.hx
 * Vers: 5.2    Time: 92/08/04, 12:39:40
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
     FILE memdbg.hxx

In OTSO, you can use the normal C++ memory allocation system (new, delete).
#if DEBUGGING_FREE_STORE_MEMORY is non-zero, global
operator new() and operator delete() are redefined here
to provide services listed in file memdbgSP.hx.
This module is very inefficient, and is intended to be used only in the
debugging phases.
**********************************************************************/

#if DEBUGGING_FREE_STORE_MEMORY

/**********************************************************************
isOtsoFreeStorePointer tells if the given pointer is allocated from
free store memory (using OTSO's operator new), but not yet deleted.
Slow and not completely reliable (?) => Use only for debugging purposes. 
If !DEBUGGING_FREE_STORE_MEMORY , the implementation is inline true
(see object.hxx) !
**********************************************************************/

boolean isOtsoFreeStorePointer(void* p);

class MBlockInfoArray;
class MBlockInfo;
class MBlock;

/**********************************************************************
Used only when DEBUGGING_FREE_STORE_MEMORY,
part of the implementation of free store memory debugging services.
One MBlock is allocated for each free store memory block.
It contains one index of MBlockInfoArray, that contains data
about this memory block. The index is the way to reach the information
about the block from the memory address of the block.
MBlock resides immediately before the memory block 
that is returned to the caller of 'new'. 

.SH BUGS
Portability may be endangered by pointer arithmetic, e.g. userBlock().
Requires that this (returned by malloc) + sizeof(MBlock) is a valid
address to be returned to the caller of 'new'.
**********************************************************************/

class MBlock {
  friend void deleteMBlock(MBlock*);
public:
  void* 	userBlock() const;	//pointer to the block of memory
                                        //that is returned to the caller 
                                        //of 'new'.
  boolean	isTrapped() const;	//Tells if this is the block whose
                                        //'new' and 'delete' the user wishes 
                                        //to be notified of.
  boolean 	isBad(char*& diagnostic) const;
                                        //If true, the probable cause is 
                                        //returned in diagnostic.
                                        //Not completely reliable (?).
  sint32	index()	const		{return index_;}
  void 		setType(Type*);		//
  void		set(size_t s);		//Connects this to memoryWatchdog,
                                        //and memoryWatchdog to this.
private:
  sint32	index_;
};

extern MBlock* newMBlock(size_t userBlockSize);
extern void newMBlock(MBlock*);

/**********************************************************************
Used only when DEBUGGING_FREE_STORE_MEMORY,
part of the implementation of free store memory debugging services.
One MBlockInfo is allocated for each free store memory block,
and inserted into memoryWatchdog.
Each MBlock has an index that tells which MBlockInfo in memoryWatchdog
contains information about the MBlock.

If the memory block contains an OTSO Object,
object_ will point to it 
(to the instance that is constructed first).
**********************************************************************/

class MBlockInfo {
  friend class MBlock;
public:
  void 		set(MBlock* block, size_t s);
                                        //Connect this to 'block' whose size
                                        //is s.  If 'block' is 0,
                                        //this gets disconnected (because
                                        //memory block is deleted),
                                        //and can be used again.
  MBlock*	pointer() const		{return pointer_;}
  sint32	size() const		{return size_;}
  Time		birthTime() const	{return birthTime_;}
  void		setObject(Object* o)	{object_ = o;}
  Object*	object() const		{return object_;}
  void		print(Ostream& os);	//Print one line of memory block list.
  MBlockInfo();
private:
  sint32	ordinal_;
  Type*		otsoType_;		//?
  sint32	size_;
  Time		birthTime_;
  MBlock*	pointer_;		//The MBlock that this describes.
                                        //0 when MBlockInfo not used.
  Object*	object_;
  static MBlock* smallestPointer;
  static MBlock* biggestPointer;
};

/**********************************************************************
Part of the implementation of free store memory debugging services.
memoryWatchdog points to an instance of MBlockInfoArray.
It is allocated automatically in the initialization of OTSO,
if DEBUGGING_FREE_STORE_MEMORY.
From the application programmer's point of view,
the commonly used services are defined in class MemoryDebugging.

In the printed list of memory blocks, the column '(Contained Object)'
tells the className of the first instance of a (derived) OTSO Object
class that is constructed within the allocated memory block.
The class does not necessarily fill the whole block, so for example
a 100-byte block containing a String "hello" means that the 100-byte
block is not derived from Object, but it has a String data member
and some other data members, Objects or non-Objects.

.SH BUGS
Memory consumption of array_ is "semi-dynamic": 
array_ may get bigger in newIndex(),
but it never gets smaller in deleteIndex().

This implementation is not 100% reliable, but in most cases it is
quite useful.
**********************************************************************/

/*implementation*/ class MBlockInfoArray: public MemoryDebugging { public: DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MBlockInfoArray); operator MemoryDebuggingPtr(); private: 
  friend void operator delete(void*);
public:
  redefined MemoryDebugging_interface;

  void		printBlocksAllocatedBetween(Ostream& os, 
					    Time start, 
					    Time stop,
					    char* heading);
                                        //Print to 'os' 'heading' and
                                        //info of memory blocks
                                        //allocated but not deleted 
                                        //after 'start' and before 'stop'.
  void 		print(Ostream& os);	//Print to 'os' blocks allocated
                                        //but not deleted since system
                                        //start.
  sint32	numberTrapped()	const	{return numberTrapped_;}
  sint32	size() const		{return arraySize_;}
  MBlockInfo&	operator[](sint32 i)	{return array_[i];}
  void		incTotalSize(sint32 i)	{totalSize_ += i;}

  static void*	malloc(size_t s);	
  static void	free(void* p);		

  sint32	newIndex();		//Select and return a free index 
                                        //in array_.  Resize array_ if 
                                        //necessary.
  void		deleteIndex(sint32 index);
                                        //Tell that the memory block
                                        //corresponding to 'index' is deleted,
                                        //and the MBlockInfo is free to be
                                        //used again.
  void*		operator new(size_t s); //Global ::operator new() uses a free 
                                        //store instance of this class.
                                        //Therefore special new() and delete()
                                        // operators are needed here.
                                        //They use directly the C library 
                                        //memory allocation functions 
                                        //::malloc() and ::free().
  void		operator delete(void*p);//See MBlockInfoArray::new().
  MBlockInfoArray();
public:
  boolean	warnAboutDelete0;	//When true, a warning is printed
                                        //delete() argument is 0.
                                        //0 argument for delete() is perfectly
                                        //legal: delete() does nothing, but
                                        //you may wish to avoid the extra
                                        //time spent by calling delete(0).
  boolean	showNewAndDelete;	//When true, trace is printed
                                        //at every new and delete
                                        //operation.  Verbose!
private:
/*$OTSO_OFF*/
  MBlockInfo*	array_;
  static const sint32	minimumBlockNumber;
  sint32	arraySize_;		//number of elements allocated
  sint32	slotsInUse_;		//number of elements used currently
  sint32	totalSize_;		//sum of free store memory block sizes
  sint32	current_;		//probably the 1st free slot;
                                        //speeds up the search for a free slot
  Time		startingTime_;
  Time		stoppingTime_;
  sint32	numberTrapped_;		//If 0, no block is trapped.

  void		resizeArray(sint32 newSize);		//
/*$OTSO_ON*/
}; DECLARE_OTSO_PAED_FOR(MBlockInfoArray); 

extern MBlockInfoArray* memoryWatchdog;

#endif	/* DEBUGGING_FREE_STORE_MEMORY */
#ifndef MBlock_OTSO_HXX
#define MBlock_OTSO_HXX
/*This class should not be used; it only assists the OTSO prepro.*/
class MBlockInfoArrayPtr {
public:
  MBlockInfoArrayPtr(MBlockInfoArray*,Object*);
};

#endif
