/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.dyndir.hxx
 * Vers: 5.2    Time: 92/08/03, 15:41:51
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILE
*	dyndir.hxx - dynamically changable directory
**********************************************************************/


/**********************************************************************
DynDir is a list of Named Objects, instances of class NamedObj.
NamedObjs can be inserted here, and the pointer can be gained by
giving a name.

The external pointer 'namedObjs' is OTSO's pointer to a 
directory of NamedObjs with names.  
There is one namedObjs in each operating system process.
It is used to find a pointer to
a NamedObj, when the name is known. 'namedObjs' is defined in dyndir.cxx

A name is given to an namedObj by NamedObj::setName(...).
It causes the NamedObj instance to be inserted to namedObjs.
dout << *::namedObjs;  can be used to print out the current list of
named objects OTSO knows about.

.SH BUGS
Awfully slow.

.SH MODIFICATIONS
**********************************************************************/

class DynDir : public VoidFifo          //Implementation reuse only;
                                        //public because conversion from
                                        //this to Object* needed.
{
public:
  NamedObj*  pointer(String& name);	//Returns pointer to a NamedObj 
                                        //that has the
                                        //given name; 
                                        //dummyNamedObj if not found.
  void*	     servicePointer(String spName, String serviceName, Object*& sp);
                                        //Returns a pointer to the 
                                        //'serviceName' part of 'spName' 
                                        //object.  Class of 'spName' should be 
                                        //derived from the interface class
                                        //'serviceName'.  At exit, sp will
                                        //point to the Object part of 'spName'.
                                        //If 'spName' does not exist, or if
                                        //it does not provide 'serviceName',
                                        //0 is returned.
                                        //Wildcards not ok in arguments.
  void	     insert(NamedObj* o);	//Inserts o into this so that
                                        //pointer(o->name()) will return o.
                                        //If this already has an object
                                        //with the same name as o, the old one
                                        //will be removed from this.

  virtual void selectElementsWithMember(String memberName, Group& q);
                                        //Iterates through the elements of this
                                        //and puts those elements that have
                                        //a member with the name 'memberName'
                                        //into q.  In general, memberName
                                        //is a name of an interface class.
                                        // *this is not changed.
                                        //Wildcards not ok in 'memberName'.
                                        //
                                        //Should be declared in Group??

  void 	     print(Ostream&);  		//print out '(', list of NamedObj Names
                                        //separated by space, and ')'.
  String     className() const;
};

extern DynDir *namedObjs; /* a list of NamedObjs */

