/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/include/cvopshdr/SCCS/s.frame.typ
 *  Version:	1.3
 *  Time:	92/08/13, 11:44:38
 *
 **************************************************************/

/***************************************************************
* NAME
*    frame.typ
*
* PURPOSE
*    To define the abstract data types used in the type FRAME.
*    FRAME is defined in exttypes.typ in CVOPS, but there are
*    too many extraneous CVOPS definitions there for DVOPS to use it.
*    Hopefully this is a bit cleaner ?
***************************************************************/

#ifndef FRAME_TYP
#define FRAME_TYP

/***** Extracts from CVOPS headers ****************************/
#define NULL 0
typedef short INT16;
typedef long  INT32;

#if 0				/* not in public release */
#ifndef DASNTYPES_H
#include "asntypes.h"
#endif
#endif


#define DB_SIZE 128

typedef unsigned char BYTE_TYPE;

typedef struct data_block {
  struct data_block *next;	/* chain of data blocks */
  INT16 size;			/* Max size of this data block */
  INT16 n;			/* number of actual bytes in this data block */
  INT16 i;			/* index of first actual data byte */
  INT16 j;			/* index of last actual data byte */
  BYTE_TYPE *data; 		/* where the actual data bytes live */
} DATA_BLOCK;

typedef struct frame {
  struct frame *next;		/* chain of frames */
  struct data_block *first;	/* first datablock of this frame */
  INT32 length;			/* number of actual bytes in frame */
  INT16 dbSize;			/* max size of data block */
  INT16 saveBytesNr;    	
 } FRAME;

typedef struct mem_block {
  BYTE_TYPE         *mb ;
  struct mem_block  *next ;
  BYTE_TYPE         mb_type ;
} MEM_BLOCK ;

#endif	/* FRAME_TYP */
