/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.bytes.hxx
 * Vers: 5.2    Time: 92/08/03, 15:41:49
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/********************************************************************
* FILE 
*	bytes.hxx
*
* MODIFICATIONS
*     - Bytes(const Bytes& bs, sint32 first, sint32 length = 0x0FFFFFFF):
*	default value 0 of the argument 'first' deleted so that 
*	construction from another Bytes never calls this constructor.
*	This constructor does not make 'bs' empty, while
*	Bytes(Bytes&) makes 'bs' empty!
*	Juha 7.4.92.
********************************************************************/



/****** Byte *******************************************************/

enum Bytes_type { BYT_ASCII, BYT_BIN, BYT_HEX };




typedef uint8 Byte;
				// *MJS* added the following simple inlines.
inline Byte     byte1_2(uint16 u16)     { return (Byte) (u16 >> 8); }
inline Byte     byte2_2(uint16 u16)     { return (Byte) (u16 & 0xFF); }

inline Byte     byte1_4(uint32 u32)     { return (Byte) ((u32 >> 24) & 0xFF); }
inline Byte     byte2_4(uint32 u32)     { return (Byte) ((u32 >> 16) & 0xFF); }
inline Byte     byte3_4(uint32 u32)     { return (Byte) ((u32 >> 8) & 0xFF); }
inline Byte     byte4_4(uint32 u32)     { return (Byte) (u32 & 0xFF); }




extern Byte dummyByte;

/********************************************************************
String is a class for null-terminated printable string manipulation.
Bytes is used to provide a
more general purpose byte-oriented class for use in 
Bytes is not necessarily null-terminated or printable, and may contain NULLs.

The length of a Bytes instance is determined at construction,
so it does not grow or shrink (except in assignment).
Use Frames if you don't know the limit of the size.
If you do know the limit, Bytes should be more efficient than Frame.

Notice that assignment and the "copy" constructor
changes the right hand side argument.  Bytes are moved, not copied!

The number of the first byte is 0.

If the char* used to construct the Bytes class is string of
hex digits ending in 'h/H/x/X' (e.g. "1234567890H"), it is assumed
that it is not an Ascii string, but a hex string and is stored
as the corresponding hex sequence. A string of binary digits '1' '0'
ending in a 'b/B' is assumed to be a bit string and is stored as
a hex byte seqence.  All other strings are assumed to be null-terminated
Ascii strings.

WARNING: The Bytes pointer 'st' points to the least significant byte.
The least significant byte is different for an Ascii string and a
hex/binary string.

.SH EXAMPLES
.nf
    Bytes ascii ("hello");     -- stored as: 68 65 6c 6c 6f 00
    Bytes hex ("1112345x");    -- stored as: 45 23 11 01
    Bytes bin ("0100010101b"); -- stored as: 15 01
                                              ^
                                    Bytes.st -^
.fi

.SH BUGS
Input data argument treated inconsistently in constructors.
********************************************************************/
class Bytes : public Object {

  friend class DYNSTR;			//asn.cxx
protected:
  sint32	sz;		        //length of byte string

protected:
  Bytes_type	btype;	                //Type of string 
                                        //(BYT_OCT, BYT_BIN, BYT_ASCII).
public:
  char		*st;	                //Byte string lives here.
                         		//NOTE: asncodec.cxx needs this 
                                        //to be public; please do not use.

/****************
.SH Manipulating bytes
****************/
  Bytes&	operator= (Bytes& r);	//Remove bytes from r and
                                        //put them to this without copying.
                                        //Warning: not normal assignment.
  Byte&		operator[](sint32 i) const; 
                                        //Returns i'th byte, or dummyByte
					//if i is out of range.
                                        //0 gives the first byte.
  Byte&		elem(sint32 i) const;	//Like [i] but faster because 
					//no range check.
  Bytes		copy();			//make a brand new copy of Bytes.
  void		reset();		//make object empty.

/**************
.SH Conversions
**************/
  sint32 hex2str (char* acsii, uint8* hex, sint32 hexLen);
	                                //bytes to hex Ascii string
  sint32 str2hex (uint8* hex, char* ascii, sint32 asciiLen);
	                                //hex Ascii string to bytes
  sint32 bin2str (char* ascii, uint8* bin, sint32 binLen);
                                  	//bytes to binary Ascii string
  sint32 str2bin (uint8* bin, char* ascii, sint32 asciiLen);
                                   	//binary Ascii string to bytes

/****************
.SH Miscellaneous
****************/
  sint32	length() const 		//Number of bytes.
                                        {return sz;}
  boolean	operator== (const Bytes& r) const;
	                                //True iff all bytes are equal.
                                        //Compared byte by byte,
                                        //eqyal address is not required.
  boolean	operator!= (const Bytes& r) const;
	                                //False iff all bytes are equal.
  Byte*		bytep() const		//Returns a pointer to the beginning of
                                        //the byte array.
                                        {return (Byte*)st;}

/***************
.SH Printing, asking
***************/
  void		print(Ostream& os);	//dout << Bytes;
  void		ask(Istream& is);	//user input of Bytes.
  void		to(ODump& od);		//Channel encoder.
  void		from(IDump& id);	//Channel decoder.
  String	className() const;


  Bytes(sint32 size = 32);	        //The size is determined here. The
                                        //default is more or less arbitrary.
  Bytes(Bytes& i);			//Takes the bytes away from i and gives
                                        //them to this.  No copying.
                                        //Warning: i is changed.
                                        //
  Bytes(const Bytes& bs, sint32 first, sint32 length = 0x0FFFFFFF);
                                        //Construct from bs, or a part of it:
                                        //'length' bytes starting from 
                                        //'first'.  Bytes are copied!
  Bytes(char* string);			//Construct from a NULL terminated
                                        //string.  Strings ending in 
                                        //'x', 'X', 'h', 'H', 'b, or 'B'
                                        //have a special interpretation:
                                        //see the class description above.
 ~Bytes();
};

//See also class Frame.
