ENVFLAGS = -D__OWCCPP__=1	# OWC C++ on a BSD Unix System
##############################################################
# Name: /home/users/otso/official/otso/enviros/makes/SCCS/s.sun.make
# Vers: 5.7    Time: 92/08/07, 12:54:37
#
# Copyright (c) 1992      Technical Research Centre of Finland (VTT)
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that this notice and the reference to this notice appearing in each software
# module be retained unaltered, and that the name of any contributors shall not
# be used in advertising or publicity pertaining to distribution of the software
# without specific written prior permission.  No contributor makes any
# representations about the suitability of this software for any purpose.
# It is provided "as is" without any express or limited warranty.
#
#			NO WARRANTY
#
# ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
# EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
# DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
# OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
# SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
# COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
#
# As used above, "contributor" includes, but is not limited to :
#        The Technical Research Centre of Finland
#############################################################################


###############################################################################
# FILE
#	sun.make
#
# PURPOSE
#	This is a Unix Makefile to compile OTSO for SunOS 4.x
#
# DESCRIPTION:
#	system.make is a logical link (ln -s) made by the user
#	to some system specific file (e.g. sun.make, hpux.make, etc).
#
#	This Makefile is primarily intended to be used with 
#	Cfront based C++ compilers.  Setting for GNU's g++
#	are also available in this Makefile - but haven't
#	been used in a long time.  To use G++, uncomment
#	the proper SETUP section of the Makefile below.
#
#	Also, remember to modify :
#		/otso/enviros/env*.h according to your needs for OTSO
#
#	This makefile is run via a local 'make' shell script that
#	should be defined in local compile directories.  It sets
#	certain globally definable make variables that are used
#	in all OTSO's subdirectories.
#
#	The local 'make' shell script defines TOPDIR, some other variables,
#	targets, etc, and probably uses /bin/make or optionally GNU make.  
###############################################################################


###############################################################################
# OTSO DIRECTORIES
###############################################################################
BINDIR  =       $(TOPDIR)bin/
DINCDIR =       $(ENVDIR)device/include/
ENVDIR  =       $(TOPDIR)enviros/
ETCDIR  =       /usr/etc/
GINCDIR =       $(TOPDIR)include/gend/
HDIR    =       $(TOPDIR)include/
INCDIR  =       $(TOPDIR)include/
CPYUSRINCDIR =	$(TOPDIR)copyright/usr/include/
LIBDIR  =       $(TOPDIR)lib/
LOGDIR  =       /usr/tmp/
LWPINCDIR =     $(TOPDIR)include/lwp/
NMANDIR =       $(TOPDIR)man/mann
PINCDIR =       $(TOPDIR)include/protocols/
TOOLDIR =       $(TOPDIR)tools/
UTILDIR =       $(TOPDIR)util/


###############################################################################
# OTSO-specific INCLUDE FLAGS
###############################################################################
#
# LOCAL_IFLAGS are set inside of the user's Makefile, so they can customize
# insertion of directories before most OTSO include directories.
#
# IFLAGS first includes from "incfirst", then the local directory "." wher
# make is run, then from LOCAL_IFLAGS if set, and finally from the OTSO
# class directories.
#
LOCAL_IFLAGS    =
IFLAGS          = \
-I$(INCDIR)incfirst \
-I$(CPYUSRINCDIR) \
-I. \
-I$(LOCAL_IFLAGS) \
-I$(ENVDIR) \
-I$(DINCDIR) \
-I$(INCDIR) -I$(INCDIR)cvopshdr \
-I$(GINCDIR) \
-I$(LWPINCDIR) \
-I$(SIMUDIR) -I$(AWESIMEDIR) \
-I$(PINCDIR)


###############################################################################
# OTSO LIBRARIES
# - libdvops.a must be linked twice! (linker problem?)
###############################################################################

OTSO_KERNEL     = $(LIBDIR)libdvops.a   $(LIBDIR)libgend.a
OTSO_DEVICES    = $(LIBDIR)libdevbsd.a
OTSO_ENVIRO     = $(LIBDIR)libenviros.a
OTSO_LIBES      = $(OTSO_ENVIRO) $(OTSO_DEVICES) $(OTSO_KERNEL) $(OTSO_SIMU) \
		  $(LIBDIR)libdvops.a


###############################################################################
# OTSO EXECUTABLES/TOOLS/UTILS
###############################################################################
#
# PREPRO	- OTSO minicompiler : handles OTSO extensions to C++
# PPP		- simple preprocessor/filter sometimes needed with prepro
# PREPRO_CLEAN	- Sometimes we need to post-process prepro output.  For
#		  example, for SUN's /bin/cc we sometimes need to strip
#		  out the #line comments or it core dumps for big files:
#		  e.g.	PREPRO_CLEAN = sed -e 's/\#line/\/\/\#line/'
#
#
PREPRO		=	$(BINDIR)prepro
PPP		=	$(BINDIR)ppp
PREPRO_CLEAN	=

#
# Abstract Syntax Notation One (ASN.1) prototype
# compiler integrated into OTSO development system
#
CLASN           =       $(BINDIR)clasn



###############################################################################
# %%%%%% COMPILER SETUPS %%%%% - UNCOMMENT ONLY ONE SETUP BELOW !!!
###############################################################################


############################################################################
# BEGIN COMPILER SETUP A - UNCOMMENT THESE TO USE CFRONT STYLE COMPILERS
############################################################################
#
# You must set ENVFLAGS to one of the following, the default is
# to use ObjectWorks C++  on a BSD UNIX system.  Use only one,
# comment out the rest. Check first line of Makefile first !
#
#ENVFLAGS = -D__OWCCPP__=1	# OWC C++ on a BSD Unix System
#ENVFLAGS = -D__SUNCPP__=1	# SUN C++ on a BSD Unix System

#
# It is assumed that you have defined a command shell script 'CC'
# that runs cfront in your path. Otherwise hardcode the path
# to CC here.
#

NICE	=	/usr/bin/nice -5

CC	=	$(NICE) /usr/local/bin/gcc
CFLAGS	=	$(DEBUG_FLAGS)

CXX_COMMENT =	CC-gcc-hack
DEBUG_FLAGS =	-g
CXX	=	$(NICE) $(TOPDIR)util/CC $(CXXFLAGS)
CXXFLAGS =	$(DEBUG_FLAGS) $(ENVFLAGS)
CXXIFLAGS =	-I/usr/owc/include

CPP	=	/usr/lib/cpp

LDXX	=	$(NICE) $(TOPDIR)util/CC
LD	=	$(NICE) $(TOPDIR)util/CC
LDFLAGS =

QUIET_CXX =	$(CXX)
CXX_CLEAN = 	-@rm -f
#CXX_CLEAN = 	touch

##########################################################################
# END COMPILER SETUP A - UNCOMMENT THESE TO USE CFRONT STYLE COMPILERS
##########################################################################


##########################################################################
## BEGIN COMPILER SETUP B - UNCOMMENT THESE TO USE G++
##########################################################################
#
##########################################################################
## GNU, GCC, G++ Compiler definitions
#########################################################################
#
#OSFLAG =
#OSLDFLAG =
#
#GNUPREFIX =	/usr/local/
#GNULIBDIR =	$(GNUPREFIX)lib/
#GNUBINDIR =	$(GNUPREFIX)bin/
#GXX =		g++
#
#LDXX =		$(GNULIBDIR)/gcc-ld 
#
##crt1+.o location , for dynamic testing
#GXXCRT1 = 	$(GNULIBDIR)/crt1+.o
#
##
## Other compilation flags, modify as you like:
##
#GXX_OPTIMIZATION_FLAGS = \
#	-O -fstrength-reduce -felide-constructors -fschedule-insns \
#	-fdelayed-branch -fsave-memoized  -fwritable-strings
#
#GCC_OPTIMIZATION_FLAGS = -O -fstrength-reduce -fdelayed-branch 
#
#DEBUG_FLAGS = -g
#
##use this if you like verbose meaningless messages
#VERBOSITY_FLAGS = -Wall # -v
#
#GXXINCDIR = $(GNULIBDIR)g++-include
#GCCINCDIR = $(GNULIBDIR)gcc-include
#
#PIPE_AS = -pipe
#
##Flags for all C++ compiles
#GXXFLAGS = \
#	$(OSFLAG) -I$(GXXINCDIR) -I$(GXXINCDIR)/sys $(DEBUG_FLAGS) \
#	$(GXX_OPTIMIZATION_FLAGS) $(VERBOSITY_FLAGS) $(PIPE_AS)
#
##Flags for all C compiles
#GCCFLAGS = \
#	$(OSFLAG) -I$(GCCINCDIR) $(DEBUG_FLAGS) $(GCC_OPTIMIZATION_FLAGS) \
#	$(VERBOSITY_FLAGS) $(PIPE_AS)
#
##g++ load time flags
#GXXLDFLAGS = -lg++ -lm $(OSLDFLAG) 
#
##these flags tell where ld++ and crt1+.o are
#TFLAGS = -DLDXX=\"$(LDXX)\" -DCRT1X=\"$(GXXCRT1)\"
#
#CC	=	gcc
#CFLAGS	=	$(GCCFLAGS)
#
#CXX	=	$(GXX) $(CXXFLAGS)
#CXXFLAGS =	$(GXXFLAGS) $(ENVFLAGS)
#
#CPP	=	/usr/lib/cpp
#
#LDXX	=	$(NICE) $(GXX) $(GXXLDFLAGS)
#LD	=	$(LDXX)
#LDFLAGS =
#
#QUIET_CXX = $(CXX)
##QUIET_CXX =	@echo; echo; \
#		echo system/system.make : $(CXX) compiling \"$*.cxx\"; \
#		$(NICE) $(CXX)
#
## $(CXX) can produce really long messages during g++ compilation,
## QUIET_CXX run $(CXX), but prints only a short message.
## Uncomment FIRST QUIET_CXX to see flags, etc used during compilation.
#
########################################################################
## END COMPILER SETUP B - UNCOMMENT THESE TO USE G++
########################################################################

###############################################################################
# %%%%%% COMPILER SETUPS %%%%% - UNCOMMENT ONLY ONE SETUP ABOVE !!!
###############################################################################




###############################################################################
# Programs and Libraries
###############################################################################

CONFIG	=	bsd
# used in other makefiles as the sub
# directory, eg for device/Makefile
# so it knows to run device/bsd/Makefile


# used in util/make-lib.sh - archives .o's into .a's
SYSTEM	=	-bsd42
MANOPTS	=	-bsd42
ARFLAGS =

#INSTALL	=	install -c
#INSTALL	=	cp

INSTALL	=	$(LN)
LEX	=	lex
LINT    =	lint
LN	=	ln
MAKE	=	./make $(MFLAGS) -k
RANLIB	=	ranlib
SHELL	=	/bin/sh
YACC	=	bison




###############################################################################
# General cleanups for target clean.
###############################################################################

CLEANSTRINGS = 	*.o *.a core *.old *.tmp *.i *.ixx *.log *.exe *~ \
		version.major version.minor version.local *.cyi *vrsn.c \
		tmpa.* ,* \#*\#
		


###############################################################################
# Generation Rules for OTSO library modules
###############################################################################

#
# clasn note: clasn may exit with a non-zero error code for WARNINGS only.
# modify casnmod.c if this bites you.  currently if clasn returns 1 warning
# there is no problem, >1 warning causes an exit(1) which halts make.
#

.SUFFIXES: .cxx .cc .cx .hx .hxx .asn .hxpp .n .ixx

.c.o:;		$(CC) $(IFLAGS) $(CFLAGS) -c $*.c

.cc.o:;		$(QUIET_CXX) $(IFLAGS) -c $*.cxx
		$(CXX_CLEAN) $*.cyi

.cxx.o:;	$(QUIET_CXX) $(IFLAGS) -c ./$*.cxx
		@$(CXX_CLEAN) $*.cyi
		

.asn.hxpp:;	@cat /dev/null > ./$*.hxpp
		$(CLASN) -CVOPS=3 ./$*.asn

.hxpp.hx:;	@cat /dev/null > ./$*.hx
		$(CPP) -P $*.hxpp | $(PPP) > ./$*.hx
		@rm  $*.hxpp

.asn.cx:;	@cat /dev/null > ./$*.hxpp
		$(CLASN) -CVOPS=3 ./$*.asn
		@cat /dev/null > ./$*.hx
		$(CPP) -P $*.hxpp | $(PPP) > ./$*.hx
		@rm  $*.hxpp

.asn.hx:;	@cat /dev/null > ./$*.hxpp
		$(CLASN) -CVOPS=3 ./$*.asn
		@cat /dev/null > ./$*.hx
		$(CPP) -P $*.hxpp | $(PPP) > ./$*.hx
		@rm  $*.hxpp

.hx.hxx:;	@cat /dev/null > ./tmpa.hxx
		$(PREPRO) $*.hx < ./$*.hx > ./$*.hxx
		@if [ "$(PREPRO_CLEAN)" != "" ]; then\
			mv $*.hxx $*.hxxtmp;\
			$(PREPRO_CLEAN) $*.hxxtmp > ./$*.hxx;\
			rm $*.hxxtmp;\
		fi
		@cat ./tmpa.hxx >> ./$*.hxx
		@rm ./tmpa.hxx

.asn.hxx:;	@cat /dev/null > ./$*.hxpp
		$(CLASN) -CVOPS=3 ./$*.asn
		@cat /dev/null > ./$*.hx
		$(CPP) -P $*.hxpp | $(PPP) > ./$*.hx
		@rm  $*.hxpp
		@cat /dev/null > ./tmpa.hxx
		-$(PREPRO) $*.hx < ./$*.hx > ./$*.hxx
		-@if [ "$(PREPRO_CLEAN)" != "" ]; then\
			mv $*.hxx $*.hxxtmp;\
			$(PREPRO_CLEAN) $*.hxxtmp > ./$*.hxx;\
			rm $*.hxxtmp;\
		fi
		@cat ./tmpa.hxx >> ./$*.hxx
		@rm ./tmpa.hxx
		@rm  $*.hx

.asn.cxx:;	@cat /dev/null > ./$*.hxpp
		$(CLASN) -CVOPS=3 ./$*.asn
		@cat /dev/null > ./$*.hx
		$(CPP) -P $*.hxpp | $(PPP) > ./$*.hx
		@rm  $*.hxpp
		@cat /dev/null > ./tmpa.cxx
		@cat /dev/null > ./tmpa.hxx
		@cat /dev/null > ./tmpa.enu
		-$(PREPRO) $*.hx < ./$*.hx > ./$*.hxx
		$(PREPRO) $*.cx < ./$*.cx > ./$*.cxx
		-@if [ "$(PREPRO_CLEAN)" != "" ]; then\
			mv $*.hxx $*.hxxtmp;\
			mv $*.cxx $*.cxxtmp;\
			$(PREPRO_CLEAN) $*.hxxtmp > ./$*.hxx;\
			$(PREPRO_CLEAN) $*.cxxtmp > ./$*.cxx;\
			rm $*.hxxtmp $*.cxxtmp;\
		fi
		@cat ./tmpa.hxx >> ./$*.hxx
		@cat ./tmpa.cxx ./tmpa.enu >> ./$*.cxx
		@rm ./tmpa.hxx ./tmpa.cxx ./tmpa.enu
		@rm  $*.cx

.asn.o:;	@cat /dev/null > ./$*.hxpp
		$(CLASN) -CVOPS=3 ./$*.asn
		@cat /dev/null > ./$*.hx
		$(CPP) -P $*.hxpp | $(PPP) > ./$*.hx
		@rm  $*.hxpp
		@cat /dev/null > ./tmpa.cxx
		@cat /dev/null > ./tmpa.hxx
		@cat /dev/null > ./tmpa.enu
		-$(PREPRO) $*.hx < ./$*.hx > ./$*.hxx
		$(PREPRO) $*.cx < ./$*.cx > ./$*.cxx
		-@if [ "$(PREPRO_CLEAN)" != "" ]; then\
			mv $*.hxx $*.hxxtmp;\
			mv $*.cxx $*.cxxtmp;\
			$(PREPRO_CLEAN) $*.hxxtmp > ./$*.hxx;\
			$(PREPRO_CLEAN) $*.cxxtmp > ./$*.cxx;\
			rm $*.hxxtmp $*.cxxtmp;\
		fi
		@cat ./tmpa.hxx >> ./$*.hxx
		@cat ./tmpa.cxx ./tmpa.enu >> ./$*.cxx
		@rm ./tmpa.hxx ./tmpa.cxx ./tmpa.enu
		@rm  $*.hx
		@rm  $*.cx
		$(QUIET_CXX) $(IFLAGS) -c $*.cxx 
		$(CXX_CLEAN) $*.cyi

.cx.cxx:; 	@cat /dev/null > ./tmpa.cxx
		@cat /dev/null > ./tmpa.hxx
		@cat /dev/null > ./tmpa.enu
		-$(PREPRO) $*.hx < ./$*.hx > ./$*.hxx
		$(PREPRO) $*.cx < ./$*.cx > ./$*.cxx
		-@if [ "$(PREPRO_CLEAN)" != "" ]; then\
			mv $*.hxx $*.hxxtmp;\
			mv $*.cxx $*.cxxtmp;\
			$(PREPRO_CLEAN) $*.hxxtmp > ./$*.hxx;\
			$(PREPRO_CLEAN) $*.cxxtmp > ./$*.cxx;\
			rm $*.hxxtmp $*.cxxtmp;\
		fi
		@cat ./tmpa.hxx >> ./$*.hxx
		@cat ./tmpa.cxx ./tmpa.enu >> ./$*.cxx
		@rm ./tmpa.hxx ./tmpa.cxx ./tmpa.enu

.cx.o:;		@cat /dev/null > ./tmpa.cxx
		@cat /dev/null > ./tmpa.hxx
		@cat /dev/null > ./tmpa.enu
		-$(PREPRO) $*.hx < ./$*.hx > ./$*.hxx
		$(PREPRO) $*.cx < ./$*.cx > ./$*.cxx
		-@if [ "$(PREPRO_CLEAN)" != "" ]; then\
			mv $*.hxx $*.hxxtmp;\
			mv $*.cxx $*.cxxtmp;\
			$(PREPRO_CLEAN) $*.hxxtmp > ./$*.hxx;\
			$(PREPRO_CLEAN) $*.cxxtmp > ./$*.cxx;\
			rm $*.hxxtmp $*.cxxtmp;\
		fi
		@cat ./tmpa.hxx >> ./$*.hxx
		@cat ./tmpa.cxx ./tmpa.enu >> ./$*.cxx
		@rm ./tmpa.hxx ./tmpa.cxx ./tmpa.enu
		@#to overcome cpp core dump, #line directives must be stripped
		@#$(QUIET_CXX) $(IFLAGS) -c -F $*.cxx | grep -v "^#" > $*.c 
		@#cc $(IFLAGS) -c $*.c
		$(QUIET_CXX) $(IFLAGS) -c ./$*.cxx 
		@$(CXX_CLEAN) $*.cyi
		@#rm $*.c

#.hxx.n:;	$(PREPRO) $*.hxx s < ./$*.hxx | $(PREPRO_CLEAN)  > /dev/null
.hxx.n:;	$(PREPRO) $*.hxx s < ./$*.hxx  > /dev/null
		mv doc.man $(NMANDIR)/$*.n

# @t - produces .c file from .cxx in Glockenspiel C++ compiler

#cpp only
.cxx.ixx:;	$(CXX) $(IFLAGS) -E -.ixx ./$*.cxx 

#cpp and cfront
.cxx.c:;	$(CXX) $(CXXFLAGS) $(IFLAGS) -F ./$*.cxx  > $*.c
