/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.envOTSO.h
 * Vers: 5.6    Time: 92/09/14, 10:30:05
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef ENVOTSO_H
#define ENVOTSO_H



/*
*/

#ifndef TRUE	/* Prevent conflict with CVOPS general.def */
static const boolean false = (1==0);
static const boolean true = (1==1);
#  define TRUE	(1 == 1)
#  define FALSE (1 == 0)
#else
   /* ignore CVOPS definition of true and false */
#  undef true
#  undef false
static const boolean false = (1==0);
static const boolean true = (1==1);
#endif

/* --------------- #DEFINES ----------------- */
/* use 'redefined' in derived classes when
   redefining (reimplementing) a virtual function */

#define redefined	/* OTSO keyword: empty, not used by any tool  */
#define async	void	/* OTSO keyword */

#define ASN1			/* OTSO Keyword: comment for prepro */
#define ASN_COMPILED	1	/* Nokia ASN compiler */

#ifndef ANSI_C
#define ANSI_C 1
#endif

#if ANSI_C
#  define ARGS(s) s
#else
#  define ARGS(s) ()
#endif


/* Simulation settings */
/**********************************************************************
1 means that simulation and other applications can be compiled,
but the executable is not as efficient as it were without
support for simulation features.  So use 0 when optimizing time efficiency
in other than simulation applications.

Currently, all of the following 3 switches must be either on or off.

SIMULATING must be 0 in HPUX, because light-weight processes are
not supported there.

IMPORTANT: If you modify these flags
 1) then edit enviros/makes/env_simu.make, 
 2) and then run `make config-<arch>` afterwards
**********************************************************************/ 

#define SIMULATING	0	/* *MJS* changes for simulation */
#define STATISTICS	0	/* and statistics gathering. */
#define TRACING		0	/* 0 = off, 1 = on */

/**********************************************************************
OTSO_DEBUGGING should be used at development time.  Extra checks etc.
that are not really needed in the final product should be compiled
only if OTSO_DEBUGGING is on.

DEBUGGING_FREE_STORE_MEMORY assists in detecting missing or wrong deletes. 
It redefines the global new and delete operations.
Currently not supported in HPUX!
*********************************************************************/

#define OTSO_DEBUGGING	1
#define DEBUGGING_FREE_STORE_MEMORY 0


/**********************************************************************
  Do not edit these (unless you change OTSO code to support these features
  in HPUX)!
**********************************************************************/

#if __hpux
#define SIMULATING      0
#define STATISTICS      0
#define TRACING         0
#define DEBUGGING_FREE_STORE_MEMORY 0
#endif  /*__hpux*/


#endif  /* ENVOTSO_H */
