/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.envOS.cxx
 * Vers: 5.4    Time: 92/09/10, 10:58:49
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)envOS.cxx	5.4 92/09/10";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/************************************************
*  NAME
*	envOS.cxx (SunOS)
*
*  PURPOSE
*	aliases for Host Operating System specfic things
*
*  DESCIRIPTION
*	systart() is an example of an OTSO function that can be
*	Host Operating System specific.  systart() is called when
*	a physical OS process for OTSO is started.  It should be
*	used for things like catching UNIX/MSDOS signals and handling
*	them gracefully.   Things like system time, must also be aliased
*	in some way.
*
*	This file currently provides support for UNIX (especially
*	BSD Unix systems) and for MSDOS.  Add support for new OS's
*	here and envOS.h, etc.
*
*	boolean initOTSO() :
*	- initialize the OTSO system (from user's main()).
*	- create and initialize certain global OTSO objects.
*
*	systart() :
*	- systart catches certain signals and longjmp's and exits gracefully
*	  for them (no core dump).  This allows OTSO trace/log files
*	  be written and closed.
*	- the only current signal that is caught is a user interrupt
*	  <BreakKey> and the only longjmp that is currently caught is from
*	  CASN generated files.  ??? There is no graceful way to
*	  recover from this type longjmp ???
*	- although systart catches longjmps, it simply exits on them.
*	  If you wish more intelligent action to be taken, then you
*	  must implement your own handler for them, and your own call
*	  to setjmp.
*
*	systop() :
*	- is used to shut down or exit an Operating System Process.
*	It should flush and close open files, free shared memory/devices,
*	etc. and, in general, do any necessary clean up.
*
*	systime() :
*	- people should try to use the variable global_sys_time
*	  instead of calls to systime() where it is feasible, (e.g.
*	  in non-precise logging error messages).
*
*	Process::select() :
*	- sort of an alias or a stub for a BSD-style select.
*
*  MODIFICATIONS
*	24.7.91 - EOJ modified it for MSDOS compatibility
*
*************************************************/


#ifndef OTSO_HXX
# include "OTSO.hxx"		/* common OTSO parts */
#endif


/*
 *  Common initialization function for OTSO's main() section.  Almost
 * all used variables are globals. Certain variables and objects
 * are created and/or initialized.
 */

void startupOTSO() {
  if (::initOTSO() == false) {
    ::systop();
  }
}

boolean
initOTSO ()
{

  /*
   * The Runner constructor uses the external objects 'scheduler' and
   * 'globals'.  Therefore, they must be created before any runners (e.g.
   * Istream) are created.
   */
  ::globals = new Globals;

  if (::scheduler == NULL) {
      /* User may have created their own scheduler.  We shouldn't delete it. */
      ::scheduler = new Scheduler;
  }
  scheduler->schedules(scheduler);	//?, must be something

#if BSD
  /*
   * Device constructors currently enter themselves into a single global
   * device table (pGlobalDevices).  So the global Device table must be
   * created before any Devices, Streams, etc are constructed.
   */
  ::pGlobalDevices = new DeviceTable;
#else
  ::pGlobalDevices = NULL;
#endif


  ::otsoProcesses = new DynDir;


  /*
   * Dummy Objects: These are some external objects that are used for various
   * reasons in otso.  Sometimes a function may need to return a reference to
   * a runner, for example.  It is not possible to return a NULL pointer by
   * default in such cases, so dummy objects declared here are used instead.
   */
  ::namedObjs = new DynDir;
  ::dummyNamedObj = new NamedObj;

  //dummyNamedObj -> setName ("dummyNamedObj");

  ::dummyFrame = new Frame;


  /*
   * Create OTSO System's Streams : (dout, din, dlog) din corresponds roughly
   * to cin. likewise dout and cout, ...
   */
  ::dinStack = new VoidLifo;

#if BSD

  /*
   * In BSD Unix, we create the Istream from an OTSO Device. This allows the
   * OTSO Device Table to watch it for asynchronous events, like user input.
   * The input Istream (din) is constructed from this OTSO device. The
   * Istream is tied to an Ostream (similar to cin and cout.  White space is
   * skipped.
   */

#if 1
				        //static/free store variables needed,
				        //because din/dout exist until exit()
  static char tab[99];				//?
  static Filebuf doutFilebuf(1, tab, 20);	//1?, tab?
  static ostream doutStream0(&doutFilebuf);
  doutStream = new Ostream(doutStream0);
  ::warningStream = ::errorStream = doutStream;	
               
#else	/*old*/
  doutStream			= new Ostream (cout); 
  ::warningStream = ::errorStream = new Ostream(cerr);
#endif

#if 1
  static Filebuf dinFilebuf(0);		//cin
  static istream dinStream0(&dinFilebuf);
  File_Device* userInputDevice	= new File_Device (0, ev_read, "stdin");
  dinStream			= new Istream (dinStream0,
                                               userInputDevice,
			 	               /*tie*/ doutStream,
	                                       /*skip*/ 1 
                              	  );
#else	/*old*/
  File_Device* userInputDevice	= new File_Device (0, ev_read, "stdin");
  ::dinStream			= new Istream (userInputDevice,
			 	     /*tie*/ doutStream, /*skip*/ 1 
                              	  );
#endif

#else
  ::doutStream = new Ostream (cout);
  ::dinStream = new Istream (cin);
  ::warningStream = errorStream = new Ostream (cerr);
#endif


	  //Turn on log tracing of input and output streams.
  dout.outputLogging("otso.log", true);	
  dout.logOutputToFile(true);

          //Make some objects visible for the OTSO command interpreter (?)
  doutStream->setName("*doutStream");
  ::scheduler->setName("*scheduler");
  ::otsoProcesses->setName("*otsoProcesses");


    /**********************************************************************
     * Externals from envOTSO.cxx for starting/stopping OTSO processes.
     * systart() and systop() are used for things like catching certain UNIX
     * signals (e.g. Interrupt) and exiting cleanly (e.g. flushing log file
     * output, etc).
     **********************************************************************/
  ::otsoIsExiting = false;
#if BSD || MSDOS
  ::systart ();
#endif

  if (::otsoInitializationErrors) {
    dout << "Errors detected in initialization:\n\n" 
         << *::otsoInitializationErrors << "\n";
    dout.flush();
    delete ::otsoInitializationErrors;
  }

  if (!otsoType_Istream) {
    OTSO_ERROR("otsoType_Istream == 0, initialization failed (global objects not constructed?)");
  }

  return true;
}

#if BSD	|| MSDOS

/* OTSO environment for setjmp, longjmp */

/* extern */ jmp_buf glb_environment;


extern "C" {
  void signal (int, void (*) ());	/* Unix-like signal handler c-library */
}


void systop () {
  ::otsoIsExiting = true;	//Other threads will check this variable
                                //and terminate.
  dout.flush();
  cerr.flush();
  if (dout.logger) dout.logger->flush();
  if (dinStream->logger) dinStream->logger->flush();

  exit (0);			//Goodbye cruel world
}

void
systart ()
{
  int jumped = 0;

  (void) ::systime ();		/* initialize ::global_sys_timer */

  /* catch signals */
  ::signal ( /* SIGINT */ 2, ::systop);

  /* catch longjmp's */
  if (jumped = ::setjmp (glb_environment)) {

    if (jumped != 0)
      cerr << "Error: longjmp=" << jumped << " occurred\n";

    if (jumped >= 120 && jumped <= 132)
      cerr << "ASN ERROR: check general.def longjmp code\n";

    exit (1);
  }
  else {
    /* do nothing, initial setjmp */
  }
}

#endif

// *MJS* changes - jfr!
Time& systime()
{
  struct timeval  tv;
  static Time     t;

  gettimeofday(&tv, NULL);
  t.setTime((uint32) tv.tv_sec, (uint32) tv.tv_usec);

  return t;
}

#if MSDOS
/* MSDOS */ int
/* MSDOS */ Process::select (int width, fd_set * readFds, fd_set * writeFds,
/* MSDOS */	             fd_set * exceptFds, struct timeval * timeout)
/* MSDOS */ {
/* MSDOS */  return 1;
/* MSDOS */ }
#else
#if BSD

int
Process::select (int width, fd_set * readFds, fd_set * writeFds,
		 fd_set * exceptFds, struct timeval * timeout)
{
  slong tfrag = 0;
#if COMPILER_HPUX
  /* HPUX C++ compiler needs cast of fd_set to an int* */
  int retval =	::select (
		  width, (int*)readFds, (int*)writeFds, (int*)exceptFds, timeout
		);
#else
  int retval = ::select (width, readFds, writeFds, exceptFds, timeout);
#endif	/* !COMPILER_HPUX */

  if (retval == -1) {
    switch (::errno) {
    case EINTR:
      ::systop ();		/* System call interrupted, bailing out */
      break;

    default:			/* what should be do ? */
      break;
    }
  }

#define SHOW_WAITFOR_PROMPT 0
#if SHOW_WAITFOR_PROMPT
  if (retval == 0)
    cout << ".";
  cout.flush ();
#endif

  // *MJS* changes deleted setting of globals->sys_time - jfr!

  return ((int) (retval));	/* should we return sint16 ? */
}

#endif				/* BSD */

#endif				/* MSDOS */
