/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.envCC.h
 * Vers: 5.2    Time: 92/08/03, 15:13:27
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**************************************************************
 * NAME
 *	envCC.h
 * 
 * PURPOSE
 *	Environmental differences between various C++ compilers are
 *	handled for OTSO.
 *
 *	e.g. The definitions of extern "C" system library calls is unique in
 *	many ways to the specific C++ compiler used.  There isn't one
 *	unique standard way defined for every C++ compiler as yet.
 *
 * BUGS
 * 	SUNCPLUS and OWC CPLUS should be very similar as they are
 * 	both AT&T Cfront clones.  Are they identical ?  Should we
 *	use COMPILER_ATT_CFRONT for all of them instead ?
 **************************************************************/

#ifndef ENVCC_H
#define ENVCC_H


/**************************************************************
 * Bjarne Stroustrup's header filenames are the default
 * (OWC, SUN C++, Borland C++ and G++ use them).  At one time
 * some C++ compilers used stream.hxx, this may not be needed
 * anymore.
 **************************************************************/
#define STREAM_HDR	"stream.h"
#define COMPLEX_HDR	"complex.h"
#define GENERIC_HDR	"generic.h"
#define STDARG_HDR	"stdarg.h"
#define VECTOR_HDR	"vector.h"
#define CTYPE_HDR	"ctype.h"
#define STDIO_HDR	"stdio.h"


#if UNIX
# include <iostream.h>
# include <fstream.h>
# include <sys/types.h>
# include <sys/time.h>
# include <sys/uio.h>
#endif

#if MSDOS
# include <iostream.h>
# include <fstream.h>
# include <sys/types.h>
# include <time.h>
# include <stdlib.h>
#endif


#include CTYPE_HDR	/*isspace etc*/

/**********************/
/* External Variables */
/**********************/
#if UNIX || MSDOS
extern int errno;
#endif


/********************************
  Settings across many compilers
 ********************************/

// Warnings for these are annoying //

#if (COMPILER_OWC || COMPILER_SUNCPLUS || COMPILER_HPUX)
# define signed		/* signed */
# define volatile	/* volatile */
#endif


// External "C" System Library functions //

typedef int FileDescriptor;
#if COMPILER_GPLUS
# include <std.h>	/* defines all Unix system calls for g++ */
#endif

#if (COMPILER_SUNCPLUS || COMPILER_OWC)
#  include <libc.h>
#  include <strings.h>
#  include <sysent.h>
#endif

#if (COMPILER_HPUX)
#  include <stdlib.h>
#  include <unistd.h>
#  include <netdb.h>    /* gethost*() */
#endif

////////////////////////////////////////////////////////////////
// NOTE: concat and stringize are not even close to portable :
//
// In general, C compilers want:
//	#define concat(a,b) a/*empty*/b
//	#define stringize(s) "s"
//
// The HPUX C compiler expects the above, but to make life interesting
// the HPUX C++ compiler wants the below :
//
// However GNU g++ and gcc and HPUX C++ want:
//	#define concat(a,b) a ## b
//	#define stringize(s) #s
//
// Theoretically other compilers could want:
//	#define concat(a,b) a\
//	b
// or even the ever popular:
//	#define IDENT(x) x
//	#define concat(a,b) IDENT(a)b
// 
// And finally, Note that there must not be space between comma and the
// 2nd argument in a concat call, e.g. not concat(for, bidden) but
// concat(o,k).
//
// Where are the Marx brothers when you need them ? :-)
//
//////////////////////////////////////////////////////////////////////

#if (COMPILER_GPLUS || COMPILER_BORLANDCPP || COMPILER_HPUX)
#  define concat(a,b)		a ## b
#  define concat3(a,b,c)	a ## b ## c
#  define concat4(a,b,c,d)	a ## b ## c ## d
#  define stringize(s)		#s
#else	/* DEFAULT */
#  define concat(a,b)		a/*empty*/b
#  define concat3(a,b,c)	a/*empty*/b/*empty*/c
#  define concat4(a,b,c,d)	a/*empty*/b/*empty*/c/*empty*/d
#  define stringize(s)	"s"
#endif	/* !(COMPILER_GPLUS || COMPILER_BORLANDCPP) */



// timeval is used in class Globals (object.hxx) and elsewhere. //

#if COMPILER_GPLUS || COMPILER_BORLANDCPP
#  ifndef _TIME_	/* if <time.h> isn't included yet */
   struct timeval {
      long tv_sec;	/* secs */
      long tv_usec;	/* usecs */
   };
#  endif
#endif



/***********************
  Objectworks C++ only
 ***********************/

# if (BSD && COMPILER_OWC) 
  /* BSD Socket select stuff */
  extern "C" {
    int	getsockbyname (int, struct sockaddr*, int*);
    struct hostent * 	gethostbyname (char *name);
    int gethostname (char *name, int namelen);
    int	accept (int, struct sockaddr*, int*);
    int	shutdown (int, int);
  };
# endif	/* BSD */



/*******************
   Borland C++ only
 *******************/
#if COMPILER_BORLANDCPP
  char _FAR * _Cdecl form( char _FAR * ... ); // taken from stream.h ...
  /* 
   * NOTE: you must hack oldstrmh.lib to get the format module (.obj),
   * and link it with OTSO at compile time ...
   */

# include <string.h>	/* strlen(), ... */
#endif



#endif /* ENVCC_H */
