/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/sun/SCCS/s.audio.cxx
 * Vers: 5.2    Time: 92/07/08, 14:33:53
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)audio.cxx	5.2 92/07/08";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/

#include <stream.h>

/*****************************************************
NAME	audio.cxx

PURPOSE	experimental audio device class for sun audio
	device.  Will modify when I have time.

MODIFICATIONS
	I hacked up "sound.c 1.21 89/05/18 SMI" quite a
	bit as the basis of the audio device for sun's." quite a
	bit as the basis of the audio device for sun's.

BUGS	Should have a DVOPS runner class to interact
	with Audio device.
*****************************************************/

#ifndef OTSO_HXX
#include "OTSO.hxx"
#endif
#ifndef AUDIO_HXX
#include "audio.hxx"
#endif

#ifdef DEBUG
#define  DEBUGF(args)  cerr << form args;
#else
#define DEBUGF(args)
#endif

#define TEST_DEVICE    "/dev/audio"
#define SOUNDFILE_CREATE  1
#define SOUNDFILE_APPEND  2
#define ALERT_FILE    "alert.au"
#define NOTIFIER_LOOP_DELAY  50000
#define MODULATION_U_LAW  1
#define MODULATION_A_LAW  2
#define MODULATION_BINARY  3

extern  int  errno;
extern  char  *sys_errlist[];

extern "C" {
#if 0
  int write (int, char*, int);
  int read (int, char*, int);
#endif
  char* getwd(char*);
};

/*********************************************
  Sun Sparc Audio Device functions.
*********************************************/


  /*  These are tables of values to be loaded into various
  * gain registers.
  *
  * Note that for the ger entry for -8db, we use the data
  * sheet value for -7.5db.  The data sheet gives values for
  * -8db which are wrong and produce too much gain.
  */

static  unsigned char ger_table[][2] = {
    0xaa,  0xaa,  /* -10db */
    0x79,  0xac,
    /*0x41,  0x91,*/
    0x31,  0x99,  /* -7.5db */
    0x9c,  0xde,
    0x74,  0x9c,  /* -6db */
    0x6a,  0xae,
    0xab,  0xdf,
    0x64,  0xab,
    0x2a,  0xbd,
    0x5c,  0xce,
    0x00,  0x99,  /* 0db */
    0x43,  0xdd,
    0x52,  0xef,
    0x55,  0x42,
    0x31,  0xdd,
    0x43,  0x1f,
    0x40,  0xdd,  /* 6db */
    0x44,  0x0f,
    0x31,  0x1f,
    0x10,  0xdd,
    0x41,  0x0f,
    0x60,  0x0b,
    0x42,  0x10,  /* 12db */
    0x11,  0x0f,
    0x72,  0x00,
    0x21,  0x10,
    0x22,  0x00,
    0x00,  0x0b,
    0x00,  0x0f,  /* 18db */
};


static  unsigned char gr_gx_table[][2] = {
    0x8b,  0x7c,  /* -18db */
    0x8b,  0x35,
    0x8b,  0x24,
    0x91,  0x23,
    0x91,  0x2a,
    0x91,  0x3b,
    0x91,  0xf9,  /* -12db */
    0x91,  0xb6,
    0x91,  0xa4,
    0x92,  0x32,
    0x92,  0xaa,
    0x93,  0xb3,
    0x9f,  0x91,  /* -6db */
    0x9b,  0xf9,
    0x9a,  0x4a,
    0xa2,  0xa2,
    0xaa,  0xa3,
    0xbb,  0x52,
    0x08,  0x08,  /* 0db */
    0x3d,  0xac,
    0x25,  0x33,
    0x21,  0x22,
    0x12,  0xa2,
    0x11,  0x3b,
    0x10,  0xf2,  /* 6db */
    0x02,  0xca,
    0x01,  0x5a,
    0x01,  0x12,
    0x00,  0x32,
    0x00,  0x13,
    0x00,  0x0e,  /* 12db */
};



void audio_set_ger(int des, int  value) {
  struct  audio_ioctl  tmp;

  DEBUGF(("ger is now %d\n",value));

  if ((value < -10) || (value > 18)) {
    cerr << form( "GER value %d out of range; %d <= GER <=  %d\n", value,0,18);
    return;
  }

  /*  Add 10 to the value to get the index into the table.
   */
  tmp.control = AUDIO_MAP_GER;
  tmp.data[0] = ger_table[value + 10][1];
  tmp.data[1] = ger_table[value + 10][0];

  //if (real_flag) {
  if (ioctl(des,AUDIOSETREG,&tmp) < 0) {
    ::perror("Set REG");
  }
  //}
}


void audio_set_gr(int des, int value) {
  struct  audio_ioctl  tmp;

  DEBUGF(("gr is now %d\n",value));

  if ((value < -18) || (value > 12)) {
    cerr << form( "GR value %d out of range; %d <= GR <=  %d\n", value,0,12);
    return;
  }

  tmp.control = AUDIO_MAP_GR;
  tmp.data[0] = gr_gx_table[value + 18][1];
  tmp.data[1] = gr_gx_table[value + 18][0];

  //if (real_flag) {
  if (ioctl(des,AUDIOSETREG,&tmp) < 0) {
    ::perror("Set REG");
  }
  //}
}


void audio_set_gx(int des, int value) {
  struct  audio_ioctl  tmp;

  DEBUGF(("gx is now %d\n",value));

  if ((value < -18) || (value > 12)) {
    cerr << form("GX value %d out of range; %d <= GX <=  %d\n", value,0,12);
    return;
  }

  /*  We add 18 to get the index into the table, since entry 0 represents
   *  -18db.
   */
  tmp.control = AUDIO_MAP_GX;
  tmp.data[0] = gr_gx_table[value + 18][1];
  tmp.data[1] = gr_gx_table[value + 18][0];

  //if (real_flag) {
  if (ioctl(des,AUDIOSETREG,&tmp) < 0) {
    ::perror("Set REG");
  }
  //}
}

void Audio::Play(char* filename, boolean continuous) { 
  int afd = this->fd();
  int  des=0;
  int  rtn=0;
  char  cbuffer[BUFFER_SIZE];
 
  if (!isPlaying) {
   if ((des = ::open(filename, O_RDONLY, 0)) < 0) {
     return;
   } else {
     isPlaying = 1;
   }
  }

  int wrtn=0, byts=0, qsiz=0;
  while ((rtn = ::read(des, cbuffer,BUFFER_SIZE)) > 0) { 
     DEBUGF(("playing >%s<\n",filename));

     if ((wrtn = ::write(afd, cbuffer, rtn)) < 0) {
       ::perror("Audio write");
     }
    
     dout << "wrote " << int(wrtn) << " audio bytes\n";
     if (continuous != true) break;
  }

  if (rtn <= 0) {
    (void) ::close(des);
    isPlaying = 0;
  }
}

void Audio::Play(Frame& f) { 
  int n=0, afd = this->fd();
  int wrtn=0;

  n = f.length();
  Bytes buf((slong) n);
 
  buf = f.copyBytes(n);
  if ((wrtn = ::write(afd, buf.st, n)) < 0) {
    ::perror("Audio write ");
  }
  dout << "wrote " << int(wrtn) << " audio bytes\n";
}


void buffer_initialize(SoundBuffer& buffer) {

  buffer.size = 0;
  buffer.filename[0] = 0;

  ::bzero(buffer.data, buffer.size);

  if (!getwd(buffer.directory))
    (void) strcpy(buffer.directory, ".");
}


/*  These routines manipulate the soundfile.  As new format are added, these
 *  routines must be enhanced.
 */

void soundfile_write(SoundBuffer& buffer, int mode) {
  int  des;
  int  bytes;
  int  cursor_start, cursor_end;
  char  message[256];

  if (buffer.cursor_1 < buffer.cursor_2) {
    cursor_start = buffer.cursor_1;
    cursor_end = buffer.cursor_2;
  } else {
    cursor_start = buffer.cursor_2;
    cursor_end = buffer.cursor_1;
  }
  if (cursor_start >= buffer.size) {
    return;
  }

  DEBUGF(("write file\n"));

  DEBUGF(("filename is >%s<\n",buffer.filename));

  switch (mode) {

  case SOUNDFILE_CREATE:
    if (access(buffer.filename,F_OK) == 0) {
     // if (message_confirm(
     //     "Existing file will be overwritten",ALERT_FILE)
     //     == 0) {
     //   return;
     // }
    }

    if ((des = ::open(buffer.filename,O_WRONLY | O_CREAT | O_TRUNC,
        0666)) < 0) {
      (void) sprintf(message,"Can't open '%s' (%s).",buffer.filename,
          sys_errlist[errno]);
      //message_display(message,ALERT_FILE);
      return;
    }
    break;

  case SOUNDFILE_APPEND:
    if ((des = ::open(buffer.filename,O_WRONLY | O_CREAT | O_APPEND,
        0666)) < 0) {
      (void) sprintf(message,"Can't open '%s' (%s).",buffer.filename,
          sys_errlist[errno]);
      //message_display(message,ALERT_FILE);
      return;
    }
    break;

  default:
    cerr << form("Unknown mode %d\n",mode);
    (void) ::close(des);
    return;
  }

  bytes = cursor_end - cursor_start;
  if (bytes <= 0) {
    //message_display("Nothing to write.","");
    (void) ::close(des);
    return;
  }

  if (::write(des,&buffer.data[cursor_start],bytes) < bytes ||
    ::close(des) < 0) {
    (void) sprintf(message,"Can't write '%s' (%s).",buffer.filename,
        sys_errlist[errno]);
    //message_display(message,ALERT_FILE);
  }
}


/*
 * Misc. utility functions
 */

static nap(int usec) {
  struct timeval timeout;
  timeout.tv_sec = 0;
  timeout.tv_usec = usec;
  (void) select(0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &timeout);
}


/************* Class Audio ************/
Audio::Audio() {

  this -> audio_open();
  ::buffer_initialize(this -> buffer);

  /* i/o data frames */
  this -> recording = 0;
  this -> playing = 0;
  this -> InputVolume(12);
  this -> OutputVolume(26);
}

Audio::~Audio() {
  (void) this -> audio_close();
}

void Audio::Record(char* filename) {}

void Audio::Record(Frame& data) { 
  int afd = this->fd();
  Bytes buf((slong)BUFFER_SIZE);
 
  if (data.length() > 0) {
    data.reset();
  }
  if (::read(afd, buf.st, BUFFER_SIZE) < 0) {
    ::perror("Audio write");
  } else {
    data.putPrefix(buf);	// move bytes to Frame
  }
}

void Audio::Pause() {}

void Audio::Stop() {}

void Audio::Rewind(unsigned nbytes) {}

void Audio::Cue(unsigned nbytes) {}

void Audio::OutputVolume(int level) {
  //////////////////////////////////////////////////////
  // The output volume can be controlled by the GR and
  // GER registers.  To get a greater range of control,
  // both registers are used.  The output volume level
  // is a sum of GR and GER.
  //////////////////////////////////////////////////////
  int gr=0, ger=0;

  ger = level/2;
  gr  = level - ger;

  if (ger < -10) { ger = -10;  gr = level - ger; }
  if (gr > 12)   {  gr =  12; ger = level - gr; }
  audio_set_gr (fd(), gr);
  audio_set_ger(fd(), ger);
}

void Audio::InputVolume(int level) {
  audio_set_gx(fd(), level);
}

int Audio::audio_close() {
  int des = this -> fd();
  if (des != NEGATIVE) {
    this -> fd() = NEGATIVE;
    return ::close(des);
  }
}

int Audio::audio_open() {
  struct audio_ioctl  tmp;

  if ((fd() = ::open(TEST_DEVICE , O_RDWR, 0666)) < 0) {
    cerr << form ("Can't open %s\n", TEST_DEVICE);
    real_flag = 0;
    return fd();
  }

  /* Initialize the three gain registers to 0db. */
  audio_set_ger(fd(), 12);
  audio_set_gr(fd(), 12);
  audio_set_gx(fd(), 10);

  /*
  * Tell the chip to set the gains according to the
  * register values we just set.
  */

  tmp.control = AUDIO_MAP_MMR1;
  tmp.data[0] = AUDIO_MMR1_BITS_LOAD_GX |
      AUDIO_MMR1_BITS_LOAD_GR |
      AUDIO_MMR1_BITS_LOAD_GER;

  if (real_flag) {
    if (ioctl(fd(),AUDIOSETREG,&tmp) < 0) {
      ::perror("Set REG");
    }
  }

  /*  Initialize the MMR2 register to send the output to the builtin
   *  speaker.  This is the default, but we will be defensive
   *  anyway.  Note that we read the register and turn on the
   *  appropriate bit, rather thanjust setting it.  This keeps us
   *  from stompin any useful bits that are already set.  It turns
   *  out that there is one -- the bit that selects AINB for
   *  recording.
   */
  if (real_flag) {
    tmp.control = AUDIO_MAP_MMR2;
    if (ioctl(fd(),AUDIOGETREG,&tmp) < 0) {
      ::perror("Set REG");
    }

    tmp.data[0] |= AUDIO_MMR2_BITS_LS;
    if (ioctl(fd(),AUDIOSETREG,&tmp) < 0) {
      ::perror("Set REG");
    }
  }
}
