/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/include/SCCS/s.devxfile.hxx
 * Vers: 5.2    Time: 92/08/04, 11:01:06
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef DEVXFILE_HXX
#define DEVXFILE_HXX

/******************************************************
* NAME
* 	devxfile.hxx
*
* PURPOSE
*	A device class for simple Unix files.
*	Examples:
*		- real files (that reside on disk)
*		- named pipes
*		- stdin/stdout/stderr
*
*	It is possible to create a File_Device from any
*	Unix object with an integer file descriptor:
*		int fd;
*******************************************************/

#if 0	/* to be deleted */

#ifndef DEVICE_HXX
#include "device.hxx"	/* base class definition */
#endif

#endif	/* 0 */

#if BSD

enum NamedFileType {ordinary, namedPipe};	/* supported named files */

/****************************************************************
A File_Device is used to create a OTSO Device from a
simple file.  Some examples of the type of files
it can be used for are :
  - real files (that reside on disk)
  - named pipes
  - stdin/stdout/stderr

Basically, it is possible to create a File_Device from any
OS object with an integer file descriptor:
  int fd;

.SH SYNOPSIS
  #ifndef DEVXFILE_HXX
  #include "/otso/include/devxfile.hxx"
  #endif

  File_Device	ascii_Dev ("otso.log");
  File_Device	ipipe_Dev ("input_pipe", namedPipe);
  File_Device	stdin_Dev (int fd=0);	

.SH SEE ALSO
.nf
 device.hxx devbsd.hxx
 init2.inc - An important place in OTSO, where a File_Device 
             is used is for the OTSO "userInputDevice".
.fi
****************************************************************/

class File_Device : public Device {
private:
  void makeNamedPipe(char *);	// create a Unix named pipe 

public:

  File_Device () : Device(NEGATIVE) { /* stub default ctor */ }

  // You can create a OTSO device from an ordinary file or a named pipe,
  // by specifying a "filename" string to the constructor.  
  // If the named file doesn't exist, an attempt will be made to create it.
  File_Device (	char*, NamedFileType typ=ordinary, Event e=ev_none) ;	

  // Alternately, you can create a OTSO device by specifying an
  // integer file descriptor of an existing Unix file to the constructor.
  // Event Handlers for asynchronous events can also be specified for
  // the constructor (see class Device for more details).
  File_Device (	int d, Event e=ev_none, char* t="BSD file") : Device(d, e, t)
  {
    this -> pdeviceTable -> add (this);	/* add this Device to DeviceTable */
  }

  ~File_Device ();
};	/* File_Device */


#else
# if SYSV
# endif	/* SYSV */
#endif	/* BSD */

#endif	/* DEVXFILE_HXX */
