/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/include/SCCS/s.devsock.hxx
 * Vers: 5.3    Time: 92/09/03, 15:49:17
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/

/******************************************************
* NAME
*  devsock.hxx	-  Berkley Socket devices.
*
* PURPOSE
*  Implement a Berkley TCP/IP socket device.
*
* MODIFICATIONS
*  Modified after looking at Interviews' Connection class
*  for sockets.  Things that looked like they made better sense
*  in the Interviews class were copied here as well.
*******************************************************/

#if 0	/* to be deleted */

#ifndef DEVICE_HXX
#include "device.hxx"
#endif
#ifndef CHANNEL_HXX
#include "channel.hxx"
#endif

#endif /* 0 */
#include "OTSO.hxx"

#include <sys/socket.h>	/* SOCK_STREAM AF_INET */

#include "in.h"	/* !!! WARNING - HACK ALERT - using InterView's in.h	!!! */
		/* !!! because htons() is badly defined for C++, 	!!! */
		/* !!! in <netinet/in.h> 				!!! */

#include <sys/un.h>	/* sockaddr_un */
#include <sys/ioctl.h>	/* F_SETFL */

class Socket;
class ClientSocket;
class ServerSocket;
class ServiceSocket;

class Socket : public Device {

  friend class ClientSocket;
  friend class ServerSocket;
  friend class ServiceSocket;

protected:
  /* fd is in Device base class */
  int			domain;
  int			type;
  int			protocol;	
  int 			portnum;	// portnum@hostname
  const char *		servname;	// hostname or filename

  boolean		Create(sockaddr_in&);
			// Create local socket (internet),
			// success returned.
  int			LocalCreate(sockaddr_un&);
			// Create local socket (unix),
			// length of socket address returned.

public:
  void		Close();	// shutdown and close socket.
  int&		Port()		{ return this -> portnum; }  // portnumber
  virtual int	Read(Frame&, int i=1024);	// from class Device
  virtual int	Write(Frame&);	// from class Device

  int		blocks(boolean doblock, int delay) ;	// block for delay secs
  int		linger(boolean) ;	// true - linger on close

  virtual boolean	eventHandler();
  Socket (
   Event evnt,
   int fd	= NEGATIVE,
   int portno	= NEGATIVE,
   int domain	= AF_UNIX,
   int type	= SOCK_STREAM,
   int proto	= 0
  );

  ~Socket();

private:
  Frame*	sk_wbuf;		// buffer frames here Socket::Write
					// while device is blocked, eventHandler
					// will write them when it can
  boolean	sk_do_wbuf;		// flag to tell if buffering
					// takes place or not.
};

class ClientSocket : public Socket {
public:
  boolean Connect (const char* hostname, int p);	// p@hostname
  boolean LocalConnect(const char* filename);		// Unix Filename
  
  ClientSocket (
    Event evnt,
    int fd	= NEGATIVE,
    int portno	= NEGATIVE,
    int domain	= AF_UNIX,
    int type	= NULL,
    int proto	= NULL
  ) : Socket (evnt, fd, portno, domain, type, proto) {}

  ~ClientSocket ();
};

class ServerSocket : public Socket {

protected:
  Device	**listener;	// when we create a server socket
				// after accepting a client, attach
				// it to this Device.
				
  virtual boolean eventHandler ();	// Server's event Handler.
					// creates a service socket and
					// maybe an Device to handle
					// new clients.

  /* create a local service */
  void		Serve(const char* hostname, int p);	// p@hostname
  void		LocalServe(const char* sname);	// unix filename

public:
  ServerSocket (
    Device **pis,
    Event evnt,
    char *name		= NULL,		// unix socket name, or TCPIP hostname
    int portnum		= NEGATIVE,
    int domain		= AF_UNIX,
    int type		= NULL,
    int proto		= NULL
  );

  ~ServerSocket () {}
};

class ServiceSocket : public Socket {
public:
  ServiceSocket(
    Event evnt,
    int fd	= NEGATIVE,
    boolean isBlocking = false,
    int portno	= NEGATIVE,
    int domain	= AF_UNIX,
    int type	= NULL,
    int proto	= NULL
  ) : Socket (evnt, fd, portno, domain, type, proto) {

    /* add socket to device table */
    this -> pdeviceTable -> add (this);	/* into dev table */

    this -> blocks (isBlocking, 0);	/* blocking or non blocking */
  }

  ~ServiceSocket (); //add socket to device table 
};

