/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/include/SCCS/s.devbsd.hxx
 * Vers: 5.2    Time: 92/08/04, 11:01:00
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef DEVBSD_HXX
#define DEVBSD_HXX

/*******************************************************
* NAME
*	 devbsd.hxx -  Bsd Device Interface Code
*
* PURPOSE
*	Device Table and Device  classes for OTSO running
*	on Berkley Unix OTSO.
*
********************************************************/

#if 0	/* to be deleted */

#ifndef RUNNER_HXX
# include "runner.hxx"
#endif

#endif /* 0 */


#define NEGATIVE -1

/* ------- Local Declarations / Definitions ---------- */


/*
*  Type of event to be "Watched For" on a device:
*  allow bit masking for checking read/writes !
*/

enum Event {
	ev_none   = 0x00,	// Events aren't watched for at all.
	ev_read   = 0x01,	// watch for pending read.
	ev_write  = 0x02,	// device can be written to again.
	ev_bothrw = 0x03,	// (ev_read & ev_write)
};

#if 0
typedef sint16 Event;
static const Event ev_none   = 0x00; // Events aren't watched for at all.
static const Event ev_read   = 0x01; // watch for pending read.
static const Event ev_write  = 0x02; // device can be written to again.
static const Event ev_bothrw = 0x03; // (ev_read & ev_write)
#endif


class Device;
class DeviceTable;
extern DeviceTable *pGlobalDevices;	// see device.hxx


/*******************************************************************
"Device" is the base class for all OTSO devices.  In general, the
OTSO user will probably use derived OTSO devices such as File_Device,
Socket_Device, etc.   The OTSO Device Table however, is a table
of base class "Device"s.

.SH SYNOPSIS
.nf
Although, Device and DeviceTable are defined in OS specific
header files such as devbsd.hxx, you should include them by :

  #ifndef  DEVICE_HXX
  #include "/otso/include/device.hxx"	
  #endif
.fi

.SH SEE ALSO
devxfile.hxx devsock.hxx device.hxx
*******************************************************************/
class Device : public Object {
  friend class DeviceTable;

protected:
  int fDescr;		// Our physical Unix file descriptor
			// from open (2v) & close (2).

  virtual boolean eventHandler() {
    return false;
  } // Event Handler: false - event wasn't handled,
    // true - event was handled.

public:

  char *deviceName;	// An optional name, allocation via "new".

  static DeviceTable* pdeviceTable; // The device table we are entered in.

  Event event;		// The host OS should "watch for" the occurance of 
			// certain events on this Device.  When an event 
			// occurs, the appropriate event handler may be called.

  Event pending;	// Events which are currently outstanding on this
			// Device and are awaiting service.

  int& fd() { return fDescr; }	// Give a copy of Device's real file descriptor.

  virtual int Read (Frame&, int i=1024);// Default Device Reader (not used).
  virtual int Write (Frame&);		// Default Device Writer (not used).

  void print(Ostream&);		// Redefined Object print, for
				// os << Device;
  virtual String className() const {return "Device";}

  /*****************************************************
  Devices can only be constructed from 
.nf
	- other Devices
	- Device pointers
  	- physical Unix File Descriptors.
.fi

  When constructing a OTSO device from a File Descriptor,
  you can also specify (optionally):
.nf
	- an event to be watched on the Device by a
	  Device Table (such as an asych read).
	- an event handler to handle any events that occur.
	- A name for the device (for DeviceTable print() ).
	- A pointer to a DeviceTable where this Device should
	  be entered, the default being the default DeviceTable
	  for OTSO (pGlobalDevices).
.fi
******************************************************/
  Device (int fd, Event=ev_none, char*  =NULL, DeviceTable* d=::pGlobalDevices);
  Device (Device&) {}
  Device () {fDescr=NEGATIVE; event = ev_none;}
  Device (Device* pdev)
  {
    *this=*pdev;
  }
  ~Device ();

};


const int max_device = 66; //max number of open files in many Unixes is 64

/*******************************************************************
A "DeviceTable" is a table of OTSO Devices.  
It is currently implemented as a simple static array of Devices.  

The following DeviceTable description is valid for Berkley Unix ONLY.

.nf
fd_set (see man select(2)):
 Besides having a table of OTSO devices, the DeviceTable also maintains
 Berkley fd_set's for monitoring read/write file descriptors.
 New fd's are added to the proper fd_set, when a new OTSO device is
 added (depending on the Event to be watched for the Device) to the
 DeviceTable.
.fi

A DeviceTable is also a Runner.  When  OTSO schedules the DeviceTable
to "run", it does the following:
.nf
  - Use Berkley select(2) call to check the fd_sets.
  - For each event that has occurred in an fd_set :
        - Find the corresponding OTSO Device.
        - Call the Device's event_handler if one exists,
          or set the flag "pending" in the Device.  Hopefully
          some other OTSO object's run() function will check the
          pending flag of the Device and handle it when they
          are scheduled (e.g. the OTSO userInputDevice is checked by 
          when the corresponding OTSO Istream is scheduled).
.fi

.SH NOTE
The use of an array in the OTSO DeviceTable was originally intended 
to allow static OTSO Device id's to uniquely identify OTSO Devices.
Also the DeviceTable in reality will usually contain a small
number of Devices that must be accessed quickly, and array seemed best
for this.

An implementation note: pdeviceArray[0] ... pdeviceArray[nactive-1]
are in use, the other elements are 0 pointers and free.

.SH BUGS
The time that the select() uses to wait is hardcoded right now.
When a global OTSO timer manager is available, the time select()
waits should be the least timer time in OTSO or some default if
no timers are available.
********************************************************************/

class DeviceTable : public Runner {
  Device*  pdeviceArray [max_device];	// Table of OTSO Devices.

  unsigned int nactive;	// Number of active devices.

  int dtablesize;	// For BSD select (2) call.
			// Max number of file descriptors.

  fd_set readFds;	// For BSD select (2) call.  Readable fd's.
  fd_set writeFds;	// For BSD select (2) call.  Writable fd's.

	
public:
  int active() { return nactive; }	// Number of active OTSO devices.

  boolean add (Device*);	//Add a user Device to OTSO Device table.
                                //Returns true iff successful.

  void remove (Device *);	// Remove Device from OTSO Device table.


  virtual void 	run();	// Check fd's via select, call appropriate
			// Device event handler for fd, or set
			// flag "pending" in Device.

  virtual void	print(Ostream&);	// os << DeviceTable; 
  String className() const      {return "DeviceTable";}

  DeviceTable ();
  ~DeviceTable () {}
};
	
#endif	/* DEVBSD_HXX */
