/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/include/SCCS/s.audio.hxx
 * Vers: 5.2    Time: 92/08/04, 11:00:58
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef AUDIO_HXX
#define AUDIO_HXX 1

/********************************************************
FILE	audio.hxx

PURPOSE	
	Experimental Audio Device class for DVOPS.  Right
	now, I think only Sun Sparc's have an Audio Device,
	but the class defn will be made quite general.
********************************************************/

/*
 * Audio Device :
 *   /dev/audio on SUN SparcStation.  See "audio" man(4) 
 *   See AMD 79C30A/32A (1989), "Digital Subscriber Controller"
 */

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/file.h>

#include <fcntl.h>
#include <errno.h>
#include <stdio.h>

#include <sys/ioctl.h>
#include <sbusdev/audioreg.h>
#include <sun/audioio.h>


#ifndef DEVICE_HXX
#include "device.hxx"
#endif

//typedef void (*audioFilter)() AUDIOFILTER;

#define BUFFER_SIZE 8192

typedef struct sound_buffer {
  int	bits_per_sample;
  int	samples_per_second;
  int	channels;
  int	modulation;
  int	size;
  char	directory[256];
  char	filename[256];
  char	data[BUFFER_SIZE];

  int   cursor_1, cursor_2;
} SoundBuffer;

class Audio : public Device {

protected:
  int quit, real_flag, play_flag, record_flag;
  int isPlaying;

  SoundBuffer buffer;

  Frame *recording;
  Frame *playing;

  int audio_open();
  int audio_close();

public:

  void Record (char *);		// record into filename
  void Record (Frame&);		// record into OTSO frame
  void Play (char *, boolean c=true);	// play filename (continuously ?)
  void Play (Frame&);		// play an OTSO frame

  void Rewind(unsigned);	
  void Cue(unsigned);

  void Pause();
  void Stop();


  void OutputVolume(int=10);	// set the output volume level
  void InputVolume(int=10);	// set the input volume level

  Audio();
  ~Audio();
};

#endif /* AUDIO_HXX */
