/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/bsd/SCCS/s.devxfile.cxx
 * Vers: 5.2    Time: 92/08/04, 11:04:29
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)devxfile.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************
* NAME
*	devxfile.cxx -  Unix File as an IO device
*
* PURPOSE
*	Unix Files can be used as IO devices.
*	Mostly for reading stdin asynchronously.
*
* MODIFICATIONS
* BUGS
*******************************************************/

#include "OTSO.hxx"

#if COMPILER_HPUX
#  include <fcntl.h>		/* to define open() */
#else
#  include <sys/fcntlcom.h>
#endif

// -- Local Declarations / Definitions
extern int errno;

// -- Member Functions
void File_Device::makeNamedPipe (char * filname)
{
#if BSD
  // Usage: /usr/etc/mknod filname p
  char* command = new char [128 + 2*(::strlen(filname)) + 1];
//  command << "rm -f " << filname << "; ";
//  command << "/usr/etc/mknod " << filname << " p\n";

  ::strcpy (command, "rm -f ");
  ::strcat (command, filname);
  ::strcat (command, "; /usr/etc/mknod ");
  ::strcat (command, filname);
  ::strcat (command, " p\n");
  
#if DEBUGGING
  cout << command;
#endif
  ::system (command);

#endif
}

// Constructors/Destructors
File_Device::File_Device (char* filname, NamedFileType ftype, Event e) :
  Device(NEGATIVE, e, filname)
{
  int od = NULL;

  // santity check first
  if (filname) {
    if (::strlen (filname) > 0) {
#if BSD
      if (ftype == namedPipe) {  /* NAMED PIPE FILE */
        od = ::open (filname, O_RDWR, 00666);
        if (od == -1) {  /* If named pipe doesn't exist, create one */
          this->makeNamedPipe (filname);
          od = ::open (filname, O_RDWR, 00666); 
          if (od == -1) {
            cerr << "Error: opening Unix File Device, errno = " 
                 << int(::errno)  << "\n";
            exit (1);
          }
        }
       }
       else {  /* ORDINARY FILE */
        // open mode (00666) = rw-rw-rw-
        od = ::open (filname, (O_CREAT|O_RDWR), 00666); 
        if (od == -1) {
          cerr << "Error: opening Unix File Device, errno = " 
               << int(::errno)  << "\n";
          exit (1);
        }
      }

      // File Device exists, and is blocking.  Watch for reads.
      this->fd() = od;
      this->pdeviceTable->add (this);
#endif
    }
  }
}

File_Device::~File_Device ()
{
  this->pdeviceTable->remove (this);
  // base class destructor does a Unix close (2)
  // on the file descriptor.
}
