/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.channel.cxx
 * Vers: 5.2    Time: 92/08/03, 15:59:49
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)channel.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*  NAME
*	channel.cxx
*
*  PURPOSE
*	To provide input and output byte stream bit pipes for
*	communications.  Istream and Ostream can be used for user
*	communications, IDump and ODump can be used for Inter-process
*	communication.  IDump and ODump are intended to provide 
*	transfer syntax conversion by operator overloading of
*	<< and >> operators.
*
*
*  SERVICE
*
*  BUGS
*	Run () functions are dependent on Host Operating system
*	"Device" interface ?
*
*  MODIFICATIONS
*  - port to SPARC ::namedObj
*  - #ifdefs for !COMPILER_GPLUS are because istreams/ostreams differ
*    between ATT Cfront 2.0 and GNU 1.37.
*  - MSDOS #ifdef added for running OTSO under MSDOS.  No Device classes are
*    available in MSDOS yet, because there doesn't exist an ability to check
*    for events yet.  As a *HACK*, we use istreams/ostreams and construct
*    din and dout (Istream/Ostream) from cin/cout.  This is less efficient
*    than we would like, since OTSO will now block for input while waiting
*    for the user to input something in MSDOS.  The upshot of this is that the
*    MSDOS Istream::run function can't check it's input device when run() is 
*    scheduled, it just has to block until the user types something.  
*    Change this someday if it possible. - jfr/lba
**********************************************************************/

#define AGENT_HXX	1	/*ObjectPtr*/
#define CHANNEL_HXX	1
#define DYNDIR_HXX	1
#define GROUP_HXX	1
#define INTA_HXX	1	/*ObjectPtr*/
#define MESSAGE_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define PROCESS_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1
#define VOIDGRP_HXX	1

#define DEVICE_HXX	1
#define DEVXFILE_HXX	1
#define DEVSOCK_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /*** dout << "#dbug channel.cxx# - " << xxx << "\n" ***/
#define BUGOUT2(xxx)  /*** dout << "#dbug channel.cxx# - " << xxx << "\n" ***/
#define DEBUGGING_GET_BUFFER 0

// -- GLOBAL VARIABLES --

Ostream* warningStream	= NULL;
Ostream* errorStream	= NULL;
Ostream* doutStream	= NULL;
Istream* dinStream	= NULL;
Ostream* dlogStream	= NULL;
Ostream* dummyOstream	= NULL;
const OstreamIndent INDENT = 0;
boolean otsoIsExiting   = false;           //False until OTSO is stopping.
                                           //This is the termination condition
                                           //of threads.

char* debug() {
  warningStream->flush();
  errorStream->flush();
  return "";	                           //set debugger break point here
}

/************ form(...) ********************************************/
//stdio.h sprintf used !?!

char otsoFormArray[333];

char* form(char* format, int a1) {
  sprintf(::otsoFormArray, format, a1);
  return ::otsoFormArray;
}

char* form(char* format, int a1, double a2) {
  sprintf(::otsoFormArray, format, a1, a2);
  return ::otsoFormArray;
}

char* form(char* format, char* a1) {
  sprintf(::otsoFormArray, format, a1);
  return ::otsoFormArray;
}

char* form(char* format, double a1, double a2, double a3, double a4) {
  sprintf(::otsoFormArray, format, a1, a2, a3, a4);
  return ::otsoFormArray;
}

char* form(char* format, double d, char* cp) {
  sprintf(::otsoFormArray, format, d, cp);
  return ::otsoFormArray;
}

/**********************************************************************
Filebuf
**********************************************************************/

int Filebuf::overflow(int c) {
  if (dout.logging && dout.logger) {
    Ostream& logfile = *dout.logger;
    cout.write(pbase(), pptr() - pbase());
    logfile.write(pbase(), pptr() - pbase());
    logfile.flush();			       //Keep logfile up to date
                                               //for runtime tracing purposes.
                                               //?For efficiency, switch off!
  }
  else {
    cout.write(pbase(), pptr() - pbase());
  }

  setp(base(), ebuf());
  int ret = filebuf::overflow(c);
  cout.flush();	       //din tied only to dout, cout must be flushed explicitly
  return ret;
}

int Filebuf::underflow() {
  int ret = filebuf::underflow();
  if (dinStream->logging && dinStream->logger) {
    Ostream& logfile = *dinStream->logger;
    if (dout.logging && doutStream->logger == dinStream->logger)
      logfile << "{{{";
    logfile.write(gptr(), egptr() - gptr());
    if (dout.logging && doutStream->logger == dinStream->logger)
      logfile << "}}}";
  }                                           
  return ret;
}

void Filebuf::putBack(String& s) {
  BUGOUT( " ENTERING putBack(" << s << ")" );
  BUGOUT( " putBack: buf = " << (long)base() << "-" << (long)ebuf() << ", eback() = " << (long) eback() << "\nget= " << (long)gptr() << "-" << (long)egptr() << ", put=" << (long)pptr() << "-" << (long)epptr() );

#if DEBUGGING_GET_BUFFER
  dout <<  "\nGET AREA = {";
  for (char* cc = gptr(); cc < egptr(); cc++) {
    if (*cc == '\n') dout << "\\n";
    else dout.put(*cc);
  }
  dout << "} END OF GET AREA\n";
#endif

  //new buffer = s + oldBuffer + '\0'?
  sint32 len = s.length() + (egptr()-gptr()) + 1;
  char* cp = new char[len];
  char* ecp = cp + len - 1;
  strcpy(cp, (char*)s);
  strncpy(&cp[s.length()], gptr(), egptr() - gptr()); 
  setb(cp, ecp, 1);		//1: old buffer deleted at each new setb
  setg(cp, cp, ecp);
  //cp[len] = '\0';	//?

  BUGOUT( " EXITING putBack: buf = " << (long)base() << "-" << (long)ebuf() << ", eback() = " << (long) eback() << "\nget= " << (long)gptr() << "-" << (long)egptr() << ", put=" << (long)pptr() << "-" << (long)epptr() );

#if DEBUGGING_GET_BUFFER
  dout <<  "GET AREA = {";
  for (char* ccc = gptr(); ccc < egptr(); ccc++) {
    if (*ccc == '\n') dout << "\\n";
    else dout.put(*ccc);
  }
  dout << "} END OF GET AREA\n";
#endif
}

boolean Filebuf::isEmpty() {
  BUGOUT2( "  bufferIsEmpty: " << (long)gptr() << " " << (long)egptr() );
  return (gptr() >= egptr());
}

/**********************************************************************/
String Channel::className() const {return "Channel";}
String Ostream::className() const {return "Ostream";}
String Istream::className() const {return "Istream";}
String ODump::className() const {return "ODump";}
String IDump::className() const {return "IDump";}
/**********************************************************************/

Channel::Channel() {
        // If myScheduler() -> inQ() is PriorVec, then this priority tells 
        // which Group of the PriorVec will contain this
  setPriority(lowRunnerPriority);
}

/******************************************
 * 	Istream and Ostream
 ******************************************/

void Istream::initIstream() {
  this -> runStatus = RunStatus::enabled;// Istream can run in a scheduler.
  this -> logging   = false;		 // No logging of Istream.

  trace.running = false;
  trace.variablesBefore = false;
  trace.receiving = false;
  trace.inputParameters = false;
  trace.actions = true;			//?
  trace.sending = false;
  trace.outputParameters = false;
  trace.variablesAfter = false;
  trace.verbose = false;
}

#if !(COMPILER_GPLUS || LIB_GPLUS)
Istream::Istream (Istream& I, Ostream *log): fbp(0) {
  this -> istream_withassign::operator=(I);
  this -> pifs = NULL;
  this -> pdevice = NULL;
  this -> logger = log;
  this -> initIstream();
}

Istream::Istream (istream& i, Ostream *log): fbp(0) {
  this -> istream_withassign::operator=(i);
  this -> pifs = NULL;
  this -> pdevice = NULL;
  this -> logger = log;
  this -> initIstream();
}

#if !MSDOS
/* members ifstream ifs and istream is */
Istream::Istream (Device *pdev, Ostream *out, int skip, Ostream *log): fbp(0) {
  pifs = new ifstream(pdev -> fd());
  this -> istream_withassign::operator=(*pifs);
  this -> pdevice = pdev;
  this -> logger = log;
  initIstream();
  istream_withassign::skip(skip);
  pifs -> skip(skip);
  if (out != NULL) {
    tie (out);
    //pifs -> tie (out); 
  }
}

Istream::Istream (istream& is, Device *pdev, 
                  Ostream *out, int skip, Ostream *log)
  : fbp(0), pdevice(pdev), logger(log) {
  //is should be constructed from pdev->fd() !!!
  this -> istream_withassign::operator=(is);
  initIstream();
  istream_withassign::skip(skip);
  if (out)
    tie(out);
}
#endif

Istream::Istream(): fbp(0), pifs(NULL), pdevice(NULL)
{
  initIstream();
}

Istream::Istream(String filename): 
  fbp(new filebuf),
  fbisp(new istream(fbp)) 
{
  if (!fbp->open(filename, ios::in)) {
    dout << "***** OTSO WARNING: Could not open file " << filename << "\n";
    delete fbp; fbp = 0;
    delete fbisp; fbisp = 0;	//caller should check that fbisp != 0
  }
  else {
    this -> istream_withassign::operator=(*fbisp);
    this -> pifs = NULL;
    this -> pdevice = NULL;
    this -> logger = 0;
    this -> initIstream();
  }
}

Istream::~Istream() {
  if (pifs != NULL) {
    delete pifs;
    pifs = NULL;
  }
  delete fbp;
}

Istream::Istream(const Istream&) {
  OTSO_UNDEFINED("Istream::Istream(const Istream&)");
}

void Istream::operator=(const Istream&) {
  OTSO_UNDEFINED("Istream::operator=(const Istream&)");
}


/**********************************************************************/

void Ostream::initOstream(Ostream* logstream=NULL) {
 if (this -> fd() != NULL) {
#if NO_IOSTREAM_CLASSES
   this -> fdstream = ::fdopen (this -> fd(), "a+"); // jfr hacking
#endif
 }
 this -> logger = logstream;
 this -> logging = false;
}

#if !MSDOS
Ostream::Ostream (Device *pdev, Ostream* log) 	//named pipe?
  : indentLevel_(0) 
  , isConnected_(pdev? true : false)
{
  this -> pofs = new ofstream(pdev -> fd());
  this -> pdevice = pdev;
  this -> ostream_withassign::operator=(*this -> pofs);
  this -> logger = log;
  this -> logging = false;
}

Ostream::Ostream (ClientSocket* s, String hostName, sint16 port)
  : clientSocket_(s)
  , pdevice(s)
  , hostName_(hostName)
  , port_(port)
  , isConnected_(false)
  , logging(false)
  , logger(0)
  , indentLevel_(0)
{
  //when clientSocket is connected to a ServerSocket, set
  //  this->pofs = new ofstream(pdev->fd());
  //  this->ostream_withassign::operator=(*this->pofs);
}
#endif

boolean Ostream::isConnected() {
  return isConnected_;
}

boolean Ostream::connect() {
  if (!clientSocket_) {
    OTSO_ERROR( "Ostream::connect : no clientSocket to connect" );
    return false;
  }
  if (clientSocket_->Connect(hostName_, port_)) {
    isConnected_ = true;
    if (trace.actions) 
      dout << "Ostream connected to " << port_ << "@" << hostName_ 
	   << ", fd = " << clientSocket_->fd() << "\n";
    this->pofs = new ofstream(pdevice->fd());
    this->ostream_withassign::operator=(*this->pofs);
  }
  else {
    OTSO_WARNING( "Ostream " << name() << " could not connect to " << port_ << "@" << hostName_ );
  }
}

Ostream::Ostream (Ostream& O, Ostream* log) 
     : indentLevel_(0) 
     , isConnected_(false)
     , pofs(NULL)
     , pdevice(NULL)
     , logger(log)
     , logging(false)
{
  this -> ostream_withassign::operator=(O);
}

Ostream::Ostream (ostream& o, Ostream* log) 
     : indentLevel_(0) 
     , isConnected_(false)
     , pofs(NULL)
     , pdevice(NULL)
     , logger(log)
     , logging(false)
{
  this -> ostream_withassign::operator=(o);
}

Ostream::Ostream() 		//used by the generated Ostream_agent (for UI)
     : isConnected_(false)
     , pofs(NULL)
     , pdevice(NULL)
     , logger(0)
     , logging(false)
{ 
  ostream_withassign::operator=(dout);	//?, nothing should be inserted to this
} 

Ostream::~Ostream() {
  if (pofs != NULL) {
    delete pofs;
    pofs = NULL;
  }
}

Ostream::Ostream(const Ostream&) {
  OTSO_UNDEFINED("Ostream::Ostream(const Ostream&)");
}

void Ostream::operator=(const Ostream&) {
  OTSO_UNDEFINED("Ostream::operator=(const Ostream&)");
}


#else
/* member istream is only */
Istream::Istream (Device *pdev, Ostream *out, int skip, Ostream* log) 
  : is(pdev->fd())
{
  this -> pdevice = pdev;
  this -> logger = log;
  initIstream();
  is.skip(skip);
  if (out != NULL) {
    is.tie (&out -> os);
  }
}

#endif

void Istream::logInputToFile(boolean yesOrNo) {
  this->logging = yesOrNo;
}

boolean Istream::isReadyToRead() {	//other than white space

  if (!pdevice) return true;		//?, input from file (macro)
  //Filebuf* fb = (Filebuf*)rdbuf();	//risky!?
  streambuf* fb = rdbuf();
  char c;
  boolean readNow = true;

  do {
    if (fb->in_avail() == 0) {
      pdevice -> pending = (Event) pdevice -> pending & ~ev_read; 
      BUGOUT2( "fb isEmpty => Istream::isReadyToRead runs DeviceTable" );
      pGlobalDevices->run();		//check if there is something to read
      if (pdevice->pending & ev_read) {
	readNow = true;
	BUGOUT2( "There is something to read" );
      }
      else {
	readNow = false;
        BUGOUT2( "There is nothing to read" );
      }
    }
    if (readNow) {
      get(c);
      BUGOUT2( "Istream::isReadyToRead got char " << c );
      if (!isspace(c)) {
	BUGOUT2( "Istream::isReadyToRead puts it back; is ready!" );
	putback(c);
	return true;
      }
    }
    else break;
  } while (fb->in_avail()!=0 || (pdevice->pending & ev_read));

  BUGOUT2( "Nothing to read?, isReadyToRead returns false" );
  return false;
}

Ostream* Istream::tiedTo() {
  return doutStream; //wrong!?
}

void Istream::run() {

 /*
  *  In general, the pdevice exists because an Istream should 
  * be constructed from a Device.
  *  However, the pdevice could be NULL for the case when an Istream
  * is constructed for a BSD ServerSocket, because the Service
  * Socket isn't created until a client connects to the Server Socket.
  * Until the service device (ServiceSocket) is created,
  * nothing can take place on the Istream.
  */
#if MSDOS == 1	/******************* MSDOS ***********************/
  
  runStatus = enabled;
  if (kbhit() && this == &din) { // fix this when we have device tables
    if (this->trace.actions)
      this->tiedTo() << "\nRunning userinput {\n";
    this->commandInterpreter();
    if (this->trace.actions) {
      *this->tiedTo() << "\n}\n"; //end of Running userinput
      *this->tiedTo()->flush();
    }
  }

#else	/******************* !MSDOS ***********************/

  runStatus = RunStatus::enabled;
  if (pdevice != NULL) {
    dout.flush();
             //If the DeviceTable noticed a pending read for our device,
             //then this Istream should handle it.
    if (pdevice -> pending & ev_read) {
      if (this->trace.actions)
        *this->tiedTo() << "\nRunning userinput {\n";
      //pdevice -> pending = (Event) pdevice -> pending & ~ev_read;  // clear pending read
      this->commandInterpreter();
      if (this->trace.actions) {
        *this->tiedTo() << "\n}\n"; //end of Running userinput
        this->tiedTo()->flush();
      }
    }
  }
#endif
}

void Istream::commandInterpreter() {
  runUI(this, "[OTSO] ", "");
}

/**************************************************
  Commands
**************************************************/

void Istream::Exit() {
  ::systop();
}

void Istream::debug() {::debug();}

void Istream::outputRedirection(String filename,
                                boolean isDoutLoggingThereToo) {
  //move these variables to Channel; delete old values if not 0
  // open a filebuf and ostream to write to a logfile
  filebuf* buf =  new filebuf; 
  if (!buf->open(filename, ios::out))
    OTSO_WARNING( "Could not open file " << filename << "\n" );
  else {
    //flush old output files
    dout.flush();
    if (dout.logger) dout.logger->flush();
    if (dinStream->logger) dinStream->logger->flush();

    ostream* ostr = new ostream(buf);	//stream attached to log file
    this->logger = new Ostream (*ostr);
    this->logInputToFile(true);
    if (isDoutLoggingThereToo) {
      dout.logger = this->logger;
      dout.logOutputToFile(true);
    }
  }
}

void Ostream::logOutputToFile(boolean state) {
  this->logging = state;
}

void Ostream::outputLogging(String filename,
                            boolean isDinLoggingThereToo) {
  //move these variables to Channel; delete old values if not 0
  filebuf* buf =  new filebuf; 
  if (!buf->open(filename, ios::out))
    OTSO_WARNING( "Could not open file " << filename << "\n" );
  else { 
    //flush old output files
    dout.flush();
    if (dout.logger) dout.logger->flush();
    if (dinStream->logger) dinStream->logger->flush();

    ostream* ostr = new ostream(buf); 
    this->logger = new Ostream (*ostr); 
    this->logOutputToFile(true);
    if (isDinLoggingThereToo) {
      dinStream->logger = this->logger;	
      dinStream->logInputToFile(true);
    }
  }
}

VoidLifo* dinStack;

void Istream::inputRedirection(String filename) {
  //flush old output files
  dout.flush();
  if (dout.logger) dout.logger->flush();
  if (dinStream->logger) dinStream->logger->flush();

  dinStack->put(dinStream);
  Istream* tmp = new Istream(filename);
  if (tmp && tmp->fbisp) {	        //created and opened successfully
    tmp->logger = dinStream->logger;	//copy logging settings
    tmp->logging = dinStream->logging;
    dinStream = tmp;		      	//why not istream assignment?
    while (dinStream == tmp) {         	//macro 'din' changes dinStream at EOF
      dinStream->commandInterpreter();
    }
  }
}


void Istream::print(Ostream& os) {
  os << "Istream { ";
  if (pdevice == NULL) 
    os << "No device ";
  else
    os << *pdevice;
  //and more !?
  os << " }\n";
}

void Ostream::print(Ostream& os) {
  os << "Ostream { ";
  if (pdevice == NULL) 
    os << "No device ";
  else
    os << *pdevice;
  //and more !?
  os << " }\n";
}

/******* indentation *****************************************/

Ostream& Ostream::operator<<(OstreamIndent) {
  indent();
  return *this;
}

  //table of spaces to speed up Ostream::indent()
static char indentChars[]
  = "                                                               ";

void Ostream::indent() {
  *this << &indentChars[sizeof(indentChars) -1 - indentLevel_];
}

sint32 Ostream::indentLevel() {
  return indentLevel_;
}

void Ostream::addIndent(sint16 delta) {
  indentLevel_ += delta;
  if (indentLevel_ > sizeof(indentChars))
    indentLevel_ = sizeof(indentChars);
  if (indentLevel_ < 0)
    indentLevel_ = 0;
}


/********************************************
 *	IDump and ODump
 ********************************************/

IDump::IDump(Istream& I): Istream(I) {}
IDump::IDump(istream& i): Istream(i) {}
#if !MSDOS
  IDump::IDump(Device* pdev, ODump *out, int skip): Istream(pdev, out, skip) {}
#endif
IDump::IDump() {}

ODump::ODump(Ostream& O): Ostream(O) {}
ODump::ODump(ostream& o): Ostream(o) {}
#if !MSDOS
  ODump::ODump(Device* pdev): Ostream(pdev) {}
  ODump::ODump(ClientSocket* s, String hostName, sint16 port)
    : Ostream(s, hostName, port) {}
#endif


void IDump::run() {
  this -> runStatus = RunStatus::enabled;

#if !MSDOS

  if (this -> pdevice == NULL) {
    return;
  }

  //////////////// Device and input buffer management ///////////////////

  if (pifs && !*this) {
    if (trace.actions)
      dout << "Running IDump in bad state, deleting ifstream and device\n";
    delete pifs;
    pifs = 0;
    delete pdevice;
    pdevice = 0;
    return;
  }

  if (! (pdevice -> pending & ev_read)) {
    return;
  }

  if (!pifs && pdevice) {	
                              //This IDump was created from no device.
                              //Now that someone has attached a device 
                              //(a socket?) to this,
                              //we must create an ifstream for that device !?
    if (trace.actions)
      dout << "Creating a new ifstream to IDump::pifs\n";
    pifs = new ifstream(pdevice->fd());
    this->istream_withassign::operator=(*pifs);
  }

  //////////////// an event detected, start reading it ///////////////////

  //////////////////////////////////////////////////////////////////////////
  //// Decoding below must match Message Encoding done in Message::to() ////
  //////////////////////////////////////////////////////////////////////////

  Runner::lastConstructedRunner = 0;	    //?
  ObjectPtr ptr;			    //unknown SU, must set it soon
  *this >> ptr;				    //decode dest, source
  Agent* a = ptr.agent();
  if (!*this) {
    pdevice -> pending = (Event) pdevice -> pending & ~ev_read;
    return;
  }

  String msgName;	
  *this >> msgName; 	BUGOUT("msgName=" << msgName);
  MsgId msgId;	
  *this >> msgId;	BUGOUT("msgId=" << msgId);
  boolean returnMsg;  
  *this >> returnMsg; 	BUGOUT("returnMsg=" << returnMsg);

  Message* msg = 0;

  if (returnMsg != 0) {			//the old message is used

    if (a->sourceProcess() != ::thisProcess) 
      OTSO_WARNING("Process " << ::thisProcess->name() 
                   << " received a binary encoded message " << msgName 
                   << " from the same process !?" );

    //I do not worry about simulation here.  Simulation is not distributable.

    msg = scheduler->suspendedMessage(msgId); //?
    boolean ok = false;

    if(a->destProcess() == msg->destProcess())
      if(a->sourceProcess() == msg->sourceProcess()) 
        if (msgName == msg->name())
          if (a->sourceName() == msg->sourceName())
	    if (a->dest()->name() == msg->dest()->name())
    {
               //in Message::from : scheduler->suspendedMessage(msgId) = 0; //?
               ok = true;
    }
    if (!ok)
      OTSO_ERROR("Received " << msgName << " " << *a << ".\n"
	         << "Expected a returnMsg for " << *msg << "\n" );

  }

  else {				//create a new message
    if (trace.actions)
      dout << "Started IDumping " << msgName << "\n";
    Objectifier sp = a->dest(); 
    //BUGOUT( "IDump BEFORE memberObject: sp = " << sp );
    Member mb = sp.otsoType().memberObject(msgName, sp);
    //calls setDest in MethodMember::memberObject
    //BUGOUT( "IDump AFTER  memberObject: sp = " << sp );
    BUGOUT( "mb = " << (long)mb );
    msg = (Message*)mb; //?
    if (msg) {
      msg->setDest(a->dest(), a->destProcess(), 12345);
      msg->setSource(a->source(), a->sourceProcess(), 12345);
      msg->setSourceName(a->sourceName());
    }
  }

  if (!msg) {
    OTSO_ERROR("Undefined message \"" << msgName << "\" to " << a->dest()->name() );
    /*error handling?*/
  } 
  else {
    msg->isReturnMsg = returnMsg;
    msg->id_ = msgId;
    msg->from(*this);			//decode parameters
    BUGOUT("THE WHOLE MESS: " << *msg);
  }

                                       //if buffer is empty, clear pending read
  if (rdbuf()->in_avail() == 0)
    pdevice -> pending = (Event) pdevice -> pending & ~ev_read;

#endif

}
