/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  DVOPS Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/dvops/SCCS/s.timerlist.cxx
 *  Version:	1.2
 *  Time:	91/11/14, 11:37:24
 *
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)timerlist.cxx	1.2 91/11/14";
#endif

/**********************************************************************
* NAME
*	timerlist.cxx
*
* PURPOSE
*	
* BUGS
* MODIFICATIONS
**********************************************************************/

#ifndef TIMERLIST_HXX
#include "timerlist.hxx"
#endif

Group& TimerList::insert (TimerObj *o)
{  // add in order by value
  Link *l = new Link (o, NULL);

  Link *prev = fst;
  Link *pt = fst;

  if (fst == NULL) 
    fst = l;
  else if (((TimerObj *) (fst->element))->elapsing > o->elapsing) {
      l->next = fst;
      fst = l;
  }
  else {
    while (pt) {
      if (((TimerObj *) (pt->element))->elapsing < o->elapsing) {
        prev = pt;
	pt = pt->next;
      }
      else {
	prev->next = l;
	l->next = pt;
      }
    }
    if (!pt)
      prev->next = l;
  }
  return *this;
}

sint32 TimerList::readFirst ()
{ // return the elapsing time of first object
  if (fst)
    return ((TimerObj *)(fst->element))->elapsing;
  else 
    return (sint32)(-1);
}

Group& TimerList::remove (TimerObj*& o, sint id)
{ // return pointer to the object with id
  Link *prv, *pt = fst;

  if (fst) { 
    if (((TimerObj *)(fst->element))->id == id) { /* if the first item on list
						    == id  */
      fst = fst->next;
      o = (TimerObj *)(pt->element);
      delete pt;
      return *this;
    }

    prv = pt;
    pt = pt->next;

    while (pt) {
      if (((TimerObj *)(pt->element))->id == id ) {
	prv->next = pt->next;
	o = (TimerObj *)(pt->element);
	delete pt;
	return *this;
      }
      else {
	prv = pt;
	pt = pt->next;
      }
    }
    o = 0;
    return *this;
  }
  else {	// fst == NULL
    o = 0;
    return *this;
  }
}

const int lineLength = 10;

void TimerList::print(ostream& os)
{
  Link *link = fst;

  if (fst == 0) {
    os << "(empty)\n";
  }
  else {
    cout << "( ";
    int cnt = 0;

    while (link) {
      if ( ++cnt % lineLength == 1 && cnt != 1 )
	cout << "\n ";
      if (link->element)
	link->element->print(os);
      link = link->next;
    }
    cout << ")\n";
  }
}
