/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.string.cxx
 * Vers: 5.2    Time: 92/08/04, 12:22:02
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)string.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*
* NAME
*	string.cxx
*
* PURPOSE
*	A General Purpose null-terminated character array class.
*
*	String Operations:
*	------------------
*	  maxLength - return maximum length for String
*
*	  length - return current length of String, not including
*	    null-terminating character. (strlen)
*
*	  operator+= - append String 's1' onto the end of existing String.
*
*	  withoutWhite - create new String from and existing one,
*	    stripping it of white space.
*
*	  to - write String to ODump
*
*	  from - read String from IDump
*
*	String Operators:
*	-----------------
*	  =
*	  ==
*	  >  (greaterStringThan)
*
*	Constructed From:
*	-----------------
*	char*, char, or String.

*
* MODIFICATIONS
* BUGS
**********************************************************************/


#define CHANNEL_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1
#define VOIDGRP_HXX	1		/*din*/

#define OTSO_SELECT_INCLUDES	1	/* take only these headers */
#include "OTSO.hxx"			/* include them now */


Ostream& operator<<(Ostream& os, char* s) {
  os.ostream_withassign::operator<<(s);
#if OTSO_DEBUGGING
  os.flush();
#endif
  return os;
}

Istream& operator>>(Istream& is, char* s) {
  is.istream_withassign::operator>>(s);
  return is;
} //?

ODump& operator<<(ODump& od, char* s) {
  sint32 l = strlen(s);
  od << l;  
  od.write(s,l);
  return od;
}

IDump& operator>>(IDump& id, char* s) {
  sint32 l;
  id >> l; 
  if (!id) {
    OTSO_ERROR( "Cannot read char*, IDump in bad state" );
  }
  else {
    id.read(s,l);				//s must have enough space!
    s[l] = 0;
  }
  return id;
}


//
// construct String from a 0-terminated C character string.
//
String::String (char* cptr)
{
  //cout << "--- constructing " << *cptr;
  if (cptr == NULL)
    cptr = "";
  this -> cp = new char [this -> sz = ::strlen (cptr) + 1];
  ::strcpy(this -> cp, cptr);
}


//
// construct String i bytes long
//
String::String (sint32 len) {
  if (len < 0) { len = 0; }
  this -> cp = new char [this -> sz = len+1]; 
  *cp = 0;
  //for (sint32 j = 0; j <= len; j++) { this -> cp[j] = 0; }	//?
}

//
// construct new String from existing String
//
String::String (const String& src)
{
  this -> cp = new char [this -> sz = src.maxLength()];
  ::strcpy (this -> cp, src.cp);
}


String String::className() const {
  return "String";
}

boolean String::isEmpty() {
  return (*cp == 0);
}

char& String::operator[](sint32 i) const {
  return cp[i];
}

//
// assignment operator '='
//  strcpy (this <- src)
//
String& String::operator=(const String& src)
{
  sint32 i = ::strlen(src.cp) + 1;
  if (this -> sz < i) {
    delete this -> cp;
    this -> cp = new char [this -> sz = i];
  }
  ::strcpy (this -> cp, src.cp);
  return *this;
}


//
// equivalance operator '=='
//   strcmp (this, s1)
//
boolean operator==(const String& l, const String& r)
{
  //cout << "--- comparing " << l << " and " << r;
  return (::strcmp(l.cp, r.cp) == 0);
}

boolean operator==(const String& l, char* r) {
  //return (::strcmp(l.cp, String(r)) == 0);
  return (::strcmp(l.cp, r) == 0);
}

#if 0
boolean operator==(const String& l, char r) {
  return (l.length() == 1 && *l == r);
}
#endif

boolean leftGreaterThanRight(const String& l, const String& r) {
  return (::strcmp(l,r) > 0);
}


String::~String() {
  delete this -> cp;
}


//
// append String 's1' onto end of 'this' String
//
String& String::operator+=(const String& s1)
{
  sint32 i = this -> length() + s1.length() + 1;
  if (this -> sz < i) {
    char* newCp = new char [this -> sz = i];
    ::strcpy (newCp, this -> cp);
    delete this -> cp;
    this -> cp = newCp;
  }
  ::strcat (this -> cp, s1.cp);
  return *this;
}

String operator+(const String& l, const String& r) {
  String sum = l;
  sum += r;
  return sum;
}

void String::print(Ostream& os) {
  os << cp;
}

void String::ask(Istream& i) {
  char tab[99];
  const char* endOfTab = &tab[98];
  char* cp = tab;
  Istream* ip = &i;

  while ((*ip).get(*cp) && isspace(*cp)) ;		//skip white space

  if (!(*ip) && isspace(*tab)) {
    /*din;		//input file may have exhausted, call macro 'din' */
    if (!din)
      OTSO_WARNING( "Input stream in bad state, input string begins with char(" << *tab << ")");
    else {
      dout << "End of input file. Waiting for more input.  Give '.' if no more input: ";
      ip = dinStream;
      while ((*ip).get(*cp) && isspace(*cp)) ;	//skip white space (new file)
    }
  }

  if (*cp == '"') {				//read until 2nd quote
    while ((*ip).get(*cp) && *cp != '"' && cp != endOfTab)
      cp++;
  }
  else {					//read until white space
    do cp++;
    while ((*ip).get(*cp) && !isspace(*cp) && cp != endOfTab);
  }
  *cp = 0;
  *this = tab;
}

//
// write a String to an ODump
//
void String::to(ODump& od) {
  od << cp;
}


//
// read a String from an IDump
//
void String::from(IDump& id) {
  sint32 l;
  id >> l; 			//length
  if (!id) {
    OTSO_ERROR( "Cannot read a String, IDump in bad state" );
    return;
  }
  if (l > 100000 /*?*/) {
    OTSO_WARNING( "Sorry, " << l << "-byte Strings not decoded.  Assuming that " << id.name() << " is corrupted and setting ios::badbit." );
    id.clear(ios::badbit);
  }
  else {
    String tmp(l);		
    id.read(tmp.cp,l);
    tmp[l] = 0;
    *this = tmp;
  }
}


//
// Make a new string, stripped of all the 
// "whitespace", from 'this' String.
//
String String::withoutWhite()
{
  sint32 len = this -> length();
  String stripped = "";	// new string to be stripped
  for (sint32 i = 0; i < len; i++) {
    if (!isspace(this -> operator[](i))) {
      stripped += " ";
      stripped[stripped.length()-1] = this -> operator[](i);
    }
  }
  return stripped;
}

/************ global functions *****************************************/

/************************************************************************
matches returns true if rp is equal to sp.  rp may contain the wild card '*' 
which is equal to any string of 0 or more characters.
*************************************************************************/
boolean matches(const char* rp, const char* sp) {
  boolean wild = false;
  const char* tmpRp;
  const char* tmpSp;

  while (*rp && *sp) {
    tmpRp = rp; tmpSp = sp;
    while (*tmpRp && *tmpSp && *tmpRp==*tmpSp && *tmpSp!='*') {
      tmpRp++; tmpSp++;
    }
    if (*tmpRp==0 && *tmpSp==0 || *tmpRp=='*') {
      rp = tmpRp; sp = tmpSp;
      wild = false;
    }
    else if (!wild) break;
    else {/*dout << *sp;*/ sp++;}

    while (*rp && *rp=='*') {rp++; wild = true; /*dout << " ";*/}
    while (*sp && *rp!=*sp) {/*dout << *sp;*/ sp++;}
  }
  while (*rp && *rp=='*') rp++;
  return (*rp==0 && *sp==0);
}

char* nSpaces(sint16 n) {	//max 120
  static char t[] = "                                                                                                                        "; //120 spaces
  static sint16 l = strlen(t);
  if (n < 0) return &t[l-1];
  else if (n >= l) return t;
  else return &t[l-n];
}

void bulletLine(Ostream& os, String bullet, String line, sint32 indent, sint32 lineLength) {
  //Inefficient to build a String little by little.
  //Cannot handle tabs '\t'.

  if (indent >= lineLength) indent = 0;
  String out = bullet;
  if (bullet.length() < indent)
    out += nSpaces(indent - bullet.length());
  else
    out += String("\n") + nSpaces((sint16)indent);

  sint32 pos = indent;
  sint32 lastSpace = 0;
  sint32 outi = out.length() - 1;		//index of last char in out
  char* cp = (char*)line;
  char* ecp = cp + line.length();
  for ( ; cp < ecp; cp++){
    out += " "; out[++outi] = *cp; pos++;
    if (*cp==' ') lastSpace = outi;
    if (*cp=='\n') {
      //append indentation
      out += nSpaces((sint16)indent); pos = indent; outi += indent;
      lastSpace = 0;
    }
    if (pos == lineLength) {
      if (lastSpace) {
	out[lastSpace] = '\n';
	//insert indentation
	String tmp = &out[lastSpace+1];		//maybe ""
	out[lastSpace+1] = 0; outi -= tmp.length();
	out = out + nSpaces((sint16)indent) + tmp;
	pos = indent + tmp.length(); outi += pos;
	lastSpace = 0;
      }
      else {
	out += " "; out[++outi] = '\n'; 
	out += nSpaces((sint16)indent); outi += indent; pos = indent;
      }
    }
  }
  os << out;
}
