/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.statobj.cxx
 * Vers: 5.1    Time: 92/08/04, 15:08:33
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)statobj.cxx	5.1 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//	statobj.cxx	- Juha 18.3.92

/**********************************************************************
This file is the combination of 
 - statobj.cxx
 - numobj.cxx
 - statbool.cxx
**********************************************************************/

//#include "object.hxx"
//#include "channel.hxx"
//#include "tree.hxx"
//#include "statobj.hxx"
//#include "sampled.hxx"
//#include "simres.hxx"

#define EV_HXX		1
#define NORMAL_HXX	1
#define SIMCTRL_HXX	1
#define VCLOCK_HXX	1
                  
#include "OTSO.hxx"

#if SIMULATING			/* defined only after #including OTSO.hxx */

#define OTSO_SIMU_SELECT_INCLUDES 1
#include "SIMU.hxx"

/******************** statobj.cxx ********************************/

StatObj& StatObj::operator=(const StatObj& r) {
  //This routine acts the same way as the implicitly generated one,
  //but explicit implementation was necessary to get some other files compiled
  //(cc complained "no table entry for op STASG").

  countExp = r.countExp;
  ctl = r.ctl;
  expOfCurObs = r.expOfCurObs;
  curObs = r.curObs;

  return *this;
}

StatObj::StatObj(const StatObj& i)
     : countExp(i.countExp)
     //ctl not copied
     , expOfCurObs(i.expOfCurObs)
     , curObs(i.curObs)
{
  ctl = (this != &::simCtrl) ? &::simCtrl : 0;
  if (ctl && simCtrlInited) ctl->addStatObj(this);
}

StatObj::StatObj()
{
	countExp = false;

	ctl = (this != &::simCtrl) ? &::simCtrl : 0;
	if (ctl && simCtrlInited) ctl->addStatObj(this);

	expOfCurObs = 0;
	curObs      = 0;

        simExpActive    = false;        // *MJSII*
}

StatObj::~StatObj()
{
        if (ctl) ctl->delStatObj(this);
}

void StatObj::countSimExp(boolean b)
{
	if (ctl && ctl->simExpStatus() == EXPSTAT_ACTIVE) {
		OTSO_ERROR("StatObj::countSimExp(); active experiment.");
		exit (1);
	}

	countExp = b;
}

void StatObj::startSimExp()
{
        simExpActive = true;
}

void StatObj::finishSimExp()
{
        simExpActive = false;
}


SimObs* StatObj::createSimObs()
{
	OTSO_ERROR("StatObj::createSimObs(); derived class should implement.");
	exit (1);
}

SimObs* StatObj::getSimObs()
{
	if (!ctl) {
		OTSO_ERROR("StatObj::getSimObs(); no control object");
		exit (1);
	}

	if (ctl->simExpStatus() != EXPSTAT_DONE) {
		OTSO_ERROR("StatObj::getSimObs(); experiment active or not yet finished");
		exit (1);
	}

	if (expOfCurObs != ctl->exp())
		if (countSimExpSet()) {
			curObs = createSimObs();
			curObs->setExp(expOfCurObs = ctl->exp());
		} else
			curObs = 0;

	return curObs;
}


/******************** numobj.cxx ********************************/

NumObj::NumObj(SampledCont* scp_)
{
	val	 = 0.0;
	ownScp	 = false;
	scp	 = 0;

	setSampledCont(scp_);
}

NumObj::NumObj(const NumObj& i)
     : StatObj(i)
     , counting(i.counting)
     , val(i.val)
     , ownScp(true)		//either ownScp == false or scp != i.scp
                                //because of destructor!
     , scp(new SampledCont)	
{}

NumObj& NumObj::operator=(const NumObj& r) {
  StatObj::operator=(r);
  counting = r.counting;
  val = r.val;
                                //either ownScp == false or scp != r.scp
                                //because of destructor !
  ownScp = true;
  scp = new SampledCont;
  return *this;
}

NumObj::~NumObj()
{
	if (ownScp) delete scp;
}


void NumObj::operator=(double d)
{
	val = d;
#if SIMULATING
        if (simExpActive) (*scp) += d;
#endif
}

void NumObj::setSampledCont(SampledCont* scp_)
{
	if (scp) {
		OTSO_ERROR("NumObj::setSampledCont(); cannot set twice");
		exit (1);
	}

	scp = scp_;
}

#if SIMULATING

void NumObj::startSimExp()
{
        StatObj::startSimExp();

        if (!scp) {
                scp     = new SampledCont;
                ownScp  = true;
        }

        scp->reset();
        scp->start();
}

void NumObj::finishSimExp()
{
        StatObj::finishSimExp();
        scp->stop();
}

SimObs* NumObj::createSimObs()
{
	return new SONumObj(this);
}


SONumObj::SONumObj(NumObj* nop)
{
	scp = nop->sampledCont()->copy();
}

SONumObj::~SONumObj()
{
	delete scp;
}

SONumObj::SONumObj(const SONumObj&) {
  OTSO_UNDEFINED("SONumObj::SONumObj(const SONumObj&)");
}

void SONumObj::operator=(const SONumObj&) {
  OTSO_UNDEFINED("SONumObj::operator=(const SONumObj&)");
}

#endif


/******************** statbool.cxx ********************************/

StatBool::StatBool()
{
	schp	= new SampledContHg(-.5, 1.5, 1.0);
	setSampledCont(schp);
}

StatBool::~StatBool()
{
	delete schp;
}

void StatBool::operator=(boolean b)
{
	val = b;
#if SIMULATING
	NumObj::operator=((double) b);
#endif
}

#if SIMULATING

SimObs* StatBool::createSimObs()
{
	return new SOStatBool(this);
}

StatBool::StatBool(const StatBool& i)
      : val(i.val)
{
	schp	= new SampledContHg(-.5, 1.5, 1.0);
	setSampledCont(schp);
}

StatBool& StatBool::operator=(const StatBool& r) {
	val = r.val;
	//schp not copied, see destructor
#if SIMULATING
	NumObj::operator=(r);
#endif
	return *this;
}

void SOStatBool::print(Ostream&) {}

double SOStatBool::perCentOfValue(boolean b) {
  return ((SampledContHg*) sampledCont())->perCentOfSimilar((double) b); 
}

SOStatBool::SOStatBool(const SOStatBool& i): SONumObj(i) {
  OTSO_UNDEFINED("SOStatBool::SOStatBool(const SOStatBool&)");
}

void SOStatBool::operator=(const SOStatBool&) {
  OTSO_UNDEFINED("SOStatBool::operator=(const SOStatBool&)");
}

#endif


#endif	/*SIMULATING*/
