/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.runner.cxx
 * Vers: 5.3    Time: 92/08/31, 13:51:21
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)runner.cxx	5.3 92/08/31";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	runner.cxx
*
* PURPOSE
*	A runner is an object that gets execution time
*	to "run".
*
* MODIFICATIONS
* BUGS
*	? Add #if TRACING if (trace. ...) ... #endif wrappers 
*	OR define trace.actions etc. is const false.
**********************************************************************/

#define AGENT_HXX	1	/*inline Message::destProcess()*/
#define CHANNEL_HXX	1
#define FIFO_HXX	1	/*GroupPointer op>>*/
#define GROUP_HXX	1
#define INTA_HXX	1
#define MESSAGE_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define PRIORVEC_HXX	1	/*GroupPointer op>>*/
#define PROCESS_HXX	1
#define RING_HXX	1	/*GroupPointer op>>*/
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1	/*TIME *MJS* changes - jfr! */
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /**** dout << "### runner.cxx - " << xxx << "\n"; ****/
#define JUHA_DEBUG(xxx)  /***/ if (otsoJuhaIsDebugging) dout << "#runner.cxx - Juha# - " << name() << " " << xxx << "\n" /***/

/*******************************************************************/

Object dummyObject;      
Runner dummyRunner;
Objectifier nullOtsoObjectifier(&dummyObject); 
                                 //used in AbsoluteDataMember::memberObject*.
                                 //dummyObject must be initialized before this.
Scheduler* scheduler = 0;
Runner* Runner::lastConstructedRunner=NULL;

RunnerSP::RunnerPriority otsoRunnerPriority(Runner*) {
  return RunnerSP::defaultRunnerPriority;
}

/************ RunnerTrace ******************************************/

/*The default trace setting of Runners*/

RunnerTrace::RunnerTrace()
{
  setDefault();
}

RunnerTrace::~RunnerTrace() {}

String RunnerTrace::className() const {
  return "RunnerTrace";
}

void RunnerTrace::print(Ostream& o) {
  o << "{";
  if (running)		o << "running ";
  if (variablesBefore)	o << "variablesBefore ";
  if (receiving)	o << "receiving ";
  if (inputParameters)	o << "inputParameters ";
  if (actions)		o << "actions ";
  if (sending)		o << "sending ";
  if (outputParameters)	o << "outputParameters ";
  if (variablesAfter)	o << "variablesAfter ";
  if (verbose)		o << "verbose";
  o << "}";
}

void RunnerTrace::ask(Istream& i) {
  Ostream& o = dout; //?
  boolean yes;
  o << "{\n";
  o.addIndent(+2);
  o << INDENT << *this << "\n";
  o << INDENT << "Do you want to change this RunnerTrace? (0/1) "; i >> yes;
  if (yes) {
    o.addIndent(+2);
    o << INDENT << "running ";		i >> running;
    o << INDENT << "variablesBefore ";	i >> variablesBefore;
    o << INDENT << "receiving ";	i >> receiving;
    o << INDENT << "inputParameters ";	i >> inputParameters;
    o << INDENT << "actions ";		i >> actions;
    o << INDENT << "sending ";		i >> sending;
    o << INDENT << "outputParameters ";	i >> outputParameters;
    o << INDENT << "variablesAfter ";	i >> variablesAfter;
    o << INDENT << "verbose ";		i >> verbose;
    o << INDENT << *this << "\n";
    o.addIndent(-2);
  }
  o.addIndent(-2);
  o << INDENT << "}\n";
}

async RunnerTrace::allOn() {
  running = variablesBefore = receiving = inputParameters = 
    actions = sending = outputParameters = variablesAfter = verbose = true;
}

async RunnerTrace::allOff() {
  running = variablesBefore = receiving = inputParameters = 
    actions = sending = outputParameters = variablesAfter = verbose = false;
}

async RunnerTrace::setDefault() {
  running = true;
  variablesBefore = true;
  receiving = false;
  inputParameters = true;
  actions = true;
  sending = true;
  outputParameters = false;
  variablesAfter = false;  
  verbose = true;
}

//IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerTrace,...) is in inta.cxx

/************ RunStatus ******************************************/

//Ostream& operator<<(Ostream& os, RunStatus& r) {
//  return os << (RunStatus::RunStatusValue)r;
//}

IMPLEMENT_OTSO_PAED_FOR(RunStatus, 0,0,0,0,
  ( OTSO_DATA_MEMBER(RunStatusValue,val,"")
  )
);

void RunStatus::operator=(RunStatus::RunStatusValue v) {
  val = v;
#if (SIMULATING || STATISTICS)
  NumObj::operator=((double) v);
#endif
}

void RunStatus::operator=(const RunStatus& v) {
  val = v.val; 
#if (SIMULATING || STATISTICS)
  //schp not assigned
  NumObj::operator=((double) v);
#endif
}

RunStatus::RunStatus() {
#if (SIMULATING || STATISTICS)
  schp	= new SampledContHg(-.5, (int) _lastRunStat - 0.5, 1.0);
  setSampledCont(schp);
#endif
}

  //?, added by Juha
RunStatus::RunStatus(const RunStatus& i)
  : val(i.val)
{
#if (SIMULATING || STATISTICS)
  schp	= new SampledContHg(-.5, (int) _lastRunStat - 0.5, 1.0);	//!
  setSampledCont(schp);
#endif
}

  //?, added by Juha
RunStatus::RunStatus(RunStatus::RunStatusValue i)
  : val(i) 
{
#if (SIMULATING || STATISTICS)
  schp	= new SampledContHg(-.5, (int) _lastRunStat - 0.5, 1.0);
  setSampledCont(schp);
#endif
}

RunStatus::~RunStatus() {
#if (SIMULATING || STATISTICS)
  delete schp;
#endif
}

#if SIMULATING

SimObs* RunStatus::createSimObs() {
  return new SORunStatus(this);
}

void SORunStatus::print(Ostream& os) {
  os << INDENT;
  os << form("Status: %6.2f %% B, %6.2f %% E, %6.2f %% I, %6.2f %% R\n",
			perCentOfValue(RunStatus::blocking),
			perCentOfValue(RunStatus::enabled),
			perCentOfValue(RunStatus::idle),
			perCentOfValue(RunStatus::running));
}

#endif

/*********** GroupPointer ******************************************/

IMPLEMENT_OTSO_INTERNALS_FOR(GroupPointer,operator<<,operator>>,operator<<,operator>>);
Ostream& operator<<(Ostream& os, GroupPointer& gp) {
  if (gp) 
    os << gp->className() << *gp;
  else 
    os << "(no Group)";
  return os;
}
Istream& operator>>(Istream& is, GroupPointer& gp) {
  Ostream& os = *is.tiedTo();
  os << INDENT << "Now: ";
  os << gp << "\n";

  os.addIndent(+2);
  os << INDENT << "New group type?:\n";
  os << INDENT << "(Fifo, Lifo, Ring, PriorVec, FairPriorVec, Heap, noQueue, or noChanges)\n" << INDENT;
  String choice;
  is >> choice;
  Group* newQ = 0;

  if      (choice == "Fifo") newQ = new Fifo;
  else if (choice == "Lifo") newQ = new Lifo;
  else if (choice == "Ring") newQ = new Ring;
  else if (choice == "Heap") newQ = new Heap;

  else if (choice == "PriorVec" || choice == "FairPriorVec") {
    os << INDENT << "Number of priorities? (1-5) ";
    sint16 numberOfPriorities = 0;
    const sint16 limit = 5;	//5 == number of PriorVec ctor arguments
    Group* t[limit];		
    for (int i = 0; i < limit; i++) t[i] = 0;
    is >> numberOfPriorities;
    if (numberOfPriorities < 1) numberOfPriorities = 1;
    if (numberOfPriorities > limit) numberOfPriorities = limit;
    OTSO_WARNING("It is easy to crash OTSO by changing the input queues");
    os << INDENT << "Now I will ask you the type of each element Group in PriorVec.\n";
    os << INDENT << "0 is highest priority, " << numberOfPriorities-1 << " lowest.\n";
    os.addIndent(+4);
    for (i = 0; i < numberOfPriorities; i++) {
      os << "\n" << INDENT << "Group for priority " << i << ":\n";
      is >> t[i];	//recursion
    }
    os.addIndent(-4);

    if (choice == "PriorVec") 
      newQ = new PriorVec(t[0],t[1],t[2],t[3],t[4]);
    if (choice == "FairPriorVec")
      newQ = new FairPriorVec(t[0],t[1],t[2],t[3],t[4]);
  } //PriorVecs

  if (gp && newQ) {
    boolean first = true;
    Runner* e = 0;
    for (gp->getAnyway(e); e != &dummyRunner; gp->getAnyway(e)) {
      if (first)
        os << "\n" << INDENT << "Attempting to move the elements to the new queue. The result may be incorrect.\n";
      first = false;
      newQ->putAnyway(e);
      dout << INDENT << e->name() << " moved\n";
    }
  }
  
  if (newQ || choice == "noQueue") {
    delete gp;
    gp = newQ;
  }
  dout << INDENT << "Now: " << gp << "\n";
  os.addIndent(-2);

  return is;
}
ODump& operator<<(ODump& od, GroupPointer& gp) {
  if (gp) od << *gp;
  return od;
}
IDump& operator>>(IDump& id, GroupPointer& gp) {
  if (gp) id >> *gp;
  return id;
}

/************* Runner *************************************************/

String Runner::className() const {
  return "Runner";
}

Runner::~Runner() {
  //inQ() is NOT deleted, because constructor does not allocate it.
  //The one who allocates inQ() should also delete it.
}

Runner::Runner(Group* i)
     : numberOfSuspendedMessages(0) // *MJS* + Juha ?
{
  priority_ = RunnerSP::defaultRunnerPriority;
  setInQ(i);
  runStatus = RunStatus::idle;
  myScheduler_ = ::scheduler; //?, override later if not true
  Runner::lastConstructedRunner = this;
  myMemory_ = thisProcess;	//distribution

#if SIMULATING
  useImplDelay = false;
  iDelStart.reset();
#endif
  childCount = 0;

}

/* declaration of Runner static data member */
char* Runner::mybanner = "\n\n%******************************************************************************%\n";

void Runner::bannerIt(Ostream& os, char* s) {
  os << Runner::mybanner;
  os << "% " << s;
}

Group* Runner::inQ() const {return iQ;}

void Runner::setInQ(Group* q) {
  iQ = q;
#if SIMULATING
  if (countSimExpSet())		//If statistics is gathered for a Runner,
    iQ->countSimExp();		//then it is gathered for input queue as well.
#endif
}

void Runner::run() {
  if (!iQ) return;

  Ostream& os = dout; 
  if (trace.verbose)
    this -> bannerIt(os, "OTSO RUN FUNCTION TRACING\n\n");

  //if (trace.running) 
    //os << INDENT << "NOW RUNNING\t\t\t: " << this->name() << "\n";
  if (trace.variablesBefore) {
    os << INDENT << name() << " VARIABLES BEFORE RUNNING: ";
    NamedObj::print(os);
    os << "\n";
  }

  Runner *msg;	
  iQ->get(msg);
  if (msg == &dummyRunner) 
    runStatus = RunStatus::idle;	//redefine run() if not ok
  else {
    if (trace.inputParameters)
      os << INDENT << "INPUT PARAMETERS\t: " << *msg << "\n";
    else if (trace.receiving) {
      os << INDENT << "RECEIVED MESSAGE\t: ";
      msg->printNameFromTo(os);	
      os << "\n";
    }
    

    if (trace.verbose)
      this -> bannerIt(os, "OTSO RUNNER ACTIONS TRACING\n\n");
    if (trace.actions)
      os << INDENT << "ACTIONS WHEN RUNNING\t: " << name() 
	           << " " << msg->name() << ": {\n";
    os.addIndent(+2);
    msg->runStatus = RunStatus::running;
    msg->run();		
    os.addIndent(-2);

    requestScheduling();
    if (trace.actions)
       os << INDENT << "}\n";

    if (trace.verbose) {
      os << "\n% END OF RUNNER ACTIONS TRACING\n";
      os << (char*)(&this -> mybanner[2]) << "\n";	// skip leading \n
    }

  } 

  if (trace.variablesAfter)
    os << INDENT << name() << " VARIABLES AFTER RUNNING: {\n" << *this << "\n}\n";
}

void Runner::run1() {
  run();						//virtual
}

void Runner::rerun() {
  OTSO_ERROR( className() << "::rerun() not implemented - nothing done" );
}

void Runner::requestScheduling() {
  if (iQ->isEmpty())
    runStatus = RunStatus::idle;
  else {
    runStatus = RunStatus::enabled;
    myScheduler()->runOrQueue(*this);
  }
}

void Runner::delay(Time d, Runner* r) {	/* *MJS* changes - jfr&Juha */
#if SIMULATING
  Runner* s = myScheduler();
  if (!s || s == &dummyRunner 
      || s == this)			//Juha 24.4.92
    OTSO_WARNING(name() << ": no virtual clock encountered, delay() skipped");
  else {
    if (trace.actions)
      dout << INDENT << name() << ": delay " << d << "\n";
    s->delay(d, r);
  }
#endif
}

void Runner::runOrQueue(Runner& r) {
  // r may be a Message to be handled or a Runner to be scheduled
  if (!iQ || r.priority() >= runImmediately) {
    // probably a message
    if (runStatus == RunStatus::running) 
      OTSO_WARNING("Running " << name() << " recursively");
    r.run();
  }
  else {
    iQ->put(&r);
    if (runStatus == RunStatus::idle) {
      runStatus = RunStatus::enabled;
      myScheduler()->runOrQueue(*this);
    }
  }
}

void Runner::sendOrQueue(Message& m) {

  Ostream& os = dout; // *process()->readsFrom(); //?

  if (trace.sending || trace.outputParameters) {

    if (trace.verbose)
      this -> bannerIt(os, "OTSO MESSAGE SEND TRACING\n\n");

    if (trace.outputParameters) {	//print sending time
      char* s = time().asctime();	//some implementation in all OSs?
      if (trace.verbose) 
	os << INDENT << "TIME\t\t\t: " << s << "\n";
      else {
	s[strlen(s)-1] = ' ';		//overwrite '\n'
	os << INDENT << s << " ";
      }
    }

    os << INDENT << "SENDING MESSAGE\t: ";
    if (m.isReturnMsg)
      m.print(os);
    else
      m.printNameFromTo(os);
    os << "\n";
  }
  if (trace.outputParameters) {
    os << INDENT << "OUTPUT PARAMETERS\t: " << m << "\n";
  }

  if (m.isReturnMsg) {
    if (m.destProcess()->local()) {
      JUHA_DEBUG( m.dest()->myScheduler()->name() << ".receivedMessageId = " << m.id() );
      //m.dest()->myScheduler()->receivedMessageId = m.id();
      if (m.priority() < runImmediately)	//Juha 14.5.92
	m.wakeup((Runner*)0);			//not UI msg, 0 not used
    }
    else {
      m.sendViaChannel();
    }
  }
  else {
    m.id_ = myScheduler()->numberOfSuspendedMessages + 1;	
    //++ in ... iff sync msg
    JUHA_DEBUG( m.name() << " " << (long)&m << " id_ = " << m.id_ );
    m.Message::send();
  }
}

Process*& Runner::process() const {
  if (myMemory_ != 0)
    return myMemory_;
  else
    return thisProcess;
}

Runner& Runner::schedules(Runner* r1, Runner* r2, Runner* r3,
			  Runner* r4, Runner* r5, Runner* r6) {
  schedule(r1);
  schedule(r2);
  schedule(r3);
  schedule(r4);
  schedule(r5);
  schedule(r6);

  return *this;
}

void Runner::schedule(Runner* r) {
  if (!r) return;
  if (childCount < MAX_CHILDREN)
    children[childCount++] = r;
  else
    OTSO_WARNING(className() << "::schedule(" << r->name() << "): children array overflow.");
  r->initScheduling(this);
}

void Runner::initScheduling(Runner* mySched) {  // *MJS* added.
  myScheduler_ = mySched;
}


void Runner::printNameFromTo(Ostream& os) { os << name(); }

void Runner::print(Ostream& os) {
  NamedObj::print(os);
}

async Runner::timeout(sint32 id) {
  Object::timeout(id);
}

Time& Runner::time() {			/* *MJS* changes - jfr! */
  if (!myScheduler_ || myScheduler_ == &dummyRunner
        || this == ::scheduler		//?, Juha 17.3.92
      ) 
  {
    return Object::time();
  }
  else {
    return myScheduler_->time();
  }
}

void Runner::setMinTimer(Time t) {
  myScheduler()->setMinTimer(t);
}

Time& Runner::getMinTimer() {
  return myScheduler()->getMinTimer();
}

boolean Runner::greaterThan(Runner&) {
  this -> undefined("greaterThan(Runner&)");
  return false;
}

Runner* Runner::myScheduler() const {
  if (!myScheduler_)
    OTSO_WARNING( name() << " has no scheduler.  myScheduler() returns 0 pointer." );
  return myScheduler_;
}

#if 1
MsgId Runner::getMsgId() {
  OTSO_WARNING(className() << " " << name() << ": getMsgId() should not be called; 0 returned");
  return 0;
}

ReturnValue Runner::getReturnValue(MsgId) {
  OTSO_WARNING(className() << " " << name() << ": getReturnValue() should not be called; 0 returned");
  return 0;
}

void Runner::setReturnValue(MsgId i, ReturnValue retVal) {
  OTSO_WARNING(className() << " " << name() << ": setReturnValue() should not be called.");
}


MsgId Scheduler::getMsgId() {
  // ?: s/msgsWaitedNow/numberOfSuspendedMessages/
  // ?: s/returnMessages/suspendedMessages/
  if (numberOfSuspendedMessages+1 < MAX_MSGS_WAITED) 
    suspendedMessages[++numberOfSuspendedMessages] = 0;		//++!
  else
    OTSO_ERROR(name() << "::getMsgId(): too many (" << numberOfSuspendedMessages << ") messages suspended.");
  JUHA_DEBUG("numberOfSuspendedMessages now " << numberOfSuspendedMessages);
  JUHA_DEBUG("getMsgId returns " << numberOfSuspendedMessages);
  return numberOfSuspendedMessages;
}

ReturnValue Scheduler::getReturnValue(MsgId msgId) {
  //If recursive scheduler => (msgId == numberOfSuspendedMessages) 
  //and msgId is useless here.
  ReturnValue ret = suspendedMessages[numberOfSuspendedMessages];
  JUHA_DEBUG(" getReturnValue(" << msgId << ") resets suspendedMessages[" << numberOfSuspendedMessages << "]");
  suspendedMessages[numberOfSuspendedMessages--] = 0;
  JUHA_DEBUG( "numberOfSuspendedMessages now " << numberOfSuspendedMessages );
  JUHA_DEBUG(" now " << *this);
  return ret;
}

void Scheduler::setReturnValue(MsgId i, ReturnValue retVal) {	//?
  //do we need this fn?
  JUHA_DEBUG("Risky type cast from void* to Message*"); 
  suspendedMessages[i] = (Message*)retVal;
  JUHA_DEBUG(" now " << *this );
}
#endif

Message*& Runner::suspendedMessage(MsgId id) {
  OTSO_WARNING(className() << " " << name() << ": suspendedMessage() should not be called; 0 returned.");
  return 0;
}

void Runner::runUntilIsReturnMsg(Message* m) {
  OTSO_ERROR("Runner::runUntilIsReturnMessage() should not be called.  "
	     << "Message = " << *m );
}

/*********** Scheduler *************************************************/

void Scheduler::runUntilIsReturnMsg(Message* m) {
  JUHA_DEBUG("runUntilIsReturnMsg(" << m->name() << ")");
  //numberOfSuspendedMessages++;
  OTSO_ASSERT(m && m->id() > 0 && m->id() <= numberOfSuspendedMessages);
  JUHA_DEBUG( " ?? suspendedMessages[" << m->id() << "] = " << (long)m );
  suspendedMessages[m->id()] = m;
  JUHA_DEBUG(" now " << *this);
  rerun();

  OTSO_ASSERT(suspendedMessages[receivedMessageId] == m);
  //suspendedMessages[numberOfSuspendedMessages--] = 0;
}

Message*& Scheduler::suspendedMessage(MsgId id) {
  if (id <= 0 || id > numberOfSuspendedMessages) {
    OTSO_WARNING("Scheduler::suspendedMessage(" << id << "): index out of range.  0 returned.");
    return 0;
  }
  else
    return suspendedMessages[id];
}

String Scheduler::className() const {
  return "Scheduler";
}

#if 0	/* *MJS* changes started - jfr! */
Time& Scheduler::time() {
  return systime();
}
#endif

void Scheduler::setMinTimer(Time t) {
  minTimer = t; 
}

Time& Scheduler::getMinTimer() {
  return minTimer;
}

Scheduler::Scheduler()
     : recLevel(1)
#if SIMULATING
     , started((uint32)0)
#endif
     , blockedRunner(0)
{
  myScheduler_ = 0;
  runStatus = RunStatus::enabled;
  minTimer.reset();
#if SIMULATING
  useImplDelay = false;
  calcImplDelays(false);
#endif
}

void Scheduler::run1() {
  iQ->get(execRunner);
  if (execRunner->runStatus == RunStatus::enabled) {
    execRunner->runStatus = RunStatus::running;
    started = time();			//only #if SIMULATING ?
    if (execRunner->trace.running)
      dout << INDENT << name() << ": RUNNING\t  " << execRunner->name() << "\n";

#if SIMULATING
                //At this moment the implicit delay counting is the 
                //responsibility of the Scheduler objects under the vthreads.
    if (calcImplDelays())
      execRunner->startIDel();
#endif

    execRunner->run();
                //execRunner->run() should set execRunner->runStatus 
                //idle or enabled depending on execRunner->inQ.

#if SIMULATING
    if (calcImplDelays()) {
      execRunner->stopIDel("after running " + execRunner->name());
      if (trace.actions)
	dout << name() << ": time profile; ["
	     << started << "->" << time() 
	     << "] " << execRunner->name() << "\n";
    }
#endif

    if (execRunner->runStatus == RunStatus::running) {
      JUHA_DEBUG(name() << " changed " << execRunner->name() << "'s runStatus from running to enabled." );
      execRunner->runStatus = RunStatus::enabled; //14.5.92 again on
    }
  }
  else if (trace.actions)
    dout << execRunner->name() << " not enabled, not run.\n";//dout << execRunner->name() << " is " << runStatus << ". Not enabled, not run.\n";
}

void Scheduler::run() {
  runStatus = RunStatus::running;
  Runner* runnerBlockedAtThisRecursionLevel = 0;

  if (trace.running) 
    dout << name() << " running at recursion level #" << recLevel-1 << "\n";
  runnerBlockedAtThisRecursionLevel = this->blockedRunner;
  this->blockedRunner = 0;

  if (!inQ())
    OTSO_ERROR("Scheduler " << name() << " should have an input queue; try calling setInQ().");
  else {
    if (runnerBlockedAtThisRecursionLevel) {
      JUHA_DEBUG("run until time to schedule " << runnerBlockedAtThisRecursionLevel->name());
      while (iQ->head() != runnerBlockedAtThisRecursionLevel) {
	JUHA_DEBUG(name() << " iQ head() : " << iQ->head()->name());
	Scheduler::run1();
      }
    }
    else {	//wait for return message
      JUHA_DEBUG("run until suspendedMessages[" << numberOfSuspendedMessages << "] isReturnMsg");
      //while (blockedRunner->runStatus != RunStatus::enabled) 
      while (!numberOfSuspendedMessages || 
	     !suspendedMessages[numberOfSuspendedMessages]->isReturnMsg) 
	{
	  Scheduler::run1();
	}
      OTSO_ASSERT(receivedMessageId > 0);
      //if (numberOfSuspendedMessages==MAX_MSGS_WAITED) ...run only receivers?...
    }
  }
  if (trace.running)
    dout << name() << " leaving recursion level #" << recLevel-1 << "\n";
}	

void Scheduler::rerun() {
  suspRunners[recLevel++] = execRunner;

#if SIMULATING
  if (calcImplDelays()) {
    execRunner->stopIDel("because of scheduler recursion");
    if (trace.actions) {
      dout << name() << ": time profile; ["
           << started << "->" << time()
           << "] " << execRunner->name() << "\n";
      dout << name() << ": " << execRunner->name()
           << " is now waiting for return message\n";
    }
  }
#endif

  run();

  execRunner = suspRunners[--recLevel];

#if SIMULATING
  if (trace.actions)
    dout << execRunner->name() << " continuing...\n";
  if (calcImplDelays())
    execRunner->startIDel();
#endif

}

void Scheduler::schedule(Runner* r) {
  Runner::schedule(r);

#if SIMULATING
  // *MJS*: if we gather simulation statistics for a Scheduler object,
  // then, by default, we calculate statistics for all the children
  // under that Scheduler.
  if (countSimExpSet()) r->countSimExp();
#endif
}

void Scheduler::print(Ostream& os) {
  Runner::print(os);
  os << "suspended messages: ";
  for (int i = 0; i < MAX_MSGS_WAITED; i++)
    if (suspendedMessages[i])
      os << suspendedMessages[i]->name() << ",";
    else
      os << ".";
  os << "\n";
}

/*********** Objectifier member functions ********************************/

String Objectifier::className() const {
  return "Objectifier";
}

Objectifier::Objectifier(Object* o)
     : object_(o)
     , instance_(o? o->otsoMostDerivedPointer(): 0)
     , type_(o? &o->otsoType(): 0) 
     , allocatedFromFreeStore_(false)
     , isMessage_(false)
{
  if (!o) OTSO_WARNING( "Constructing Objectifier from (Object*)0\n" );
  trace.running = false;
  trace.variablesBefore = false;
  trace.receiving = false;
  trace.inputParameters = false;
  trace.actions = false;			
  trace.sending = false;
  trace.outputParameters = false;
  trace.variablesAfter = false;
  trace.verbose = false;
}

Objectifier::Objectifier(void* p, Type* type)
     : instance_(p)
     , object_(0)
     , type_(type) 
     , allocatedFromFreeStore_(true)
     , isMessage_(false)
{
  trace.running = false;
  trace.variablesBefore = false;
  trace.receiving = false;
  trace.inputParameters = false;
  trace.actions = false;			
  trace.sending = false;
  trace.outputParameters = false;
  trace.variablesAfter = false;
  trace.verbose = false;
}

void Objectifier::print(Ostream& os) {
  BUGOUT( "### Objectifier: & = " << (long)this << ",o_= " << (long)object_ << ",i_= " << (long)instance_ << ",t = " << type_->name() << ",n_= " << name() << " ### " );
  if (object_) object_->print(os);
  if (object_) os << object_->name();
  else type_->print(os, instance_);
}

void Objectifier::ask(Istream& is) {
  if (object_) object_->ask(is);
  else type_->ask(is, instance_);
}

void Objectifier::printMsgs(Ostream* os, boolean help) {
  type_->printMsgs(os, help);
}

void otsoPrintObjectifier(Ostream& os, Objectifier& ofier) {
  dout << "otsoPrintObjectifier here\n";
  ofier.print(os);
}

HardType type_Objectifier("Objectifier",
			  (OtsoPrintFnPointer)otsoPrintObjectifier,
			  0
			 );

Objectifier& Objectifier::operator+=(Offset offset) {
  instance_ = (char*)this->instance_ + offset;
  return *this;
}

Type& Objectifier::otsoType() {
  return *type_;
}

void Objectifier::setType(Type* t) {
  type_ = t;
}

void* Objectifier::otsoMostDerivedPointer() {
  return instance_;
}

void Objectifier::setInstance(void* p) {
  instance_ = p;
}

Objectifier operator+(const Objectifier& o, Offset offset) {
  Objectifier ret = o;
  ret.setInstance( (char*)o.otsoMostDerivedPointer() + offset );
  return ret;
}

Object* Objectifier::object() {
  return object_;
}

void Objectifier::setObject(Object* o) {
  object_ = o;
}

Member Objectifier::runUI(Objectifier sp, String prompt, String memberName) {
  Member ret = 0;
  if (isMessage_) 
    ret = object_->runUI(sp, prompt, memberName);
  else
    ret = Object::runUI(sp, prompt, memberName);
  return ret;
}

void Objectifier::setIsMessage(boolean is) {
  isMessage_ = is;
}

boolean Objectifier::isMessage() {
  return isMessage_;
}


RunnerSP::RunnerSP() {}

/* C++ compiler should generates these, but they seem to be unreliable... */

RunnerSP::RunnerSP(const RunnerSP& i) {
  *this = i;
}

RunnerSP& RunnerSP::operator=(const RunnerSP& r) {
  trace = r.trace;	
  priority_ = r.priority_;	
  runStatus = r.runStatus;
  iQ = r.iQ;
  return *this;
}

Runner& Runner::operator=(const Runner& r) {
  *(NamedObj*)this = r;
  *(RunnerSP*)this = r;
  myScheduler_ = r.myScheduler_;
  myMemory_ = r.myMemory_;
  execRunner = r.execRunner;
#if SIMULATING 
  useImplDelay = r.useImplDelay;
  iDelStart = r.iDelStart;
  counting = r.counting;
  toQueue = r.toQueue;
#endif
  {for (int i = 0; i < MAX_CHILDREN; i++) children[i] = r.children[i];}
  childCount = r.childCount;
  numberOfSuspendedMessages = r.numberOfSuspendedMessages;
  receivedMessageId = r.receivedMessageId;
  return *this;
}

Objectifier& Objectifier::operator=(const Objectifier& r) {
  Runner::operator=(r);
  instance_ = r.instance_;
  object_ = r.object_;
  type_ = r.type_;
  allocatedFromFreeStore_ = r.allocatedFromFreeStore_;
  isMessage_ = r.isMessage_;
  return *this;
}


#if SIMULATING
/**********************************************************************
Simulation code for Runner, Scheduler, ...
**********************************************************************/

void Runner::startIDel() {
#if SIMULATING
  if (!useImplDelay) 
    return;
  if (trace.actions)
    dout << name() << ": implicit delay counting started...\n";
  iDelStart = cpuTime();
#endif
}

void Runner::stopIDel(const String& m) {
#if SIMULATING
  if (!useImplDelay || !iDelStart.isSet()) 
    return;
  if (trace.actions)
    dout << name() << ": implicit delay " << m << " follows...\n";
  delay(cpuTime() - iDelStart);
#endif
}

VThread* Runner::vThread() {
  return myScheduler()->vThread();
}

/******* Statistics from Runner *************************************/

void Runner::countSimExp(boolean b) {
  StatObj::countSimExp(b);
  runStatus.countSimExp(b);
  if (iQ) iQ->countSimExp(b);
}

void Runner::startSimExp() {
  StatObj::startSimExp();
}

void Runner::finishSimExp() {
  StatObj::finishSimExp();
}

SimObs* Runner::createSimObs() {
  return new SORunner(this);
}

SORunner::SORunner(Runner* r) {
  rName     = r->name();
  runStatus = (SORunStatus*) r->runStatus.getSimObs();
  rInQ      = r->inQ() ? (SOGroup*) r->inQ()->getSimObs() : 0;
}

SORunner::~SORunner() {}

void SORunner::print(Ostream& os) {
  os << INDENT << "Runner " << rName << ": "
     << form("%6.2f %% E, %6.2f %% I, %6.2f %% R\n",	//more verbose?
             runStatus->perCentOfValue(RunStatus::enabled),
             runStatus->perCentOfValue(RunStatus::idle),
             runStatus->perCentOfValue(RunStatus::running));
  if (rInQ) {
    os << INDENT << "Input queue:\n";
    rInQ->print(os);
  }
}

VThread* Scheduler::vThread() {
  if (myScheduler_ == 0 || myScheduler_ == (Runner*)this)
    return 0;
  else
    return myScheduler_->vThread();
  //return myScheduler_ ? myScheduler_->vThread() : 0; //juha changed
}

void Scheduler::countSimExp(boolean b) {
  StatObj::countSimExp(b);
  for (uint16 i = 0; i < childCount; i++)
    children[i]->countSimExp(b);
}

SimObs* Scheduler::createSimObs() {
  return new SOScheduler(this);
}

SOScheduler::SOScheduler(Scheduler* s)
     : SORunner(s)
     , childCount(s->childCount)
{
  for (uint8 i = 0; i < childCount; i++)
    children[i] = (SORunner*) s->children[i]->getSimObs();
}

void SOScheduler::print(Ostream& os) {
  for (uint16 i = 0; i < childCount; i++) {
    if (children[i]) {
      children[i]->print(os);
      os << "\n";
    }
  }
}


#endif /*SIMULATING*/




