/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.ring.cxx
 * Vers: 5.2    Time: 92/08/04, 12:21:58
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)ring.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	ring.cxx
*
* PURPOSE
*	container class of objects implemented in a permanent
*	circular ring.
**********************************************************************/

#define FIFO_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RING_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */



String Ring::className() const {
  return "Ring";
}

Ring::Ring(): current(0) {}

sint32 Ring::dynamicSize() const {return 0;}

Group& Ring::myPut(const GE) {
  return *this;
}

Group& Ring::putAnyway(const GE e) {
  Fifo::myPut(e);
  return *this;
}

Group& Ring::getAnyway(GE& e) {
  Fifo::myGet(e);
  return *this;
}

Ring& Ring::ringPut(const GE e) {
  OTSO_WARNING("Use Ring::putAnyway() instead of Ring::ringPut()");
  putAnyway(e);
  return *this;
}

Group& Ring::myGet(GE& e) {
  if (current == NULL || (current = ((Link*)current)->next) == NULL)
    e = first(current);
  else
    e = ((Link*)current)->element;
  return *this;
}

void Ring::reset() {
  FOR_EACH_runner_IN(*this) 
    runner->reset();
}

//this is here to implement head() correctly.
//should be head(), head() should be virtual!
GE Ring::first(GP& gp) {
  if (&gp == &dummyGP) {	//called from head().  (((ugly tmp fix)))
    void* cur = this->current;
    GE ret = 0;
    if (cur == NULL || (cur = ((Link*)cur)->next) == NULL)
      ret = Fifo::first(cur);
    else
      ret = ((Link*)cur)->element;
    return ret;
  }
  else
    return Fifo::first(gp);
}
