/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.priorvec.cxx
 * Vers: 5.2    Time: 92/08/04, 12:21:54
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)priorvec.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	priorvec.cxx
*
* PURPOSE
*	A priority vector container class for objects.
* 	PriorVec is a priority vector of Groups.  
* 	The number of priorities (1..5) is fixed in the constructor.
* 	Objects are put into and get from the element Groups.
* 
* BUGS
* MODIFICATIONS
**********************************************************************/


#define CHANNEL_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define PRIORVEC_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */



String PriorVec::className() const {
  return "PriorVec";
}

PriorVec::PriorVec(Group* g0, Group* g1, Group* g2,
		   Group* g3, Group* g4) {
  gp[0] = g0;
  gp[1] = g1;
  gp[2] = g2;
  gp[3] = g3;	
  gp[4] = g4;
  gp[5] = 0;	// [priorVecSize - 1]
}

Group& PriorVec::myPut(const GE o) {
  // check that o is Runner
  //Runner::RunnerPriority p = o->priority();
  if (o->priority() >= 0 && o->priority() < priorVecSize && gp[o->priority()]) {
    gp[o->priority()]->put(o);
    size_++;
  }
  else
    OTSO_WARNING( o->name() << "priority " << long(o->priority()) << " out of range: discarded");
  // only one level of PriorGroups!
  return *this;
}

Group& PriorVec::putAnyway(const GE o) {
  //the same as put() put calls putAnyway
  if (o->priority() >= 0 && o->priority() < priorVecSize && gp[o->priority()]) {
    gp[o->priority()]->putAnyway(o);
    size_++;
  }
  else
    OTSO_WARNING( o->name() << "priority " << long(o->priority()) << " out of range: discarded");
  // only one level of PriorGroups!
  return *this;
}

Group& PriorVec::myGet(GE& o) {
  for(sint16 i = 0; gp[i]; i++) {
    gp[i]->get(o);
    if (o != &dummyRunner) {
      size_--;
      return *this;
    }
  }
  o = &dummyRunner;
  return *this;
}

Group& PriorVec::getAnyway(GE& o) {
  //the same as get() but calls getAnyway
  for(sint16 i = 0; gp[i]; i++) {
    gp[i]->getAnyway(o);
    if (o != &dummyRunner) {
      size_--;
      return *this;
    }
  }
  o = &dummyRunner;
  return *this;
}

GE PriorVec::first(GP& link) {
  GE ret;
  for(sint16 i = 0; gp[i]; i++) {
    ret = gp[i]->first(link);
    this->currentGroupIndex = i;
    if (ret != &dummyRunner)
      return ret;
  }
  this->currentGroupIndex = -1;
  return &dummyRunner;
}

GE PriorVec::next(GP& link) {
    GE ret;
    while (this->currentGroupIndex >= 0 && gp[currentGroupIndex]) {
      if (!gp[this->currentGroupIndex]->over(link)) {
	ret = gp[this->currentGroupIndex]->next(link);
	if (ret != &dummyRunner)
	  return ret;
      }
      else {
	this->currentGroupIndex++;
	if (gp[currentGroupIndex]) {
	  ret = gp[this->currentGroupIndex]->first(link);
	  if (ret != &dummyRunner)
	    return ret;
	}
      }
    }
    return &dummyRunner;
  }

void PriorVec::print(Ostream& os) {
  os << "(\n";
  os.addIndent(+16);
  for (sint16 i = 0; gp[i]; i++) {
    os << INDENT << gp[i] << "\n";		//GroupPointer::print
  }
  os << INDENT << ") "; //size() incorrect, not printed (because of possible Rings)
  os.addIndent(-16);
}

sint32 PriorVec::dynamicSize() const {
  sint32 ret = 0;
  for (sint16 i = 0; gp[i]; i++) {
    ret += gp[i]->dynamicSize();
  }
  return ret;
}

/**********************************************************************/

String FairPriorVec::className() const {
  return "FairPriorVec";
}

FairPriorVec::FairPriorVec(
  Group* g0, Group* g1, Group* g2, Group* g3, Group* g4):
  PriorVec(g0, g1, g2, g3, g4), turn(0)
{}

Group& FairPriorVec::myGet(GE& o) {
  turn = (turn+1) % (1 << (priorVecSize-2));
  o = &dummyRunner;

  if      ((turn & 0x01) && gp[0]) gp[0]->get(o);
  else if ((turn & 0x02) && gp[1]) gp[1]->get(o);
  else if ((turn & 0x04) && gp[2]) gp[2]->get(o);
  else if ((turn & 0x08) && gp[3]) gp[3]->get(o);
  else if ((turn & 0x0F) && gp[4]) gp[4]->get(o);

  if (o == &dummyRunner) {
    PriorVec::myGet(o);
  }
  else
    size_--;
  return *this;
}

Group& FairPriorVec::getAnyway(GE& o) {
  /*The same as get() but calls getAnyway for element groups*/
  turn = (turn+1) % (1 << (priorVecSize-2));
  o = &dummyRunner;

  if      ((turn & 0x01) && gp[0]) gp[0]->getAnyway(o);
  else if ((turn & 0x02) && gp[1]) gp[1]->getAnyway(o);
  else if ((turn & 0x04) && gp[2]) gp[2]->getAnyway(o);
  else if ((turn & 0x08) && gp[3]) gp[3]->getAnyway(o);
  else if ((turn & 0x0F) && gp[4]) gp[4]->getAnyway(o);

  if (o == &dummyRunner) {
    PriorVec::getAnyway(o);
  }
  else
    size_--;
  return *this;
}

/**********************************************************************
* 	Heap member functions
*
*	Algorithms from "Horowitz & Sahni,
*	Fundamentals Of Computer Algorithms", p. 61 - 69.
**********************************************************************/

String Heap::className() const {return "Heap";}

void Heap::adjust(sint32 i) {
  // *MJS* :  n - 1
  sint32 j = 2*i;
  GE item = a[i];
  while (j <= n - 1) {
    if (j < n - 1 && heapElem(j+1)->greaterThan(*heapElem(j)))
      j++;
    if (item->greaterThan (*heapElem(j)))	// >= is OK ?
      break;
    else {
      a[j/2] = a[j];
      j *= 2;
    }
    a[j/2] = item;
  }
}

void Heap::heapify() {
  for (sint32 i = (n - 1)/2; i >= 1; --i)
    adjust(i);
}

Group& Heap::myPut(const GE o) {
  a[n] = (GE)o;
  sint32 j = n;
  sint32 i = n/2;
  GE item = a[n++];
  if (n >= 200)
    OTSO_ERROR( name() << " overflow, now you really must write a better Heap!\n" );
    //allocate an array of double the current size, cp the elements to the
    //new array
  while (i > 0 && item->greaterThan(*heapElem(i))) {
    a[j] = a[i];
    j = i;
    i /= 2;
  }
  a[j] = item;
  size_++;
  return *this;
}

Group& Heap::myGet(GE& o) {
  if (n <= 1)
    o = &dummyRunner;
  else {
    o = a[1];
    a[1] = a[--n];
    //if (space needed) check if ok to replace a by a smaller array
    adjust(1);
    size_--;
  }
  return *this;
}

// *MJS*: rm() function was added to class Heap because of the special
// needs for event list handling in OTSO simulation features. The
// function simply deletes the given GE from Heap.

Group& Heap::rm(const GE o) {
  for (sint32 i = 1; i < n && a[i] != o; i++);
  if (i == n) {
    OTSO_ERROR("Heap::del() parameter not existing in Heap!");
    //exit (1);   // *E* better error handling!?
  }
  for (; i < n - 1; a[i] = a[i + 1], i++);
  --n;
  size_--;
  heapify();
  return (*this);
}

boolean Heap::isEmpty() {
  return (n <= 1);
}

GE Heap::first(GP& l) {
  if (n <= 1) {
    l = 0;
    return &dummyRunner;
  }
  else
    return ((GE)(l = a[1]));
}

GE Heap::next(GP& l) {
  cout << "Sorry, Heap::next(GE&) not implemented\n";
  return ((GE)l);	// ?? jfr
}

void Heap::print(Ostream& os) {
  os << "( ";
  //should print n first and "..." if too many components
  for (sint32 i = 1; i < n; i++) {
    //heapElem(i)->print(os); too verbose
    os << heapElem(i)->name();
    if (i < n-1) os << ", ";
  }
  os << " ) " << size() << " elements  ";
}

Heap::Heap(): n(1), a(new GE[200]) {
}

Heap::~Heap() {
  delete a;
}

Heap::Heap(const Heap&) {
  OTSO_UNDEFINED("Heap::Heap(const Heap&)");
}

void Heap::operator=(const Heap&) {
  OTSO_UNDEFINED("Heap::operator=(const Heap&)");
}


#if SIMULATING		/* *MJS* changes - jfr! */

SimObs* PriorVec::createSimObs()        // *MJS*
{
  return new SOPriorVec(this);
}

// *MJS* added class SOPriorVec.
SOPriorVec::SOPriorVec(PriorVec* pvp)
        : SOGroup(0)
{
  gClassName    = pvp->className();

  for (uint16 i = 0; i < priorVecSize; i++)
    gp[i] = (pvp->gp[i]) ? (SOGroup*) pvp->gp[i]->getSimObs() : 0;
}

void SOPriorVec::print(Ostream& os)
{
  os << INDENT << "- " << gClassName << "\n";
  os.addIndent(2);

  for (uint16 i = 0; gp[i]; i++) {
    os << "Priority " << i + 1 << (i ? ":\n" : " (highest):\n");
    gp[i]->print(os);
  }

  os.addIndent(-2);
}
#endif 	/* SIMULATING */
