/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.message.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:25
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)message.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	message.cxx
*
* PURPOSE 
*	OTSO message class.  Objects, etc can be sent as messages.
*	Messages are used to communicate between OTSO objects/processes,
*	etc that have execution time.
*
* BUGS
* MODIFICATIONS
**********************************************************************/

#define AGENT_HXX	1
#define CHANNEL_HXX	1
#define GROUP_HXX	1
#define MESSAGE_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define PROCESS_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TYPE_HXX	1
#define VOIDGRP_HXX	1	/* din */
#define TIME_HXX	1	/* Time *MJS* changes - jfr! */

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /*** dout << "#dbug message.cxx# - " << xxx << "\n" ***/
#define JUHA_DEBUG(xxx)  /***/ if (otsoJuhaIsDebugging) dout << "#message.cxx - Juha# - " << name() << " " << xxx << "\n" /***/

#if SIMULATING
extern boolean otsoTimedMessageRunUI(Message*);
#endif

/*** *MJS* *******************
*ReturnValue returnMessages[MAX_MSGS_WAITED];
*                           //Table of return values
*Message* messagesWaitingForAReturnValue[MAX_MSGS_WAITED];
*                           //Table of messages waiting for return values
*                           //from remote addr.spaces
*sint32 msgsWaitedNow = 1;  //The scheduler called from main() is
*                           //waiting for exit message ...
*MsgId receivedAnswerMsgId = 0;
*                           //Indicates the slot of returnMessages[] that 
*                           //contains the received answer message.
*                           //See *Scheduler::run(), 
*                           //IDump::run(?), Message::sendAndReturnAValue().
*boolean returnMsgConsumed[MAX_MSGS_WAITED];
*                           //Must be initialized with falses.
*                           //Used also by threads 
*                           //(to see when to start and stop threads).
*****************************/

/********* ??????? ****************************************************/

Ostream& operator<<(Ostream& os, Runner& r) {
  r.print(os); 
  return os;
}
Ostream& operator<<(Ostream& os, Message& m) {m.print(os); return os;}
Istream& operator>>(Istream& is, Message& m) {m.ask(is); return is;}

/**********************************************************************/

#if SIMULATING
class VOstream;
extern Ostream& operator<<(VOstream&, const Object&);
//these because of the following function:
#endif

void Message::sendViaChannel() {
  BUGOUT( "Sending via " <<  destProcess() -> readsFrom() -> name() << "=" <<  *destProcess() -> readsFrom() << "\nmessage\n" << *this );

  JUHA_DEBUG("Risky type cast from readsFrom() to ODump*");
  ODump& od = *(ODump*)destProcess()->readsFrom();	//risky type cast !?
  if (!od.isConnected()) {		//try to connect to a receiving device
    od.connect();
  }

  if (od.isConnected()) {
      //This should be able to choose ostream's virtual encoding function !?
      //Now this cannot do it.
#if SIMULATING	/*Juha 6.5.92*/
      //This is a dirty hack to fix the fact that there is no more 
      //virtual Ostream::operator<<(Object&) 
      //and a redefined function in VOstream.
    JUHA_DEBUG("Risky type cast from readsFrom() to VOstream*");
    VOstream& vos = *(VOstream*)destProcess()->readsFrom();//risky type cast !?
    vos << *(const Object*)this;
#else
    this->to(od);
#endif
  }
  else {
    OTSO_ERROR( "Cannot send via " << od.name() << ", cannot connect to a receiver" );
  }
}

Message* Message::send() {
  isReturnMsg = false;
  Process *proc = destProcess();

  if (proc != NULL) {
    if (destProcess() -> local()) {
      dest() -> server() -> runOrQueue(*this); //why not basic-Channel<< ?
    }
    else {
      sendViaChannel();
    }
  }
  else {
    OTSO_ERROR("NULL destProcess in Message::send().  Send failure.");
  }
  return 0;
}

ReturnValue Message::returnValue() {
  return 0;
}

/**********************************************************************/

Message::Message(): isReturnMsg(false) {
  //setPriority(defaultPriority);
  runStatus = RunStatus::enabled;
  Runner::lastConstructedRunner = 0;	
  //lastConstructedRunner is set in Runner ctor, not good for messages
}

Message::~Message() {}

String Message::name() const {
  return className();
}

String Message::className() const {
  return "Message";
}

/**********************************************************************/

void Message::ask(Istream& is) {
  NamedObj::ask(is);
}

void Message::print(Ostream& os) {
  printNameFromTo(os);
  os << ": ";
  if (isReturnMsg) {
    returnValueType_->print(os, returnValue());
  }
  else
    NamedObj::print(os); //name is printed twice :(
}

void Message::printNameFromTo(Ostream& os) {
  os << className(); 
  if (isReturnMsg)
    os << " (returnValue)";
  if (!sourceName().isEmpty())
    os << " from " << sourceName();
  if (dest()) {
    os << " to " << dest()->name() << " ";
  }
}

void Message::printAndDelete(Ostream& os) {
  os << INDENT << "A message to undefined destination (sink): ";
  print(os);
  os << "  --  deleted\n\n";
  delete this;
}

void Message::to(ODump& od) {

#if 1	/*debug printing*/
  if (!destProcess()) BUGOUT( "ERROR in Message::to: destProcess 0" );
  if (!dest()) BUGOUT( "Message::to: dest() 0" );
  if (!multiPtr()) BUGOUT( "ERROR in Message::to: multiPtr 0" );
  BUGOUT( "Encoding message: " << *this );
  BUGOUT( "procName=" << destProcess()->name() );
  if (dest()) BUGOUT( "dest()=" << dest()->name() );
  BUGOUT( "className=" << className()  );
  BUGOUT( "id=" << id() );
  BUGOUT( "retmsg=" << isReturnMsg );
  if (source()) {
    BUGOUT( "srcProcName=" << source()->process()->name() );
    BUGOUT( "srcName=" << source()->name() );
  }
  BUGOUT( "this = " << (long)this << ", otsoMostDerivedPointer = " << (long)otsoMostDerivedPointer() );
#endif

  od << *multiPtr()
     << className() 
     << id()
     << isReturnMsg
   //<< priority()
     ;

  if (isReturnMsg) {
    if (returnValueType_ != otsoType_void)
      returnValueType_->encode(od, returnValue());		//return value
    outEncode(od);						//arguments
    delete this;
  }
  else {
    otsoType().Type::encode(od, otsoMostDerivedPointer());	//arguments
    if (returnValueType_ == otsoType_async) delete this;
  }
  od.flush();
}

void Message::outEncode(ODump&) {}
void Message::outDecode(IDump&) {}

                                        //returns 0
Member Message::runUI(Objectifier /*sp*/, String, String /*memberName*/) {
  setSource(dinStream, thisProcess);	//dinStream?
  setSourceName("din");
                                        //setDest() done in 
                                        //MethodMember::memberObject(2)!
  din >> *this;				//dinStream?
  if (!*dinStream) {OTSO_WARNING("Bad input\n");}
  setPriority(runImmediately);          //Most often we want to process this
                                        //message immediately.
                                        //Remember that sp may be temporary.
                                        //What about async fns?

  		                        //send() returns the object returned 
                                        //by the execution of this message.
                                        //It could be returned as the next 
                                        //object for further commands (from
                                        //other than void/async functions),
                                        //but it would be hard to delete the
                                        //message when the returnValue is no
                                        //more used. Therefore,the returnValue
                                        //is only printed here and nothing 
                                        //returned.
#if SIMULATING
  if (otsoJuhaIsDebugging && globals->simulating()) {
    if (::otsoTimedMessageRunUI(this))
      return 0;
    //else try in the normal way ...
  }
#endif
  {
    Message* ret = send(); 		
    if (ret && 
	ret->returnValueType_ != otsoType_void && 
	ret->returnValueType_ != otsoType_async
	)
          dout << *ret << "\n";               
    delete ret;                           
  }

  return 0;                             
}

/**********************************************************************/

Object* Message::source() {
  if (isReturnMsg)
    return agent()->dest();
  else
    return agent()->source();
}

Process* Message::sourceProcess() {
  if (isReturnMsg)
    return agent()->destProcess();
  else
    return agent()->sourceProcess();
} 

String Message::sourceName() const {
  if (!isReturnMsg && multiPtr() && multiPtr()->agent())
    return multiPtr()->agent()->sourceName();
  else if (isReturnMsg && agent() && agent()->dest()) 
    return agent()->dest()->name();
  else {
    OTSO_ERROR("Sorry, Message::sourceName unknown, returning empty string");
    return "";		//isEmpty() true
  }
}

void Message::setSourceName(const String& n) {
  if (multiPtr() && multiPtr()->agent())
    multiPtr()->agent()->setSourceName(n);
  else
    OTSO_WARNING("Sorry, could not complete " << className() << "::setSourceName(" << n << ") - agent missing");
}

Object* Message::dest() {
  if (isReturnMsg)
    return agent()->source();
  else
    return agent()->dest();
}

void Message::setSource(Object* suO, Process* suP, ConnectionId) {
  if (isReturnMsg)
    OTSO_WARNING( "setSource for returnMsg == ???" );
  agent()->setSource(suO, suP);
}

void Message::setDest(Object* spO, Process* spP, ConnectionId) {
  if (isReturnMsg)
    OTSO_WARNING( "setDest for returnMsg == ???" );
  agent()->setDest(spO, spP);
}

Agent* Message::agent() {
  OTSO_WARNING("Message::agent() returns 0 pointer");
  return 0;
}

void Message::setHandlerPart(void* p) {
  agent()->setSPInterface(p);
}

/************** Return values ****************************************/

#if 0
ReturnValue Message::sendAndReturnAValue() {
  if (!source()) {
    OTSO_ERROR("source() = 0 in " << className() << "::sendAndReturnAValue().  Message not sent.");
    OTSO_ERROR("Message::sendAndReturnAValue() returns NULL pointer");
    return 0;
  }

  this->isReturnMsg = false;
  source()->sendOrQueue(*this);

  if (isReturnMsg)		//Message was already handled
    return 0;			//Juha 22.4.92 ???

  //Don't delete this message before the return value has been received

  Runner* ss = source()->myScheduler();
  if (!isReturnMsg)			//we must wait for answer
    ss->runUntilIsReturnMsg(this);
  else
    OTSO_WARNING("OTSO internal error: a return message in Message::sendAndReturnAValue()");
  
  //...
  
  OTSO_ASSERT(isReturnMsg);
  OTSO_ASSERT(id_ == ss->receivedMessageId);
  OTSO_ASSERT(dest()->myScheduler() == ss);
  //if (this->otsoMostDerivedPointer() != ss->suspendedMessage(ss->receivedMessageId)) OTSO_ERROR("Scheduler exited although no return message received.");
  ss->receivedMessageId = 0;
  return this->otsoMostDerivedPointer();
}

void Message::suspend() {
  OTSO_WARNING("**** Message::suspend not implemented properly ********");
  Scheduler* ss = source()->myScheduler();
  this->id_ = ss->getMsgId();
  ss->setReturnValue(id, this->otsoMostDerivedPointer);
  initiator()->suspend();
}

void Runner::suspend() {
  OTSO_WARNING("**** Runner::suspend not implemented properly ********");
}

void Message::from(IDump& id) {
  //IDump::run decodes the message except the parameters

  Runner* ss = 0;
  if (isReturnMsg) {
    ss = dest()->myScheduler();
    OTSO_ASSERT(ss->suspendedMessage(id_) == this);
    dout << "@@@ resetting suspendedMessages[" << id_ << "]\n";
    ss->suspendedMessage(id_) = 0;
    if (returnValueType_ != otsoType_void)
      returnValueType_->decode(id, returnValue());		//return value
    outDecode(id);						//arguments
  }
  else {
    //ss = source()->myScheduler();	//commented out 20.7.92
    otsoType().Type::decode(id, otsoMostDerivedPointer());	//arguments
  }

  if (isReturnMsg) {
    OTSO_ASSERT(this->id() < ss->numberOfSuspendedMessages);
    JUHA_DEBUG(" receivedMessageId = " << id_ );
    this->wakeup((Runner*)0);					//0 not used
    OTSO_ASSERT(this == this->otsoMostDerivedPointer());
  }
  else {
    Object* od = dest();
    Object* os = od -> server();
    os -> runOrQueue(*this);
  }
}

void Message::sendReturnValue(ReturnValue retVal) {
  OTSO_ASSERT(retVal == otsoMostDerivedPointer());

  isReturnMsg = true;

  Runner* ss = dest()->myScheduler();
  if (destProcess() -> local()) {
    //OTSO_ASSERT(ss->suspendedMessage(id_));
    dout << "@@@ " << ss->name() << ".receivedMessageId = " << id_ << "\n";
    ss->receivedMessageId = id_;
  }
  else {
    ;					//see Runner::sendOrQueue
  }
  if (!source())
    OTSO_ERROR("source() = 0 in " << className() << "::sendReturnValue().  Message not sent.");
  else 
    source()->sendOrQueue(*this);
}

#else	/*Juha 1 {*/

ReturnValue Message::sendAndReturnAValue() {

  JUHA_DEBUG("sendAndReturnAValue()");
  if (!source()) {
    OTSO_ERROR("source() = 0 in " << className() << "::sendAndReturnAValue().  Message not sent.");
    OTSO_ERROR("Message::sendAndReturnAValue() returns 0 pointer");
    return 0;
  }

  this->isReturnMsg = false;
  source()->sendOrQueue(*this);

  if (isReturnMsg) 		//Message was already handled
    return 0;			//Juha 22.4.92 ???

  //Don't delete this message before the return value has been received

  Runner* ss = source()->myScheduler();
  //ss->runUntilIsReturnMsg(this);	//we must wait for answer

  this->suspend();
  //...running other Runners until return value to this message has arrived...

  JUHA_DEBUG("sendAndReturnAValue continuing after suspend() ...");
  OTSO_ASSERT(isReturnMsg);
  OTSO_ASSERT(id_ == ss->receivedMessageId);
  OTSO_ASSERT(dest()->myScheduler() == ss);
  //if (this->otsoMostDerivedPointer() != ss->suspendedMessage(ss->receivedMessageId)) OTSO_ERROR("Scheduler exited although no return message received.");

  ReturnValue rv = ss->getReturnValue(id_);
  OTSO_ASSERT(rv == this->otsoMostDerivedPointer());
  ss->receivedMessageId = 0;		//move to end of run() ?
  return this->otsoMostDerivedPointer();
}

void Message::suspend() {
  JUHA_DEBUG("suspend()");
    //should be Scheduler*
  Runner* ss = source()->myScheduler();
  MsgId i = ss->getMsgId();
  OTSO_ASSERT(this->id_ == i);
  //this->id_ = ss->getMsgId();
  ss->setReturnValue(this->id_, this->otsoMostDerivedPointer());
  initiator()->runStatus = RunStatus::blocking;	//move to Runner::suspend?
  initiator()->suspend();
}

void Runner::suspend() {
  JUHA_DEBUG("suspend() entering");
  JUHA_DEBUG("Risky type cast from Runner* to Scheduler*");
  Scheduler* ss = (Scheduler*)myScheduler();
  if (this->runStatus != RunStatus::blocking) {	//not called from 
    requestScheduling();			//Message::suspend
    this->runStatus = RunStatus::enabled;
    ss->blockedRunner = this;			//see Scheduler::run()!
  }
  JUHA_DEBUG("runStatus now " << runStatus);
    //put these to Scheduler::suspend() : 
  ss->enabledBlockedRunner = 0;			//see lwpVOPSBody()
  ss->rerun(); 					//?
  JUHA_DEBUG("suspend() exiting");
}

void Message::from(IDump& id) {
  //IDump::run decodes the message except the parameters

  Runner* ss = 0;
  if (isReturnMsg) {
    ss = dest()->myScheduler();
    OTSO_ASSERT(ss->suspendedMessage(id_) == this);
    JUHA_DEBUG("resetting suspendedMessages[" << id_ << "]");
    ss->suspendedMessage(id_) = 0;
    if (returnValueType_ != otsoType_void)
      returnValueType_->decode(id, returnValue());		//return value
    outDecode(id);						//arguments
  }
  else {
    //ss = source()->myScheduler();	//commented out 20.7.92
    otsoType().Type::decode(id, otsoMostDerivedPointer());	//arguments
  }

  if (isReturnMsg) {
    OTSO_ASSERT(this->id() <= ss->numberOfSuspendedMessages);
    JUHA_DEBUG( "receivedMessageId = " << id_ );
    ss->receivedMessageId = id_;
    if (this != otsoMostDerivedPointer())
      OTSO_WARNING("Message::from() assert failed: this != otsoMostDerivedPointer()");
  }
  else {
    Object* od = dest();
    Object* os = od -> server();
    os -> runOrQueue(*this);
  }
}

void Message::sendReturnValue(ReturnValue retVal) {
  JUHA_DEBUG("sendReturnValue() entering");
  OTSO_ASSERT(retVal == otsoMostDerivedPointer());

  isReturnMsg = true;
  if (!source())
    OTSO_ERROR("source() = 0 in " << className() << "::sendReturnValue().  Message not sent.");
  else 
    source()->sendOrQueue(*this);
}
#endif

void Message::wakeup(Runner*) {
  JUHA_DEBUG("::wakeup()");
  Runner* ss = initiator()->myScheduler();
  OTSO_ASSERT(ss->suspendedMessage(id_) == this);
  ss->receivedMessageId = id_;
  initiator()->wakeup(this);
}

void Runner::wakeup(Runner* rp) {
  JUHA_DEBUG("::wakeup(" << rp->name() << ")");  
  OTSO_ASSERT(this->runStatus == RunStatus::blocking);
  this->runStatus = RunStatus::enabled;
  myScheduler()->wakeup(this);
}

void Scheduler::wakeup(Runner* rp) {
  JUHA_DEBUG("::wakeup(" << rp->name() << ")");  
  this->enabledBlockedRunner = rp;		//see lwpVOPSBody()
}

Runner* Message::initiator() {
  JUHA_DEBUG("Risky type cast from Object* to Runner*");
  return (Runner*)agent()->source();
}

Runner* Message::responder() {
  JUHA_DEBUG("Risky type cast from Object* to Runner*");
  return (Runner*)agent()->dest();
}

