/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.inta.cxx
 * Vers: 5.3    Time: 92/08/14, 10:58:02
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)inta.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
FILE inta.cxx : this is (mostly) generated code.
The output of running object.hxx, runner.hxx, and channel.hxx through prepro
is sent to inta.hxx and inta.cxx.  inta.sed and inta.ch 
(and possibly manual corrections) are also needed when generating inta.cxx.

In principle, inta.cxx and inta.hxx can be recreated by "make inta.cxx".
But you can't rely on this -- manual corrections may be needed.  Use diff!
**********************************************************************/

#include "OTSO.hxx"

/**** Moved here manually, must be initialized before msgs to them ******/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Message,
 ( OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));
IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Runner,
( ( OTSO_PUBLIC_BASE_CLASS(RunnerSP,"Runner interface ")
   ,OTSO_PUBLIC_BASE_CLASS(Object,"")
  )
));

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Istream,
 ( OTSO_PUBLIC_BASE_CLASS(Runner,"")
  ,OTSO_PUBLIC_BASE_CLASS(IstreamSP,"")
 ));
IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Ostream,
 ( OTSO_PUBLIC_BASE_CLASS(Runner,"")
  ,OTSO_PUBLIC_BASE_CLASS(OstreamSP,"")
 ));
IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(NamedObj,
  ( OTSO_PUBLIC_BASE_CLASS(Object,"")
  ));
IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(String,
  ( OTSO_PUBLIC_BASE_CLASS(Object,"")
  ));
IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(MultiPtr,
  ( OTSO_PUBLIC_BASE_CLASS(Object,"")
  ));




#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class Object
**********************************************************************/

/********** Object_agent *****************************/

String Object_agent::className() const {return "Object_agent";}

Object_agent::Object_agent(Object* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

Object_agent::~Object_agent() {}

Object* Object_agent::sPInterface() {return sPInterface_;}

void Object_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (Object*)p : this );
}

/********** ObjectPtr *****************************/

String ObjectPtr::className() const {return "ObjectPtr";}

ObjectPtr::ObjectPtr(const ObjectPtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

ObjectPtr::ObjectPtr()
  : dap(new Object_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

ObjectPtr::ObjectPtr(Object* i, Object* o)
  : dap(new Object_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

ObjectPtr::ObjectPtr(sint8) : dap(0) {}

ObjectPtr::ObjectPtr(const Agent& staticAgent) 
  : dap(new Object_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'Object'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

ObjectPtr::~ObjectPtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* ObjectPtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void ObjectPtr::setAgent(Object_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

ObjectPtr::operator Object* () {return operator->();}

Object* ObjectPtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    Object_agent* ret = new Object_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("ObjectPtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void ObjectPtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    Object_agent* a = new Object_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void ObjectPtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void ObjectPtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

ObjectPtr& ObjectPtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

ObjectPtr& ObjectPtr::operator=(const ObjectPtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    Object_agent* r = rhs.dap;
    Object_agent* newDap = new Object_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((Object*)dap);
      dap->Agent::setName(r->Agent::name());
    }
#if SIMULATING
    setOtsoSimuDest(dap);
#endif
    dap->Agent::connect();
  }
  return *this;
}


/************** code for Object_printToDout ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Object_printToDout, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String Object_printToDout::className() const {return "print";}

Message* Object_printToDout::send() {
  return (Object_printToDout*)sendAndReturnAValue();
}

Agent* Object_printToDout::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* Object_printToDout::multiPtr() {return &otsoPtr;}

void Object_agent::printToDout_in {
  Object_printToDout* otsoTmpMsg = new printToDout_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_Object_printToDout() {
  return new Object_printToDout;
}

void Object_printToDout::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->print(dout);
  sendReturnValue(this);
  return;
}

Object_printToDout::Object_printToDout() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(Object_printToDout*) defined
  setPriority(otsoRunnerPriority(this));
}

Object_printToDout::~Object_printToDout() {}


/************** code for Object_askFromDin ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Object_askFromDin, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String Object_askFromDin::className() const {return "=";}

Message* Object_askFromDin::send() {
  return (Object_askFromDin*)sendAndReturnAValue();
}

Agent* Object_askFromDin::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* Object_askFromDin::multiPtr() {return &otsoPtr;}

void Object_agent::askFromDin_in {
  Object_askFromDin* otsoTmpMsg = new askFromDin_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_Object_askFromDin() {
  return new Object_askFromDin;
}

void Object_askFromDin::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->ask(*dinStream);
  sendReturnValue(this);
  return;
}

Object_askFromDin::Object_askFromDin() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(Object_askFromDin*) defined
  setPriority(otsoRunnerPriority(this));
}

Object_askFromDin::~Object_askFromDin() {}

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(Object,
  ( OTSO_RENAMED_METHOD_MEMBER(Object,printToDout,"print","Output this to dout. ")
   ,OTSO_RENAMED_METHOD_MEMBER(Object,askFromDin,"=","Ask this from din. ")
  ));

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/

#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class RunnerTrace
**********************************************************************/

/********** RunnerTrace_agent *****************************/

String RunnerTrace_agent::className() const {return "RunnerTrace_agent";}

RunnerTrace_agent::RunnerTrace_agent(RunnerTrace* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

RunnerTrace_agent::~RunnerTrace_agent() {}

RunnerTrace* RunnerTrace_agent::sPInterface() {return sPInterface_;}

void RunnerTrace_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (RunnerTrace*)p : this );
}

/********** RunnerTracePtr *****************************/

String RunnerTracePtr::className() const {return "RunnerTracePtr";}

RunnerTracePtr::RunnerTracePtr(const RunnerTracePtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

RunnerTracePtr::RunnerTracePtr()
  : dap(new RunnerTrace_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

RunnerTracePtr::RunnerTracePtr(RunnerTrace* i, Object* o)
  : dap(new RunnerTrace_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

RunnerTracePtr::RunnerTracePtr(sint8) : dap(0) {}

RunnerTracePtr::RunnerTracePtr(const Agent& staticAgent) 
  : dap(new RunnerTrace_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'RunnerTrace'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

RunnerTracePtr::~RunnerTracePtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* RunnerTracePtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void RunnerTracePtr::setAgent(RunnerTrace_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

RunnerTracePtr::operator RunnerTrace* () {return operator->();}

RunnerTrace* RunnerTracePtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    RunnerTrace_agent* ret = new RunnerTrace_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("RunnerTracePtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void RunnerTracePtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    RunnerTrace_agent* a = new RunnerTrace_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void RunnerTracePtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void RunnerTracePtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

RunnerTracePtr& RunnerTracePtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

RunnerTracePtr& RunnerTracePtr::operator=(const RunnerTracePtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    RunnerTrace_agent* r = rhs.dap;
    RunnerTrace_agent* newDap = new RunnerTrace_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((RunnerTrace*)dap);
      dap->Agent::setName(r->Agent::name());
    }
#if SIMULATING
    setOtsoSimuDest(dap);
#endif
    dap->Agent::connect();
  }
  return *this;
}


/************** code for RunnerTrace_allOn ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerTrace_allOn, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerTrace_allOn::className() const {return "allOn";}

Agent* RunnerTrace_allOn::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerTrace_allOn::multiPtr() {return &otsoPtr;}

async RunnerTrace_agent::allOn_in {
  RunnerTrace_allOn* otsoTmpMsg = new allOn_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
} /*?*/

NewMsg* new_RunnerTrace_allOn() {
  return new RunnerTrace_allOn;
}

void RunnerTrace_allOn::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->allOn_out;
  delete this;
  return;
}

RunnerTrace_allOn::RunnerTrace_allOn() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerTrace_allOn*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerTrace_allOn::~RunnerTrace_allOn() {}


/************** code for RunnerTrace_allOff ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerTrace_allOff, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerTrace_allOff::className() const {return "allOff";}

Agent* RunnerTrace_allOff::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerTrace_allOff::multiPtr() {return &otsoPtr;}

async RunnerTrace_agent::allOff_in {
  RunnerTrace_allOff* otsoTmpMsg = new allOff_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
} /*?*/

NewMsg* new_RunnerTrace_allOff() {
  return new RunnerTrace_allOff;
}

void RunnerTrace_allOff::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->allOff_out;
  delete this;
  return;
}

RunnerTrace_allOff::RunnerTrace_allOff() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerTrace_allOff*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerTrace_allOff::~RunnerTrace_allOff() {}


/************** code for RunnerTrace_setDefault ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerTrace_setDefault, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerTrace_setDefault::className() const {return "setDefault";}

Agent* RunnerTrace_setDefault::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerTrace_setDefault::multiPtr() {return &otsoPtr;}

async RunnerTrace_agent::setDefault_in {
  RunnerTrace_setDefault* otsoTmpMsg = new setDefault_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
} /*?*/

NewMsg* new_RunnerTrace_setDefault() {
  return new RunnerTrace_setDefault;
}

void RunnerTrace_setDefault::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->setDefault_out;
  delete this;
  return;
}

RunnerTrace_setDefault::RunnerTrace_setDefault() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerTrace_setDefault*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerTrace_setDefault::~RunnerTrace_setDefault() {}

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerTrace,
  ( OTSO_METHOD_MEMBER(RunnerTrace,allOn,"Set all tracing on. ")
   ,OTSO_METHOD_MEMBER(RunnerTrace,allOff,"Set all tracing off. ")
   ,OTSO_METHOD_MEMBER(RunnerTrace,setDefault,"Set default tracing on. ")
   ,OTSO_DATA_MEMBER(boolean,running," ")
   ,OTSO_DATA_MEMBER(boolean,variablesBefore," ")
   ,OTSO_DATA_MEMBER(boolean,receiving," ")
   ,OTSO_DATA_MEMBER(boolean,inputParameters," ")
   ,OTSO_DATA_MEMBER(boolean,actions," ")
   ,OTSO_DATA_MEMBER(boolean,sending,"	 ")
   ,OTSO_DATA_MEMBER(boolean,outputParameters," ")
   ,OTSO_DATA_MEMBER(boolean,variablesAfter," ")
   ,OTSO_DATA_MEMBER(boolean,verbose," ")
   ,OTSO_PUBLIC_BASE_CLASS(Object,"")
  ));

/**********************************************************************
  Generated by OTSO prepro for class RunnerSP
**********************************************************************/

/********** RunnerSP_agent *****************************/

String RunnerSP_agent::className() const {return "RunnerSP_agent";}

RunnerSP_agent::RunnerSP_agent(RunnerSP* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

RunnerSP_agent::~RunnerSP_agent() {}

RunnerSP* RunnerSP_agent::sPInterface() {return sPInterface_;}

void RunnerSP_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (RunnerSP*)p : this );
}

/********** RunnerSPPtr *****************************/

String RunnerSPPtr::className() const {return "RunnerSPPtr";}

RunnerSPPtr::RunnerSPPtr(const RunnerSPPtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

RunnerSPPtr::RunnerSPPtr()
  : dap(new RunnerSP_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

RunnerSPPtr::RunnerSPPtr(RunnerSP* i, Object* o)
  : dap(new RunnerSP_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

RunnerSPPtr::RunnerSPPtr(sint8) : dap(0) {}

RunnerSPPtr::RunnerSPPtr(const Agent& staticAgent) 
  : dap(new RunnerSP_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'RunnerSP'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

RunnerSPPtr::~RunnerSPPtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* RunnerSPPtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void RunnerSPPtr::setAgent(RunnerSP_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

RunnerSPPtr::operator RunnerSP* () {return operator->();}

RunnerSP* RunnerSPPtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    RunnerSP_agent* ret = new RunnerSP_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("RunnerSPPtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void RunnerSPPtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    RunnerSP_agent* a = new RunnerSP_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void RunnerSPPtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void RunnerSPPtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

RunnerSPPtr& RunnerSPPtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

RunnerSPPtr& RunnerSPPtr::operator=(const RunnerSPPtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    RunnerSP_agent* r = rhs.dap;
    RunnerSP_agent* newDap = new RunnerSP_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((RunnerSP*)dap);
      dap->Agent::setName(r->Agent::name());
    }
#if SIMULATING
    setOtsoSimuDest(dap);
#endif
    dap->Agent::connect();
  }
  return *this;
}


/************** code for RunnerSP_run ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerSP_run, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerSP_run::className() const {return "run";}

Message* RunnerSP_run::send() {
  return (RunnerSP_run*)sendAndReturnAValue();
}

Agent* RunnerSP_run::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerSP_run::multiPtr() {return &otsoPtr;}

void RunnerSP_agent::run_in {
  RunnerSP_run* otsoTmpMsg = new run_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_RunnerSP_run() {
  return new RunnerSP_run;
}

void RunnerSP_run::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->run_out;
  sendReturnValue(this);
  return;
}

RunnerSP_run::RunnerSP_run() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerSP_run*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerSP_run::~RunnerSP_run() {}


/************** code for RunnerSP_run1 ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerSP_run1, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerSP_run1::className() const {return "run1";}

Message* RunnerSP_run1::send() {
  return (RunnerSP_run1*)sendAndReturnAValue();
}

Agent* RunnerSP_run1::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerSP_run1::multiPtr() {return &otsoPtr;}

void RunnerSP_agent::run1_in {
  RunnerSP_run1* otsoTmpMsg = new run1_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_RunnerSP_run1() {
  return new RunnerSP_run1;
}

void RunnerSP_run1::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->run1_out;
  sendReturnValue(this);
  return;
}

RunnerSP_run1::RunnerSP_run1() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerSP_run1*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerSP_run1::~RunnerSP_run1() {}


/************** code for RunnerSP_setPriority ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerSP_setPriority, 
 ( OTSO_DATA_MEMBER(RunnerSP::RunnerPriority,priority,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerSP_setPriority::className() const {return "setPriority";}

Message* RunnerSP_setPriority::send() {
  return (RunnerSP_setPriority*)sendAndReturnAValue();
}

Agent* RunnerSP_setPriority::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerSP_setPriority::multiPtr() {return &otsoPtr;}

void RunnerSP_agent::setPriority_in {
  RunnerSP_setPriority* otsoTmpMsg = new setPriority_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_RunnerSP_setPriority() {
  return new RunnerSP_setPriority;
}

void RunnerSP_setPriority::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->setPriority_out;
  sendReturnValue(this);
  return;
}

RunnerSP_setPriority::RunnerSP_setPriority() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerSP_setPriority*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerSP_setPriority::~RunnerSP_setPriority() {}

RunnerSP_setPriority::RunnerSP_setPriority(RunnerSP::RunnerPriority ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, priority(ddOTSOp0)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerSP_setPriority*) defined
  setPriority(otsoRunnerPriority(this));
}

void RunnerSP_setPriority::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &priority);
}

void RunnerSP_setPriority::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &priority);
}


/************** code for RunnerSP_timeout ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(RunnerSP_timeout, 
 ( OTSO_DATA_MEMBER(sint32,id,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String RunnerSP_timeout::className() const {return "timeout";}

Agent* RunnerSP_timeout::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* RunnerSP_timeout::multiPtr() {return &otsoPtr;}

async RunnerSP_agent::timeout_in {
  RunnerSP_timeout* otsoTmpMsg = new timeout_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
} /*?*/

NewMsg* new_RunnerSP_timeout() {
  return new RunnerSP_timeout;
}

void RunnerSP_timeout::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->timeout_out;
  delete this;
  return;
}

RunnerSP_timeout::RunnerSP_timeout() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerSP_timeout*) defined
  setPriority(otsoRunnerPriority(this));
}

RunnerSP_timeout::~RunnerSP_timeout() {}

RunnerSP_timeout::RunnerSP_timeout(sint32 ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, id(ddOTSOp0)
{
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(RunnerSP_timeout*) defined
  setPriority(otsoRunnerPriority(this));
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(RunnerSP,
  ( OTSO_METHOD_MEMBER(RunnerSP,run,"Activates this to perform actions. ")
   ,OTSO_METHOD_MEMBER(RunnerSP,run1,"Activates this to handle one event. ")
   ,OTSO_METHOD_MEMBER(RunnerSP,setPriority,"Set the priority. ")
   ,OTSO_METHOD_MEMBER(RunnerSP,timeout,"  ")
   ,OTSO_DATA_MEMBER(RunnerTrace,trace,"Controls the amount of output that is printed when this is activated. ")
   ,OTSO_DATA_MEMBER(RunnerPriority,priority_,"Scheduling priority in priority queue. ")
   ,OTSO_DATA_MEMBER(RunStatus,runStatus,"Scheduling permission ")
   ,OTSO_DATA_MEMBER(GroupPointer,iQ,"Queue of input events (Runners, messages). ")
  ));

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/

#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class IstreamSP
**********************************************************************/

/********** IstreamSP_agent *****************************/

String IstreamSP_agent::className() const {return "IstreamSP_agent";}

IstreamSP_agent::IstreamSP_agent(IstreamSP* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

IstreamSP_agent::~IstreamSP_agent() {}

IstreamSP* IstreamSP_agent::sPInterface() {return sPInterface_;}

void IstreamSP_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (IstreamSP*)p : this );
}

/********** IstreamSPPtr *****************************/

String IstreamSPPtr::className() const {return "IstreamSPPtr";}

IstreamSPPtr::IstreamSPPtr(const IstreamSPPtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

IstreamSPPtr::IstreamSPPtr()
  : dap(new IstreamSP_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

IstreamSPPtr::IstreamSPPtr(IstreamSP* i, Object* o)
  : dap(new IstreamSP_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

IstreamSPPtr::IstreamSPPtr(sint8) : dap(0) {}

IstreamSPPtr::IstreamSPPtr(const Agent& staticAgent) 
  : dap(new IstreamSP_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'IstreamSP'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

IstreamSPPtr::~IstreamSPPtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* IstreamSPPtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void IstreamSPPtr::setAgent(IstreamSP_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

IstreamSPPtr::operator IstreamSP* () {return operator->();}

IstreamSP* IstreamSPPtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    IstreamSP_agent* ret = new IstreamSP_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("IstreamSPPtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void IstreamSPPtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    IstreamSP_agent* a = new IstreamSP_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void IstreamSPPtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void IstreamSPPtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

IstreamSPPtr& IstreamSPPtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

IstreamSPPtr& IstreamSPPtr::operator=(const IstreamSPPtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    IstreamSP_agent* r = rhs.dap;
    IstreamSP_agent* newDap = new IstreamSP_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((IstreamSP*)dap);
      dap->Agent::setName(r->Agent::name());
    }
#if SIMULATING
    setOtsoSimuDest(dap);
#endif
    dap->Agent::connect();
  }
  return *this;
}


/************** code for IstreamSP_Exit ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(IstreamSP_Exit, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String IstreamSP_Exit::className() const {return "Exit";}

Message* IstreamSP_Exit::send() {
  return (IstreamSP_Exit*)sendAndReturnAValue();
}

Agent* IstreamSP_Exit::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* IstreamSP_Exit::multiPtr() {return &otsoPtr;}

void IstreamSP_agent::Exit_in {
  IstreamSP_Exit* otsoTmpMsg = new Exit_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_IstreamSP_Exit() {
  return new IstreamSP_Exit;
}

void IstreamSP_Exit::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->Exit_out;
  sendReturnValue(this);
  return;
}

IstreamSP_Exit::IstreamSP_Exit() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_Exit*) defined
  setPriority(otsoRunnerPriority(this));
}

IstreamSP_Exit::~IstreamSP_Exit() {}


/************** code for IstreamSP_debug ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(IstreamSP_debug, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String IstreamSP_debug::className() const {return "debug";}

Message* IstreamSP_debug::send() {
  return (IstreamSP_debug*)sendAndReturnAValue();
}

Agent* IstreamSP_debug::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* IstreamSP_debug::multiPtr() {return &otsoPtr;}

void IstreamSP_agent::debug_in {
  IstreamSP_debug* otsoTmpMsg = new debug_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_IstreamSP_debug() {
  return new IstreamSP_debug;
}

void IstreamSP_debug::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->debug_out;
  sendReturnValue(this);
  return;
}

IstreamSP_debug::IstreamSP_debug() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_debug*) defined
  setPriority(otsoRunnerPriority(this));
}

IstreamSP_debug::~IstreamSP_debug() {}


/************** code for IstreamSP_outputRedirection ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(IstreamSP_outputRedirection, 
 ( OTSO_DATA_MEMBER(String,filename,"")
  ,OTSO_DATA_MEMBER(boolean,isDoutLoggingThereToo,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String IstreamSP_outputRedirection::className() const {return ">";}

Message* IstreamSP_outputRedirection::send() {
  return (IstreamSP_outputRedirection*)sendAndReturnAValue();
}

Agent* IstreamSP_outputRedirection::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* IstreamSP_outputRedirection::multiPtr() {return &otsoPtr;}

void IstreamSP_agent::outputRedirection_in {
  IstreamSP_outputRedirection* otsoTmpMsg = new outputRedirection_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_IstreamSP_outputRedirection() {
  return new IstreamSP_outputRedirection;
}

void IstreamSP_outputRedirection::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->outputRedirection_out;
  sendReturnValue(this);
  return;
}

IstreamSP_outputRedirection::IstreamSP_outputRedirection() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_outputRedirection*) defined
  setPriority(otsoRunnerPriority(this));
}

IstreamSP_outputRedirection::~IstreamSP_outputRedirection() {}

IstreamSP_outputRedirection::IstreamSP_outputRedirection(String ddOTSOp0, boolean ddOTSOp1)
		: otsoPtr(0 /*no new agent*/)
		, filename(ddOTSOp0)
		, isDoutLoggingThereToo(ddOTSOp1)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_outputRedirection*) defined
  setPriority(otsoRunnerPriority(this));
}

void IstreamSP_outputRedirection::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &filename);
  otsoOutEncode(od, &isDoutLoggingThereToo);
}

void IstreamSP_outputRedirection::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &filename);
  otsoOutDecode(id, &isDoutLoggingThereToo);
}


/************** code for IstreamSP_inputRedirection ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(IstreamSP_inputRedirection, 
 ( OTSO_DATA_MEMBER(String,filename,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String IstreamSP_inputRedirection::className() const {return "<";}

Message* IstreamSP_inputRedirection::send() {
  return (IstreamSP_inputRedirection*)sendAndReturnAValue();
}

Agent* IstreamSP_inputRedirection::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* IstreamSP_inputRedirection::multiPtr() {return &otsoPtr;}

void IstreamSP_agent::inputRedirection_in {
  IstreamSP_inputRedirection* otsoTmpMsg = new inputRedirection_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_IstreamSP_inputRedirection() {
  return new IstreamSP_inputRedirection;
}

void IstreamSP_inputRedirection::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->inputRedirection_out;
  sendReturnValue(this);
  return;
}

IstreamSP_inputRedirection::IstreamSP_inputRedirection() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_inputRedirection*) defined
  setPriority(otsoRunnerPriority(this));
}

IstreamSP_inputRedirection::~IstreamSP_inputRedirection() {}

IstreamSP_inputRedirection::IstreamSP_inputRedirection(String ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, filename(ddOTSOp0)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_inputRedirection*) defined
  setPriority(otsoRunnerPriority(this));
}

void IstreamSP_inputRedirection::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &filename);
}

void IstreamSP_inputRedirection::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &filename);
}


/************** code for IstreamSP_logInputToFile ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(IstreamSP_logInputToFile, 
 ( OTSO_DATA_MEMBER(boolean,yes_1_or_no_0,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String IstreamSP_logInputToFile::className() const {return "logInputToFile";}

Message* IstreamSP_logInputToFile::send() {
  return (IstreamSP_logInputToFile*)sendAndReturnAValue();
}

Agent* IstreamSP_logInputToFile::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* IstreamSP_logInputToFile::multiPtr() {return &otsoPtr;}

void IstreamSP_agent::logInputToFile_in {
  IstreamSP_logInputToFile* otsoTmpMsg = new logInputToFile_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_IstreamSP_logInputToFile() {
  return new IstreamSP_logInputToFile;
}

void IstreamSP_logInputToFile::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->logInputToFile_out;
  sendReturnValue(this);
  return;
}

IstreamSP_logInputToFile::IstreamSP_logInputToFile() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_logInputToFile*) defined
  setPriority(otsoRunnerPriority(this));
}

IstreamSP_logInputToFile::~IstreamSP_logInputToFile() {}

IstreamSP_logInputToFile::IstreamSP_logInputToFile(boolean ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, yes_1_or_no_0(ddOTSOp0)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(IstreamSP_logInputToFile*) defined
  setPriority(otsoRunnerPriority(this));
}

void IstreamSP_logInputToFile::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &yes_1_or_no_0);
}

void IstreamSP_logInputToFile::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &yes_1_or_no_0);
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(IstreamSP,
  ( OTSO_METHOD_MEMBER(IstreamSP,Exit,"  exit OTSO ")
   ,OTSO_METHOD_MEMBER(IstreamSP,debug,"Go to debugger (set a break point in ::debug()) ")
   ,OTSO_RENAMED_METHOD_MEMBER(IstreamSP,outputRedirection,">","logging: copy input and output  to a file ")
   ,OTSO_RENAMED_METHOD_MEMBER(IstreamSP,inputRedirection,"<","read command input from a file ")
   ,OTSO_METHOD_MEMBER(IstreamSP,logInputToFile,"Set din input logging to file  on or off. ")
  ));

/**********************************************************************
  Generated by OTSO prepro for class OstreamSP
**********************************************************************/

/********** OstreamSP_agent *****************************/

String OstreamSP_agent::className() const {return "OstreamSP_agent";}

OstreamSP_agent::OstreamSP_agent(OstreamSP* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

OstreamSP_agent::~OstreamSP_agent() {}

OstreamSP* OstreamSP_agent::sPInterface() {return sPInterface_;}

void OstreamSP_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (OstreamSP*)p : this );
}

/********** OstreamSPPtr *****************************/

String OstreamSPPtr::className() const {return "OstreamSPPtr";}

OstreamSPPtr::OstreamSPPtr(const OstreamSPPtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

OstreamSPPtr::OstreamSPPtr()
  : dap(new OstreamSP_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

OstreamSPPtr::OstreamSPPtr(OstreamSP* i, Object* o)
  : dap(new OstreamSP_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

OstreamSPPtr::OstreamSPPtr(sint8) : dap(0) {}

OstreamSPPtr::OstreamSPPtr(const Agent& staticAgent) 
  : dap(new OstreamSP_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'OstreamSP'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

OstreamSPPtr::~OstreamSPPtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* OstreamSPPtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void OstreamSPPtr::setAgent(OstreamSP_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

OstreamSPPtr::operator OstreamSP* () {return operator->();}

OstreamSP* OstreamSPPtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    OstreamSP_agent* ret = new OstreamSP_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("OstreamSPPtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void OstreamSPPtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    OstreamSP_agent* a = new OstreamSP_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void OstreamSPPtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void OstreamSPPtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

OstreamSPPtr& OstreamSPPtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

OstreamSPPtr& OstreamSPPtr::operator=(const OstreamSPPtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    OstreamSP_agent* r = rhs.dap;
    OstreamSP_agent* newDap = new OstreamSP_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((OstreamSP*)dap);
      dap->Agent::setName(r->Agent::name());
    }
#if SIMULATING
    setOtsoSimuDest(dap);
#endif
    dap->Agent::connect();
  }
  return *this;
}


/************** code for OstreamSP_outputLogging ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(OstreamSP_outputLogging, 
 ( OTSO_DATA_MEMBER(String,filename,"")
  ,OTSO_DATA_MEMBER(boolean,isDinLoggingThereToo,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String OstreamSP_outputLogging::className() const {return "outputLogging";}

Message* OstreamSP_outputLogging::send() {
  return (OstreamSP_outputLogging*)sendAndReturnAValue();
}

Agent* OstreamSP_outputLogging::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* OstreamSP_outputLogging::multiPtr() {return &otsoPtr;}

void OstreamSP_agent::outputLogging_in {
  OstreamSP_outputLogging* otsoTmpMsg = new outputLogging_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_OstreamSP_outputLogging() {
  return new OstreamSP_outputLogging;
}

void OstreamSP_outputLogging::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->outputLogging_out;
  sendReturnValue(this);
  return;
}

OstreamSP_outputLogging::OstreamSP_outputLogging() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(OstreamSP_outputLogging*) defined
  setPriority(otsoRunnerPriority(this));
}

OstreamSP_outputLogging::~OstreamSP_outputLogging() {}

OstreamSP_outputLogging::OstreamSP_outputLogging(String ddOTSOp0, boolean ddOTSOp1)
		: otsoPtr(0 /*no new agent*/)
		, filename(ddOTSOp0)
		, isDinLoggingThereToo(ddOTSOp1)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(OstreamSP_outputLogging*) defined
  setPriority(otsoRunnerPriority(this));
}

void OstreamSP_outputLogging::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &filename);
  otsoOutEncode(od, &isDinLoggingThereToo);
}

void OstreamSP_outputLogging::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &filename);
  otsoOutDecode(id, &isDinLoggingThereToo);
}


/************** code for OstreamSP_logOutputToFile ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(OstreamSP_logOutputToFile, 
 ( OTSO_DATA_MEMBER(boolean,yes_1_or_no_0,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String OstreamSP_logOutputToFile::className() const {return "logOutputToFile";}

Message* OstreamSP_logOutputToFile::send() {
  return (OstreamSP_logOutputToFile*)sendAndReturnAValue();
}

Agent* OstreamSP_logOutputToFile::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* OstreamSP_logOutputToFile::multiPtr() {return &otsoPtr;}

void OstreamSP_agent::logOutputToFile_in {
  OstreamSP_logOutputToFile* otsoTmpMsg = new logOutputToFile_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_OstreamSP_logOutputToFile() {
  return new OstreamSP_logOutputToFile;
}

void OstreamSP_logOutputToFile::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->logOutputToFile_out;
  sendReturnValue(this);
  return;
}

OstreamSP_logOutputToFile::OstreamSP_logOutputToFile() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(OstreamSP_logOutputToFile*) defined
  setPriority(otsoRunnerPriority(this));
}

OstreamSP_logOutputToFile::~OstreamSP_logOutputToFile() {}

OstreamSP_logOutputToFile::OstreamSP_logOutputToFile(boolean ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, yes_1_or_no_0(ddOTSOp0)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(OstreamSP_logOutputToFile*) defined
  setPriority(otsoRunnerPriority(this));
}

void OstreamSP_logOutputToFile::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &yes_1_or_no_0);
}

void OstreamSP_logOutputToFile::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &yes_1_or_no_0);
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(OstreamSP,
  ( OTSO_RENAMED_METHOD_MEMBER(OstreamSP,outputLogging,">","  logging: copy (!) output to file ")
   ,OTSO_METHOD_MEMBER(OstreamSP,logOutputToFile,"Logging dout output to file: set on or off. ")
  ));

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/
EnumInfo RunStatusRunStatusValueInfo [] = {
  {"idle", RunStatus::idle},
  {"enabled", RunStatus::enabled},
  {"blocking", RunStatus::blocking},
  {"running", RunStatus::running},
  {"_lastRunStat", RunStatus::_lastRunStat},
  {0,0}
};
IMPLEMENT_OTSO_PAED_FOR_ENUM(RunStatus,RunStatusValue)

EnumInfo RunnerSPRunnerPriorityInfo [] = {
  {"highRunnerPriority", RunnerSP::highRunnerPriority},
  {"defaultRunnerPriority", RunnerSP::defaultRunnerPriority},
  {"lowRunnerPriority", RunnerSP::lowRunnerPriority},
  {"runImmediately", RunnerSP::runImmediately},
  {0,0}
};
IMPLEMENT_OTSO_PAED_FOR_ENUM(RunnerSP,RunnerPriority)

