/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.int.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:14
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)int.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	int.cxx
*
* PURPOSE
*	An integer class for OTSO.
*
* MODIFICATIONS
* BUGS
**********************************************************************/

#define CHANNEL_HXX	1
#define INT_HXX		1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES 1	/* take only these headers */
#include "OTSO.hxx"		/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /*** dout << "###dbug int.cxx### - " << xxx << "\n" ***/

/**********************************************************************/

String Int::className() const {return "Int";}

Int::Int(sint32 i): val(i), hasVal(true) {}

Int::Int(): val(0), hasVal(false) {}

boolean Int::isEmpty() {return !hasVal;}

void Int::reset() {
  val = 0;
  hasVal = false;
}

void Int::print(Ostream& os) {
  if (hasVal) 
    os << val;
}

void Int::ask(Istream& is) {
  is >> val;
  hasVal = true;
}

void Int::to(ODump& od) {
  od << hasVal;
  if (hasVal)
    od << val;
}

void Int::from(IDump& id) {
  id >> hasVal;
  if (hasVal)
    id >> val;
}

